/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.relocation.meta;

import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.meta.MetaMediator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class FlatFileMetaMediator
implements MetaMediator {
    private final Path metaFolderPath;

    public FlatFileMetaMediator(Path metaFolderPath) {
        this.metaFolderPath = metaFolderPath;
    }

    @Override
    public String readAttribute(String name) throws IOException {
        Path attributeFile = this.metaFolderPath.resolve(name);
        if (!Files.exists(attributeFile, new LinkOption[0]) || Files.isDirectory(attributeFile, new LinkOption[0])) {
            return null;
        }
        return new String(Files.readAllBytes(attributeFile));
    }

    @Override
    public void writeAttribute(String name, String value) throws IOException {
        Path attributeFile = this.metaFolderPath.resolve(name);
        Files.deleteIfExists(attributeFile);
        Files.createFile(attributeFile, new FileAttribute[0]);
        Files.write(attributeFile, value.getBytes(), new OpenOption[0]);
    }
}

