/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.resolver;

import io.github.niestrat99.advancedteleport.libs.slimjar.logging.LogDispatcher;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.ProcessLogger;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.DependencyResolver;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.ResolutionResult;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.enquirer.RepositoryEnquirer;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.pinger.URLPinger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CachingDependencyResolver
implements DependencyResolver {
    private static final String FAILED_RESOLUTION_MESSAGE = "[FAILED TO RESOLVE]";
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final URLPinger urlPinger;
    private final Collection<RepositoryEnquirer> repositories;
    private final Map<Dependency, ResolutionResult> cachedResults = new ConcurrentHashMap<Dependency, ResolutionResult>();
    private final Map<String, ResolutionResult> preResolvedResults;

    public CachingDependencyResolver(URLPinger urlPinger, Collection<Repository> repositories, RepositoryEnquirerFactory enquirerFactory, Map<String, ResolutionResult> preResolvedResults) {
        this.urlPinger = urlPinger;
        this.preResolvedResults = new ConcurrentHashMap<String, ResolutionResult>(preResolvedResults);
        this.repositories = repositories.stream().map(enquirerFactory::create).collect(Collectors.toSet());
    }

    @Override
    public Optional<ResolutionResult> resolve(Dependency dependency) {
        return Optional.ofNullable(this.cachedResults.computeIfAbsent(dependency, dep -> this.attemptResolve((Dependency)dep, Collections.emptyList())));
    }

    public Optional<ResolutionResult> resolve(Dependency dependency, List<RepositoryEnquirer> enforcedRepositories) {
        return Optional.ofNullable(this.cachedResults.computeIfAbsent(dependency, dep -> this.attemptResolve((Dependency)dep, enforcedRepositories)));
    }

    private ResolutionResult attemptResolve(Dependency dependency, List<RepositoryEnquirer> enforcedRepositories) {
        ResolutionResult preResolvedResult;
        ResolutionResult resolutionResult = preResolvedResult = this.preResolvedResults.get(dependency.toString()) != null ? this.preResolvedResults.get(dependency.toString()) : this.cachedResults.get(dependency);
        if (preResolvedResult != null) {
            boolean isChecksumValid;
            if (preResolvedResult.isChecked()) {
                return preResolvedResult;
            }
            if (preResolvedResult.isAggregator()) {
                return preResolvedResult;
            }
            String preResolvedUrl = preResolvedResult.getRepository().url().toString();
            boolean isDependencyValid = (enforcedRepositories.isEmpty() || enforcedRepositories.stream().anyMatch(repo -> repo.toString().equals(preResolvedUrl))) && this.urlPinger.ping(preResolvedResult.getDependencyURL());
            boolean bl = isChecksumValid = preResolvedResult.getChecksumURL() == null || this.urlPinger.ping(preResolvedResult.getChecksumURL());
            if (isDependencyValid && isChecksumValid) {
                preResolvedResult.setChecked();
                return preResolvedResult;
            }
        }
        Collection<RepositoryEnquirer> usedRepositories = enforcedRepositories.isEmpty() ? this.repositories : enforcedRepositories;
        Optional<ResolutionResult> result = ((Stream)usedRepositories.stream().parallel()).map(repositoryEnquirer -> repositoryEnquirer.enquire(dependency)).filter(Objects::nonNull).findFirst();
        String resolvedResult = result.map(ResolutionResult::getDependencyURL).map(Objects::toString).orElse(FAILED_RESOLUTION_MESSAGE);
        LOGGER.log("Resolved %s @ %s", dependency.artifactId(), resolvedResult);
        return result.orElse(null);
    }
}

