/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.resolver.enquirer;

import io.github.niestrat99.advancedteleport.libs.slimjar.logging.LogDispatcher;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.ProcessLogger;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.ResolutionResult;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.enquirer.RepositoryEnquirer;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.pinger.URLPinger;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.strategy.PathResolutionStrategy;
import java.net.MalformedURLException;
import java.net.URL;

public record PingingRepositoryEnquirer(Repository repository, PathResolutionStrategy dependencyURLCreationStrategy, PathResolutionStrategy checksumURLCreationStrategy, PathResolutionStrategy pomURLCreationStrategy, URLPinger urlPinger) implements RepositoryEnquirer
{
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();

    @Override
    public ResolutionResult enquire(Dependency dependency) {
        LOGGER.debug("Enquiring repositories to find %s", dependency.artifactId());
        return this.dependencyURLCreationStrategy.pathTo(this.repository, dependency).stream().map(this::createURL).filter(this.urlPinger::ping).findFirst().map(url -> {
            URL resolvedChecksum = this.checksumURLCreationStrategy.pathTo(this.repository, dependency).parallelStream().map(this::createURL).filter(this.urlPinger::ping).findFirst().orElse(null);
            return new ResolutionResult(this.repository, (URL)url, resolvedChecksum, false, true);
        }).orElseGet(() -> this.pomURLCreationStrategy.pathTo(this.repository, dependency).parallelStream().map(this::createURL).filter(this.urlPinger::ping).findFirst().map(url -> new ResolutionResult(this.repository, null, null, true, false)).orElse(null));
    }

    @Override
    public String toString() {
        return this.repository.url().toString();
    }

    private URL createURL(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            LOGGER.debug("Failed to create URL from path %s", path);
            return null;
        }
    }
}

