/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.util;

import io.github.niestrat99.advancedteleport.libs.slimjar.app.module.ModuleExtractor;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public final class Modules {
    private Modules() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class is not meant to be instantiated");
    }

    public static URL findModule(String moduleName) {
        ClassLoader classLoader = Modules.class.getClassLoader();
        return classLoader.getResource(moduleName + ".isolated-jar");
    }

    public static URL[] extract(ModuleExtractor extractor, Collection<String> modules) throws IOException {
        URL[] urls = new URL[modules.size()];
        int index = 0;
        for (String moduleName : modules) {
            URL modulePath = Modules.findModule(moduleName);
            URL extractedModule = extractor.extractModule(modulePath, moduleName);
            urls[index++] = extractedModule;
        }
        return urls;
    }

    public static Collection<String> findLocalModules() throws URISyntaxException, IOException {
        URL url = Modules.class.getProtectionDomain().getCodeSource().getLocation();
        Path resourcesPath = Paths.get(url.toURI());
        try (Stream<Path> stream = Files.walk(resourcesPath, 1, new FileVisitOption[0]);){
            List<String> list = stream.filter(path -> path.endsWith(".isolated-jar")).map(path -> path.getFileName().toString()).toList();
            return list;
        }
    }
}

