/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.listeners.spigot;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATSign;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class SpigotLegacySignListener
implements Listener {
    @EventHandler
    public void onSignInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        BlockState blockState = clickedBlock.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        String line = sign.getLine(0);
        ATSign atSign = AdvancedTeleportAPI.getSignByLegacyName(line);
        CoreClass.debug("Sign found from " + line + ": " + String.valueOf(atSign));
        if (atSign == null) {
            return;
        }
        CoreClass.debug("Is the sign enabled: " + atSign.isEnabled());
        CoreClass.debug("Does the player have permission to use the sign: " + player.hasPermission(atSign.getRequiredPermission()));
        if (!atSign.isEnabled()) {
            return;
        }
        if (!player.hasPermission(atSign.getRequiredPermission())) {
            return;
        }
        int cooldown = CooldownManager.secondsLeftOnCooldown(atSign.getName().toLowerCase(), player);
        if (cooldown > 0) {
            CustomMessages.sendMessage((CommandSender)player, "Error.onCooldown", new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(cooldown))});
            return;
        }
        atSign.onInteract(sign, player);
    }
}

