/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.hooks.MapPlugin;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import io.github.niestrat99.advancedteleport.sql.MetadataSQLManager;
import io.github.niestrat99.advancedteleport.sql.SpawnSQLManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapAssetManager {
    private static HashMap<String, InputStream> images;

    public static void init() {
        images = new HashMap();
        File advTpFolder = CoreClass.getInstance().getDataFolder();
        File mapAssetsFolder = new File(advTpFolder, "map-assets");
        if (!mapAssetsFolder.exists() && !mapAssetsFolder.mkdirs()) {
            CoreClass.getInstance().getLogger().warning("Failed to create the map-assets folder.");
            return;
        }
        MapAssetManager.registerImage("warp_default", CoreClass.getInstance().getResource("warp-default.png"));
        MapAssetManager.registerImage("home_default", CoreClass.getInstance().getResource("home-default.png"));
        MapAssetManager.registerImage("spawn_default", CoreClass.getInstance().getResource("spawn-default.png"));
        String[] fileNames = mapAssetsFolder.list();
        if (fileNames == null) {
            return;
        }
        for (String fileName : fileNames) {
            FileInputStream stream;
            File file = new File(mapAssetsFolder, fileName);
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                CoreClass.getInstance().getLogger().warning("Failed to find the file " + fileName + "!");
                continue;
            }
            String id = fileName.replace("-", "_").substring(0, fileName.lastIndexOf(46));
            MapAssetManager.registerImage(id, stream);
        }
    }

    public static Collection<String> getImageNames() {
        return images.keySet();
    }

    public static void registerImage(String name, InputStream stream) {
        images.put(name, stream);
        PluginHookManager.get().getPluginHooks(MapPlugin.class, true).forEach(mapPlugin -> mapPlugin.registerImage(name, stream));
        CoreClass.getInstance().getLogger().info("Registered the image " + name + "!");
    }

    public static CompletableFuture<@Nullable IconInfo> getIcon(@NotNull String name, @NotNull IconType type, @Nullable UUID owner) {
        CompletableFuture<Integer> idFetcher = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case IconType.WARP -> WarpSQLManager.get().getWarpId(name);
            case IconType.HOME -> HomeSQLManager.get().getHomeId(name, owner);
            case IconType.SPAWN -> SpawnSQLManager.get().getSpawnId(name);
        };
        return idFetcher.thenApplyAsync(id -> IconInfo.fromSQL(id, type), CoreClass.async);
    }

    public static enum IconType {
        WARP(MainConfig.get().MAP_WARPS),
        HOME(MainConfig.get().MAP_HOMES),
        SPAWN(MainConfig.get().MAP_SPAWNS);

        private final MainConfig.MapOptions section;

        private IconType(MainConfig.MapOptions section) {
            this.section = section;
        }
    }

    public record IconInfo(String imageKey, int size, boolean shown, String clickTooltip, String hoverTooltip) {
        @Nullable
        public static IconInfo fromSQL(int id, IconType type) {
            IconInfo iconInfo;
            block8: {
                Connection connection = MetadataSQLManager.get().implementConnection();
                try {
                    SQLInterface sql = new SQLInterface(connection, String.valueOf(id), type);
                    String imageKey = sql.get("map_icon", type.section.getDefaultIcon().replace('-', '_'));
                    String size = sql.get("map_icon_size", String.valueOf(type.section.getIconSize()));
                    String shown = sql.get("map_visibility", String.valueOf(type.section.isEnabled()));
                    String clickTooltip = sql.get("map_click_tooltip", type.section.getClickTooltip());
                    String hoverTooltip = sql.get("map_hover_tooltip", type.section.getHoverTooltip());
                    iconInfo = new IconInfo(imageKey, Integer.parseInt(size), Boolean.parseBoolean(shown), clickTooltip, hoverTooltip);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException exception) {
                        exception.printStackTrace();
                        return null;
                    }
                }
                connection.close();
            }
            return iconInfo;
        }
    }

    private record SQLInterface(Connection connection, String id, IconType type) {
        @NotNull
        private String get(String key, String defaultOpt) throws SQLException {
            return Objects.requireNonNullElse(MetadataSQLManager.get().getValue(this.connection, this.id, this.type.name(), key), defaultOpt);
        }
    }
}

