/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import com.google.common.collect.ImmutableMap;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.sql.MetadataSQLManager;
import io.github.niestrat99.advancedteleport.sql.SpawnSQLManager;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class NamedLocationManager {
    @NotNull
    private final HashMap<String, Warp> warps;
    @NotNull
    private final HashMap<String, Spawn> spawns;
    @NotNull
    private final HashMap<String, Spawn> worldMirrors;
    @Nullable
    private Spawn mainSpawn;
    private static NamedLocationManager instance;

    public NamedLocationManager() {
        instance = this;
        this.warps = new HashMap();
        this.spawns = new HashMap();
        this.worldMirrors = new HashMap();
        CoreClass.debug("Set up the NamedLocationManager. Ready to accept warps and spawnpoints.");
    }

    public static NamedLocationManager get() {
        return instance;
    }

    public void loadSpawnData() {
        SpawnSQLManager.get().getSpawns().thenAcceptAsync(spawns -> {
            spawns.forEach(this::registerSpawn);
            MetadataSQLManager.get().loadMirroredSpawns();
            MetadataSQLManager.get().loadMainSpawn().whenComplete((result, err) -> {
                this.mainSpawn = result;
                if (err != null) {
                    CoreClass.getInstance().getLogger().warning("Failed to get the main spawn!");
                    err.printStackTrace();
                }
            });
        }, CoreClass.sync);
    }

    @Contract(pure=true)
    public void registerWarp(@NotNull Warp warp) {
        this.warps.put(warp.getName(), warp);
    }

    @Contract(pure=true)
    public boolean isWarpSet(@NotNull String name) {
        return this.warps.containsKey(name);
    }

    @Contract(pure=true)
    public void removeWarp(@NotNull Warp warp) {
        this.warps.remove(warp.getName());
    }

    public ImmutableMap<String, Warp> getWarps() {
        return ImmutableMap.copyOf(this.warps);
    }

    @Contract(pure=true)
    public void registerSpawn(@NotNull Spawn spawn) {
        this.spawns.put(spawn.getName(), spawn);
        CoreClass.debug("Registered spawn " + spawn.getName());
    }

    @Contract(pure=true)
    @Nullable
    public Spawn getSpawn(@NotNull String name) {
        return this.spawns.get(name);
    }

    @Contract(pure=true)
    @Nullable
    public Spawn getSpawn(@NotNull String name, @Nullable Player teleportingPlayer) {
        if (!this.spawns.containsKey(name)) {
            return null;
        }
        Spawn spawn = this.spawns.get(name);
        if (teleportingPlayer == null) {
            return spawn;
        }
        while (!spawn.canAccess(teleportingPlayer) && spawn.getMirroringSpawn() != null) {
            spawn = spawn.getMirroringSpawn();
        }
        if (spawn.canAccess(teleportingPlayer)) {
            return spawn;
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public Spawn getSpawn(@NotNull World world, @Nullable Player teleportingPlayer) {
        Spawn spawn;
        if (teleportingPlayer != null && MainConfig.get().TELEPORT_TO_NEAREST_SPAWN.get().booleanValue()) {
            CoreClass.debug("Teleport to nearest spawn activated - checking closest spawnpoints to " + teleportingPlayer.getName());
            return this.getNearestSpawn(teleportingPlayer);
        }
        if (!this.spawns.containsKey(world.getName()) && !this.worldMirrors.containsKey(world.getName())) {
            CoreClass.debug("No spawnpoint registered under the name " + world.getName() + " - getting undeclared spawn");
            return this.getUndeclaredSpawn(world);
        }
        CoreClass.debug("Spawn: " + spawn.getName());
        if (teleportingPlayer == null) {
            return spawn;
        }
        for (spawn = this.spawns.getOrDefault(world.getName(), this.worldMirrors.get(world.getName())); !spawn.canAccess(teleportingPlayer) && spawn.getMirroringSpawn() != null && spawn.getMirroringSpawn() != spawn; spawn = spawn.getMirroringSpawn()) {
            CoreClass.debug("Spawnpoint mirroring to " + spawn.getMirroringSpawn().getName());
        }
        CoreClass.debug("Can " + teleportingPlayer.getName() + " access " + spawn.getName() + ": " + spawn.canAccess(teleportingPlayer));
        if (!spawn.canAccess(teleportingPlayer)) {
            return this.getUndeclaredSpawn(world);
        }
        return spawn;
    }

    @Contract(pure=true)
    @NotNull
    private Spawn getUndeclaredSpawn(@NotNull World world) {
        if (this.mainSpawn != null) {
            CoreClass.debug("Main spawn exists - returning " + this.mainSpawn.getName() + ".");
            return this.mainSpawn;
        }
        if (MainConfig.get().USE_OVERWORLD.get().booleanValue()) {
            CoreClass.debug("Overworld has been requested for usage.");
            if (world.getEnvironment() == World.Environment.NORMAL) {
                CoreClass.debug("Normal world environment, returning " + world.getName() + "'s spawnpoint.");
                return new Spawn(world.getName(), world.getSpawnLocation());
            }
            String overworldName = world.getName().replaceAll("(_nether|_the_end)$", "");
            World overworld = Bukkit.getWorld((String)overworldName);
            if (overworld == null) {
                CoreClass.debug("Overworld for " + world.getName() + " (" + overworldName + ") was not found, returning " + world.getName() + "'s spawnpoint.");
                return new Spawn(world.getName(), world.getSpawnLocation());
            }
            return this.spawns.getOrDefault(overworld.getName(), new Spawn(overworld.getName(), overworld.getSpawnLocation()));
        }
        CoreClass.debug("Returning " + world.getName() + "'s spawnpoint.");
        return new Spawn(world.getName(), world.getSpawnLocation());
    }

    @Contract(pure=true)
    @NotNull
    private Spawn getNearestSpawn(@NotNull Player player) {
        Location loc = player.getLocation();
        @Nullable Spawn chosenSpawn = null;
        double max = 0.0;
        for (Spawn spawn : this.getSpawns().values()) {
            if (spawn.getLocation().getWorld() != player.getWorld() || !spawn.canAccess(player)) continue;
            double x = spawn.getLocation().getX();
            double y = spawn.getLocation().getY();
            double z = spawn.getLocation().getZ();
            double distance = NumberConversions.square((double)(x - loc.getX())) + NumberConversions.square((double)(y - loc.getY())) + NumberConversions.square((double)(z - loc.getZ()));
            if (chosenSpawn != null && distance >= max) continue;
            chosenSpawn = spawn;
            max = distance;
        }
        if (chosenSpawn == null) {
            return this.getUndeclaredSpawn(player.getWorld());
        }
        return chosenSpawn;
    }

    @Contract
    public void addMirroredSpawn(@NotNull String from, @Nullable Spawn spawn) {
        if (spawn != null) {
            this.worldMirrors.put(from, spawn);
            CoreClass.debug("Added world mirror " + from + " to redirect to " + spawn.getName() + ".");
        } else {
            this.worldMirrors.remove(from);
        }
    }

    @Contract(pure=true)
    public void setMainSpawn(@Nullable Spawn spawn) {
        this.mainSpawn = spawn;
    }

    @Contract(pure=true)
    public void removeSpawn(@NotNull Spawn spawn) {
        this.spawns.remove(spawn.getName());
    }

    @Contract(pure=true)
    public boolean isSpawnSet(@NotNull String id) {
        return this.spawns.containsKey(id);
    }

    @Contract(pure=true)
    @NotNull
    public ImmutableMap<String, Spawn> getSpawns() {
        return ImmutableMap.copyOf(this.spawns);
    }

    @Nullable
    public Spawn getMainSpawn() {
        return this.mainSpawn;
    }
}

