/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATSign;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.signs.BedSign;
import io.github.niestrat99.advancedteleport.api.signs.HomeSign;
import io.github.niestrat99.advancedteleport.api.signs.HomesSign;
import io.github.niestrat99.advancedteleport.api.signs.RandomTPSign;
import io.github.niestrat99.advancedteleport.api.signs.SpawnSign;
import io.github.niestrat99.advancedteleport.api.signs.WarpSign;
import io.github.niestrat99.advancedteleport.api.signs.WarpsSign;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignManager {
    private static SignManager instance;
    @NotNull
    private final HashMap<String, ATSign> signs;

    public SignManager() {
        instance = this;
        this.signs = new HashMap();
        CoreClass.debug("Sign manager initialised, registering signs...");
        AdvancedTeleportAPI.registerSign("warps", new WarpsSign());
        AdvancedTeleportAPI.registerSign("warp", new WarpSign());
        AdvancedTeleportAPI.registerSign("home", new HomeSign());
        AdvancedTeleportAPI.registerSign("homes", new HomesSign());
        AdvancedTeleportAPI.registerSign("bed", new BedSign());
        AdvancedTeleportAPI.registerSign("spawn", new SpawnSign());
        AdvancedTeleportAPI.registerSign("randomtp", new RandomTPSign());
        CoreClass.debug("Registered " + this.signs.size() + " signs.");
    }

    public static SignManager get() {
        return instance;
    }

    public void register(@NotNull String name, @NotNull ATSign sign) {
        this.signs.put(name, sign);
        CoreClass.debug("Registered " + name + " sign under " + String.valueOf(sign));
    }

    @Nullable
    public ATSign getSign(@NotNull String name) {
        return this.signs.get(name);
    }

    @Nullable
    public ATSign getSignByFlatDisplayName(@NotNull TextComponent component) {
        CoreClass.debug("Flat display name check for " + String.valueOf(component) + " - signs to check: " + this.signs.size());
        for (ATSign sign : this.signs.values()) {
            TextComponent text;
            CoreClass.debug("Display name for " + String.valueOf(sign) + ": " + String.valueOf(sign.getDisplayName()));
            Component component2 = sign.getDisplayName();
            if (!(component2 instanceof TextComponent) || !(text = (TextComponent)component2).content().equals(component.content())) continue;
            return sign;
        }
        return null;
    }

    @Nullable
    public ATSign getSignByDisplayName(@NotNull Component component) {
        CoreClass.debug("Full display name check for " + String.valueOf(component) + " - signs to check: " + this.signs.size());
        for (ATSign sign : this.signs.values()) {
            if (!this.hardEquals(sign.getDisplayName(), component)) continue;
            return sign;
        }
        return null;
    }

    private boolean hardEquals(@NotNull Component c1, @NotNull Component c2) {
        TextComponent tc1;
        block6: {
            block5: {
                if (c1 == c2) {
                    return true;
                }
                if (!(c1 instanceof TextComponent)) break block5;
                tc1 = (TextComponent)c1;
                if (c2 instanceof TextComponent) break block6;
            }
            return false;
        }
        TextComponent tc2 = (TextComponent)c2;
        if (!tc1.equals(tc2)) {
            return false;
        }
        return tc1.style().equals(tc2.style());
    }
}

