/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.payments;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import io.github.niestrat99.advancedteleport.payments.Payment;
import io.github.niestrat99.advancedteleport.payments.types.ItemsPayment;
import io.github.niestrat99.advancedteleport.payments.types.LevelsPayment;
import io.github.niestrat99.advancedteleport.payments.types.PointsPayment;
import io.github.niestrat99.advancedteleport.payments.types.VaultPayment;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PaymentManager {
    private static PaymentManager instance;
    private final HashMap<String, HashMap<String, Payment>> teleportCosts;

    public PaymentManager() {
        instance = this;
        this.teleportCosts = new HashMap();
        this.addCommand("tpa", MainConfig.get().COSTS.TPA.get());
        this.addCommand("tpahere", MainConfig.get().COSTS.TPAHERE.get());
        this.addCommand("tpr", MainConfig.get().COSTS.TPR.get());
        this.addCommand("spawn", MainConfig.get().COSTS.SPAWN.get());
        this.addCommand("warp", MainConfig.get().COSTS.WARP.get());
        this.addCommand("home", MainConfig.get().COSTS.HOME.get());
        this.addCommand("back", MainConfig.get().COSTS.BACK.get());
    }

    private void addCommand(String command, Object value) {
        String[] rawPayments;
        HashMap<String, Payment> payments = new HashMap<String, Payment>();
        String valueStr = String.valueOf(value);
        if (valueStr.isEmpty()) {
            this.teleportCosts.put(command, payments);
            return;
        }
        for (String rawPayment : rawPayments = valueStr.split(";")) {
            try {
                Payment payment = this.parsePayment(rawPayment);
                if (payment == null) {
                    CoreClass.debug("Payment " + rawPayment + " did not have a payment formed.");
                    continue;
                }
                CoreClass.debug("Payment " + rawPayment + " for " + command + " was parsed as a " + payment.getClass().getSimpleName());
                this.addPayment(payment.getId(), payment, payments);
            }
            catch (Exception | NoClassDefFoundError e) {
                CoreClass.getInstance().getLogger().warning("Failed to parse payment " + rawPayment + " for command " + command + "! Error message: " + e.getMessage());
            }
        }
        this.teleportCosts.put(command, payments);
    }

    private Payment parsePayment(String rawPayment) {
        if (rawPayment.length() - 3 <= 0) {
            Matcher matcher = Pattern.compile("^((.+):)?([0-9]+(\\.[0-9]+)?)").matcher(rawPayment);
            if (matcher.matches()) {
                String plugin = matcher.group(2);
                double payment = Double.parseDouble(matcher.group(3));
                CoreClass.debug("Split payment into two, part 1: " + plugin + ", part two: " + payment);
                CoreClass.debug("Material: " + String.valueOf(Material.getMaterial((String)(plugin == null ? "" : plugin))));
                if (plugin != null && Material.getMaterial((String)plugin) != null) {
                    return ItemsPayment.getFromString(rawPayment);
                }
                return new VaultPayment(payment, plugin == null ? null : plugin.substring(0, plugin.length() - 1));
            }
            return null;
        }
        String points = rawPayment.substring(0, rawPayment.length() - 3);
        if (rawPayment.endsWith("LVL")) {
            return new LevelsPayment(Integer.parseInt(points));
        }
        if (rawPayment.endsWith("EXP")) {
            return new PointsPayment(Integer.parseInt(points));
        }
        Matcher matcher = Pattern.compile("^((.+):)?([0-9]+(\\.[0-9]+)?)").matcher(rawPayment);
        if (matcher.matches()) {
            String plugin = matcher.group(2);
            double payment = Double.parseDouble(matcher.group(3));
            CoreClass.debug("Split payment into two, part 1: " + plugin + ", part two: " + payment);
            CoreClass.debug("Material: " + String.valueOf(Material.getMaterial((String)(plugin == null ? "" : plugin))));
            if (plugin != null && Material.getMaterial((String)plugin) != null) {
                return ItemsPayment.getFromString(rawPayment);
            }
            return new VaultPayment(payment, plugin == null ? null : plugin.substring(0, plugin.length() - 1));
        }
        return ItemsPayment.getFromString(rawPayment);
    }

    private void addPayment(String type, Payment payment, HashMap<String, Payment> currentPayMethods) {
        if (type.equalsIgnoreCase("levels")) {
            if (currentPayMethods.containsKey("exp")) {
                PointsPayment existingPayment = (PointsPayment)currentPayMethods.get("exp");
                existingPayment.addLevels((LevelsPayment)payment);
            } else {
                PointsPayment newPayment = new PointsPayment(0);
                newPayment.addLevels((LevelsPayment)payment);
                currentPayMethods.put("exp", newPayment);
            }
        } else if (type.equalsIgnoreCase("item")) {
            if (payment == null) {
                return;
            }
            ItemsPayment itemsPayment = (ItemsPayment)payment;
            if (currentPayMethods.containsKey("item_" + itemsPayment.getMaterial().name())) {
                ItemsPayment otherPayment = (ItemsPayment)currentPayMethods.get("item_" + itemsPayment.getMaterial().name());
                otherPayment.setPaymentAmount(otherPayment.getPaymentAmount() + itemsPayment.getPaymentAmount());
                currentPayMethods.put("item_" + itemsPayment.getMaterial().name(), otherPayment);
            } else {
                currentPayMethods.put("item_" + itemsPayment.getMaterial().name(), itemsPayment);
            }
        } else if (currentPayMethods.containsKey(type)) {
            Payment existingPayment = currentPayMethods.get(type);
            existingPayment.setPaymentAmount(payment.getPaymentAmount() + existingPayment.getPaymentAmount());
        } else {
            currentPayMethods.put(type, payment);
        }
    }

    public static PaymentManager getInstance() {
        return instance;
    }

    public boolean canPay(String command, Player player, World toWorld) {
        CoreClass.debug("Verifying that " + player.getName() + " can pay to run " + command + " into " + toWorld.getName());
        if (player.hasPermission("at.admin.bypass.payment")) {
            CoreClass.debug(player.getName() + " has at.admin.bypass.payment - not checking payments.");
            return true;
        }
        for (Payment payment : this.getPayments(command, player, toWorld).values()) {
            if (payment.canPay(player)) continue;
            CoreClass.debug(player.getName() + " failed to afford payment " + payment.getId() + ".");
            return false;
        }
        return true;
    }

    public void withdraw(String command, Player player, World toWorld) {
        if (!player.hasPermission("at.admin.bypass.payment")) {
            for (Payment payment : this.getPayments(command, player, toWorld).values()) {
                payment.withdraw(player);
            }
        }
    }

    private HashMap<String, Payment> getPayments(String command, Player player, World toWorld) {
        ConfigSection customCosts = MainConfig.get().CUSTOM_COSTS.get();
        HashMap<String, Payment> payments = new HashMap<String, Payment>();
        for (String key : customCosts.getKeys(false)) {
            Payment payment;
            String rawPayment;
            String worldName = toWorld.getName().toLowerCase(Locale.ROOT);
            if (!this.hasPermission(player, "at.member.cost." + key) && !this.hasPermission(player, "at.member.cost." + command + "." + key) && !this.hasPermission(player, "at.member.cost." + worldName + "." + key) && !this.hasPermission(player, "at.member.cost." + command + "." + worldName + "." + key) || (rawPayment = customCosts.getString(key)) == null || (payment = this.parsePayment(rawPayment)) == null) continue;
            payments.put(payment.getId(), payment);
        }
        if (payments.isEmpty()) {
            payments = this.teleportCosts.get(command);
        }
        return payments;
    }

    private boolean hasPermission(Player player, String permission) {
        return player.isPermissionSet(permission) && player.hasPermission(permission);
    }
}

