/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.payments.types;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.payments.Payment;
import java.util.Collection;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.Nullable;

public class VaultPayment
extends Payment {
    @Nullable
    private final String economyName;
    private double price;
    private Economy economy;

    public VaultPayment(double price, @Nullable String economyName) throws IllegalStateException {
        this.price = price;
        this.economyName = economyName;
        if (economyName == null) {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (provider == null) {
                throw new IllegalStateException("There is no economy provider registered.");
            }
            this.economy = (Economy)provider.getProvider();
            return;
        }
        Collection economies = Bukkit.getServicesManager().getRegistrations(Economy.class);
        for (RegisteredServiceProvider provider : economies) {
            CoreClass.getInstance().getLogger().info("Checking " + provider.getPlugin().getName() + " against " + economyName);
            if (!provider.getPlugin().getName().equals(economyName)) continue;
            this.economy = (Economy)provider.getProvider();
            break;
        }
        if (this.economy == null) {
            throw new IllegalStateException("There is no economy provider for " + economyName + " registered.");
        }
    }

    @Override
    public double getPaymentAmount() {
        return this.price;
    }

    @Override
    public void setPaymentAmount(double amount) {
        this.price = amount;
    }

    @Override
    public double getPlayerAmount(Player player) {
        return this.economy.getBalance((OfflinePlayer)player);
    }

    @Override
    public String getMessagePath() {
        return "Info.paymentVault";
    }

    @Override
    public String getId() {
        return "vault:" + this.economyName;
    }

    @Override
    public void setPlayerAmount(Player player) {
        this.economy.withdrawPlayer((OfflinePlayer)player, this.price);
        CustomMessages.sendMessage((CommandSender)player, "Info.paymentVault", new TagResolver[]{Placeholder.parsed((String)"amount", (String)this.economy.format(this.price)), Placeholder.parsed((String)"balance", (String)this.economy.format(this.getPlayerAmount(player)))});
    }

    @Override
    public boolean canPay(Player player) {
        boolean result = super.canPay(player);
        if (!result) {
            CustomMessages.sendMessage((CommandSender)player, "Error.notEnoughMoney", new TagResolver[]{Placeholder.parsed((String)"amount", (String)this.economy.format(this.price))});
        }
        return result;
    }
}

