/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.sql;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.BlockInfo;
import io.github.niestrat99.advancedteleport.sql.DataFailManager;
import io.github.niestrat99.advancedteleport.sql.SQLManager;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlocklistManager
extends SQLManager {
    private static BlocklistManager instance;

    public BlocklistManager() {
        instance = this;
    }

    public static BlocklistManager get() {
        return instance;
    }

    @Override
    public void createTable() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            CoreClass.debug("Creating table data for the block list manager if it is not already set up.");
            try (Connection connection = this.implementConnection();){
                PreparedStatement createTable = this.prepareStatement(connection, "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_blocklist (id INTEGER PRIMARY KEY " + this.getStupidAutoIncrementThing() + ", uuid_receiver VARCHAR(256) NOT NULL, uuid_blocked VARCHAR(256) NOT NULL,timestamp BIGINT NOT NULL,reason TEXT)");
                this.executeUpdate(createTable);
            }
            catch (SQLException exception) {
                CoreClass.getInstance().getLogger().severe("Failed to create the blocklist table.");
                exception.printStackTrace();
            }
            this.transferOldData();
        });
    }

    @Override
    public void transferOldData() {
        boolean renameResult;
        CoreClass.debug("Transferring old blocklist data...");
        File blocklistFile = new File(CoreClass.getInstance().getDataFolder(), "blocklist.yml");
        if (!blocklistFile.exists()) {
            CoreClass.debug("No blocklist data to import.");
            return;
        }
        YamlConfiguration blocklist = YamlConfiguration.loadConfiguration((File)blocklistFile);
        ConfigurationSection playersSection = blocklist.getConfigurationSection("players");
        if (playersSection != null) {
            for (String player : playersSection.getKeys(false)) {
                List blockedPlayers = blocklist.getStringList("players." + player);
                for (String blockedPlayer : blockedPlayers) {
                    this.blockUser(player, blockedPlayer, null);
                }
            }
        }
        CoreClass.debug((renameResult = blocklistFile.renameTo(new File(CoreClass.getInstance().getDataFolder(), "blocklist-backup.yml"))) ? "Successfully renamed the blocklist file." : "Failed to rename the blocklist file.");
    }

    public void blockUser(@NotNull String receiverUUID, @NotNull String blockedUUID, @Nullable String reason) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement;
            if (reason != null) {
                statement = this.prepareStatement(connection, "INSERT INTO " + tablePrefix + "_blocklist (uuid_receiver, uuid_blocked, timestamp, reason) VALUES (?, ?, ?, ?)");
                statement.setString(4, reason);
            } else {
                statement = this.prepareStatement(connection, "INSERT INTO " + tablePrefix + "_blocklist (uuid_receiver, uuid_blocked, timestamp) VALUES (?, ?, ?)");
            }
            statement.setString(1, receiverUUID);
            statement.setString(2, blockedUUID);
            statement.setLong(3, System.currentTimeMillis());
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.ADD_BLOCK, receiverUUID, blockedUUID, reason);
            throw new RuntimeException(exception);
        }
    }

    public void unblockUser(String receiverUUID, String blockedUUID) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_blocklist WHERE uuid_receiver = ? AND uuid_blocked = ?");
            statement.setString(1, receiverUUID);
            statement.setString(2, blockedUUID);
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.UNBLOCK, receiverUUID, blockedUUID);
            throw new RuntimeException(exception);
        }
    }

    public HashMap<UUID, BlockInfo> getBlockedPlayers(String receiverUUID) {
        HashMap<UUID, BlockInfo> hashMap;
        block9: {
            Connection connection = this.implementConnection();
            try {
                PreparedStatement statement = this.prepareStatement(connection, "SELECT * FROM " + tablePrefix + "_blocklist WHERE uuid_receiver = ?");
                statement.setString(1, receiverUUID);
                ResultSet results = this.executeQuery(statement);
                HashMap<UUID, BlockInfo> blockedPlayers = new HashMap<UUID, BlockInfo>();
                while (results.next()) {
                    BlockInfo blockInfo = new BlockInfo(UUID.fromString(receiverUUID), UUID.fromString(results.getString("uuid_blocked")), results.getString("reason"), results.getLong("timestamp"));
                    blockedPlayers.put(blockInfo.getBlockedUUID(), blockInfo);
                }
                hashMap = blockedPlayers;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new RuntimeException(exception);
                }
            }
            connection.close();
        }
        return hashMap;
    }
}

