/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.sql;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import io.github.niestrat99.advancedteleport.sql.SQLManager;
import io.github.niestrat99.advancedteleport.sql.SpawnSQLManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetadataSQLManager
extends SQLManager {
    private static MetadataSQLManager instance;

    public MetadataSQLManager() {
        instance = this;
    }

    public static MetadataSQLManager get() {
        return instance;
    }

    @Override
    public void createTable() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            CoreClass.debug("Creating table data for the metadata manager if it is not already set up.");
            try (Connection connection = this.implementConnection();){
                PreparedStatement createTable = this.prepareStatement(connection, "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_metadata (data_id VARCHAR(256) NOT NULL, type VARCHAR(256) NOT NULL,`key` VARCHAR(256) NOT NULL, value TEXT NOT NULL)");
                this.executeUpdate(createTable);
            }
            catch (SQLException exception) {
                CoreClass.getInstance().getLogger().severe("Failed to create the metadata table.");
                exception.printStackTrace();
            }
            this.transferOldData();
        });
    }

    @Override
    public void transferOldData() {
    }

    public HashMap<String, String> getAllValues(Connection connection, String type, String key) throws SQLException {
        HashMap<String, String> results = new HashMap<String, String>();
        PreparedStatement statement = this.prepareStatement(connection, "SELECT data_id, value FROM " + tablePrefix + "_metadata WHERE type = ? AND `key` = ?;");
        statement.setString(1, type);
        statement.setString(2, key);
        ResultSet set = this.executeQuery(statement);
        while (set.next()) {
            results.put(set.getString("data_id"), set.getString("value"));
        }
        return results;
    }

    public CompletableFuture<Boolean> addWarpMetadata(String warpName, String key, String value) {
        return this.addWarpMetadata(warpName, key, value, true);
    }

    public CompletableFuture<Boolean> addWarpMetadata(String warpName, String key, String value, boolean single) {
        return WarpSQLManager.get().getWarpId(warpName).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                if (id == -1) {
                    Boolean bl2 = false;
                    return bl2;
                }
                Boolean bl = this.addMetadata(connection, String.valueOf(id), "WARP", key, value, single);
                return bl;
            }
            catch (SQLException throwables) {
                throw new RuntimeException(throwables);
            }
        }, CoreClass.async);
    }

    public boolean addMetadata(Connection connection, String dataId, String type, String key, String value, boolean single) throws SQLException {
        if (single) {
            this.deleteMetadata(connection, dataId, type, key);
        }
        PreparedStatement statement = this.prepareStatement(connection, "INSERT INTO " + tablePrefix + "_metadata (data_id, type, `key`, value) VALUES (?, ?, ?, ?);");
        statement.setString(1, dataId);
        statement.setString(2, type);
        statement.setString(3, key);
        statement.setString(4, value);
        this.executeUpdate(statement);
        return true;
    }

    public CompletableFuture<Boolean> addHomeMetadata(String homeName, UUID owner, String key, String value) {
        return this.addHomeMetadata(homeName, owner, key, value, true);
    }

    public CompletableFuture<Boolean> addHomeMetadata(String homeName, UUID owner, String key, String value, boolean single) {
        return HomeSQLManager.get().getHomeId(homeName, owner).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                if (id == -1) {
                    Boolean bl2 = false;
                    return bl2;
                }
                Boolean bl = this.addMetadata(connection, String.valueOf(id), "HOME", key, value, single);
                return bl;
            }
            catch (SQLException throwables) {
                throw new RuntimeException(throwables);
            }
        });
    }

    public CompletableFuture<Boolean> addSpawnMetadata(String spawnName, String key, String value) {
        return this.addSpawnMetadata(spawnName, key, value, true);
    }

    public CompletableFuture<Boolean> addSpawnMetadata(String spawnName, String key, String value, boolean single) {
        return SpawnSQLManager.get().getSpawnId(spawnName).thenApplyAsync(id -> {
            Boolean bl;
            block8: {
                Connection connection = this.implementConnection();
                try {
                    bl = this.addMetadata(connection, String.valueOf(id), "SPAWN", key, value, single);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException throwables) {
                        throw new RuntimeException(throwables);
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public CompletableFuture<String> getWarpMetadata(String warpName, String key) {
        return WarpSQLManager.get().getWarpId(warpName).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                if (id == -1) {
                    String string2 = null;
                    return string2;
                }
                String string = this.getValue(connection, String.valueOf(id), "WARP", key);
                return string;
            }
            catch (SQLException throwables) {
                throw new RuntimeException(throwables);
            }
        });
    }

    @Nullable
    public String getValue(Connection connection, String dataId, String type, String key) throws SQLException {
        PreparedStatement statement = this.prepareStatement(connection, "SELECT value FROM " + tablePrefix + "_metadata WHERE data_id = ? AND type = ? AND `key` = ?;");
        statement.setString(1, dataId);
        statement.setString(2, type);
        statement.setString(3, key);
        ResultSet set = this.executeQuery(statement);
        if (set.next()) {
            return set.getString("value");
        }
        return null;
    }

    public CompletableFuture<String> getHomeMetadata(String homeName, UUID owner, String key) {
        return HomeSQLManager.get().getHomeId(homeName, owner).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                if (id == -1) {
                    String string2 = null;
                    return string2;
                }
                String string = this.getValue(connection, String.valueOf(id), "HOME", key);
                return string;
            }
            catch (SQLException throwables) {
                throw new RuntimeException(throwables);
            }
        });
    }

    public CompletableFuture<String> getSpawnMetadata(String spawnName, String key) {
        return SpawnSQLManager.get().getSpawnId(spawnName).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                if (id == null) {
                    String string2 = null;
                    return string2;
                }
                String string = this.getValue(connection, String.valueOf(id), "SPAWN", key);
                return string;
            }
            catch (SQLException throwables) {
                throw new RuntimeException(throwables);
            }
        }, CoreClass.async);
    }

    public CompletableFuture<Boolean> deleteWarpMetadata(String warpName, String key) {
        return WarpSQLManager.get().getWarpId(warpName).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                if (id == -1) {
                    Boolean bl2 = false;
                    return bl2;
                }
                Boolean bl = this.deleteMetadata(connection, String.valueOf(id), "WARP", key);
                return bl;
            }
            catch (SQLException throwables) {
                throw new RuntimeException(throwables);
            }
        }, CoreClass.async);
    }

    public boolean deleteMetadata(Connection connection, String dataId, String type, String key) throws SQLException {
        PreparedStatement statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_metadata WHERE data_id = ? AND type = ? AND `key` = ?;");
        statement.setString(1, dataId);
        statement.setString(2, type);
        statement.setString(3, key);
        this.executeUpdate(statement);
        return true;
    }

    public CompletableFuture<Boolean> deleteHomeMetadata(String homeName, UUID owner, String key) {
        return HomeSQLManager.get().getHomeId(homeName, owner).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                if (id == -1) {
                    Boolean bl2 = false;
                    return bl2;
                }
                Boolean bl = this.deleteMetadata(connection, String.valueOf(id), "HOME", key);
                return bl;
            }
            catch (SQLException throwables) {
                throw new RuntimeException(throwables);
            }
        });
    }

    public CompletableFuture<Boolean> deleteMainSpawn() {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block8: {
                Connection connection = this.implementConnection();
                try {
                    PreparedStatement statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_metadata WHERE type = 'SPAWN' AND `key` = 'main_spawn'");
                    statement.executeUpdate();
                    bl = true;
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                connection.close();
            }
            return bl;
        }, CoreClass.async);
    }

    public CompletableFuture<Boolean> mirrorSpawn(@NotNull String source, @Nullable String mirror) {
        return SpawnSQLManager.get().getSpawnId(source).thenApplyAsync(id -> {
            try (Connection connection = this.implementConnection();){
                String idRaw = String.valueOf(id);
                if (idRaw.equals("-1")) {
                    idRaw = source;
                }
                PreparedStatement deleteStatement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_metadata WHERE type = 'SPAWN' AND `key` = 'mirror' AND data_id = ?");
                deleteStatement.setString(1, idRaw);
                this.executeUpdate(deleteStatement);
                if (mirror == null) {
                    Boolean bl2 = false;
                    return bl2;
                }
                int mirrorId = SpawnSQLManager.get().getSpawnIdSync(connection, mirror);
                String rawMirrorId = String.valueOf(mirrorId);
                if (rawMirrorId.equals("-1")) {
                    rawMirrorId = mirror;
                }
                Boolean bl = this.addMetadata(connection, idRaw, "SPAWN", "mirror_spawn", rawMirrorId, true);
                return bl;
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        }, CoreClass.async);
    }

    private Spawn getSpawnFromId(Connection connection, String id) throws SQLException {
        if (!id.matches("^[0-9]+$")) {
            World world = Bukkit.getWorld((String)id);
            if (world == null) {
                return null;
            }
            return AdvancedTeleportAPI.getDestinationSpawn(world, null);
        }
        PreparedStatement statement = this.prepareStatement(connection, "SELECT spawn FROM " + tablePrefix + "_spawns WHERE id = ?;");
        statement.setInt(1, Integer.parseInt(id));
        ResultSet set = statement.executeQuery();
        if (set.next()) {
            return AdvancedTeleportAPI.getSpawn(set.getString("spawn"));
        }
        return null;
    }

    public CompletableFuture<Void> loadMirroredSpawns() {
        return CompletableFuture.runAsync(() -> {
            try (Connection connection = this.implementConnection();){
                HashMap<String, String> ids = this.getAllValues(connection, "SPAWN", "mirror_spawn");
                for (String dataId : ids.keySet()) {
                    String mirrorId = ids.get(dataId);
                    Spawn main = this.getSpawnFromId(connection, dataId);
                    Spawn mirror = this.getSpawnFromId(connection, mirrorId);
                    if (main == null) continue;
                    Bukkit.getScheduler().runTask((Plugin)CoreClass.getInstance(), () -> main.setMirroringSpawn(mirror, null));
                }
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        }, CoreClass.async);
    }

    public CompletableFuture<@Nullable Spawn> loadMainSpawn() {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.implementConnection();){
                PreparedStatement statement = this.prepareStatement(connection, "SELECT spawn FROM " + tablePrefix + "_spawns JOIN " + tablePrefix + "_metadata ON " + tablePrefix + "_spawns.id = " + tablePrefix + "_metadata.data_id AND " + tablePrefix + "_metadata.`key` = 'main_spawn' AND " + tablePrefix + "_metadata.value = 'true';");
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    Spawn spawn2 = AdvancedTeleportAPI.getSpawn(set.getString("spawn"));
                    return spawn2;
                }
                Spawn spawn = null;
                return spawn;
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        }, CoreClass.async);
    }
}

