/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.sql;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.sql.DataFailManager;
import io.github.niestrat99.advancedteleport.sql.SQLManager;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSQLManager
extends SQLManager {
    private static PlayerSQLManager instance;
    private static HashMap<UUID, Location> previousLocationData;
    private static YamlConfiguration lastLocations;
    private static File lastLocFile;

    public PlayerSQLManager() {
        instance = this;
    }

    @Override
    public void createTable() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            CoreClass.debug("Creating table data for the players manager if it is not already set up.");
            try (Connection connection = this.implementConnection();){
                PreparedStatement createTable = this.prepareStatement(connection, "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_players (id INTEGER PRIMARY KEY " + this.getStupidAutoIncrementThing() + ", uuid VARCHAR(256) NOT NULL, name VARCHAR(256) NOT NULL,timestamp_last_joined BIGINT NOT NULL,main_home VARCHAR(256),teleportation_on BIT DEFAULT 1 NOT NULL, x DOUBLE, y DOUBLE, z DOUBLE, yaw FLOAT, pitch FLOAT, world VARCHAR(256))");
                this.executeUpdate(createTable);
            }
            catch (SQLException exception) {
                CoreClass.getInstance().getLogger().severe("Failed to create the players table.");
                exception.printStackTrace();
            }
            this.transferOldData();
        });
    }

    @Override
    public void transferOldData() {
        previousLocationData = new HashMap();
        lastLocFile = new File(CoreClass.getInstance().getDataFolder(), "last-locations.yml");
        if (!lastLocFile.exists()) {
            return;
        }
        lastLocations = YamlConfiguration.loadConfiguration((File)lastLocFile);
        for (String uuid : lastLocations.getKeys(false)) {
            String locStr;
            if (uuid.equals("death") || lastLocations.getString("death." + uuid) != null || (locStr = lastLocations.getString(uuid)) == null) continue;
            String[] locParts = locStr.split(":");
            Location loc = new Location(Bukkit.getWorld((String)locParts[5]), Double.parseDouble(locParts[0]), Double.parseDouble(locParts[1]), Double.parseDouble(locParts[2]), Float.parseFloat(locParts[3]), Float.parseFloat(locParts[4]));
            previousLocationData.put(UUID.fromString(uuid), loc);
        }
        ConfigurationSection section = lastLocations.getConfigurationSection("death");
        if (section == null) {
            return;
        }
        for (String uuid : section.getKeys(false)) {
            String locStr = section.getString(uuid);
            if (locStr == null) continue;
            String[] locParts = locStr.split(":");
            Location loc = new Location(Bukkit.getWorld((String)locParts[5]), Double.parseDouble(locParts[0]), Double.parseDouble(locParts[1]), Double.parseDouble(locParts[2]), Float.parseFloat(locParts[3]), Float.parseFloat(locParts[4]));
            previousLocationData.put(UUID.fromString(uuid), loc);
        }
    }

    public void updatePlayerData(OfflinePlayer player) {
        this.isPlayerInDatabase(player).thenAcceptAsync(result -> {
            if (result.booleanValue()) {
                this.updatePlayerInformation(player);
            } else {
                this.addPlayer(player);
            }
        }, CoreClass.async);
    }

    public void updatePlayerInformation(OfflinePlayer player) {
        try (Connection connection = this.implementConnection();){
            if (player.getName() == null) {
                return;
            }
            PreparedStatement statement = this.prepareStatement(connection, "UPDATE " + tablePrefix + "_players SET name = ?, timestamp_last_joined = ? WHERE uuid = ?");
            statement.setString(1, player.getName().toLowerCase());
            statement.setLong(2, System.currentTimeMillis());
            statement.setString(3, player.getUniqueId().toString());
            this.executeUpdate(statement);
            if (previousLocationData.containsKey(player.getUniqueId())) {
                ATPlayer.getPlayer(player).setPreviousLocation(previousLocationData.get(player.getUniqueId()));
                PlayerSQLManager.removeLastLocation(player.getUniqueId());
            }
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.UPDATE_PLAYER, player.getUniqueId().toString());
            exception.printStackTrace();
        }
    }

    public CompletableFuture<Boolean> isPlayerInDatabase(OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block8: {
                Connection connection = this.implementConnection();
                try {
                    PreparedStatement statement = this.prepareStatement(connection, "SELECT name FROM " + tablePrefix + "_players WHERE uuid = ?");
                    statement.setString(1, player.getUniqueId().toString());
                    ResultSet results = this.executeQuery(statement);
                    bl = results.next();
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                connection.close();
            }
            return bl;
        }, CoreClass.async);
    }

    public void addPlayer(OfflinePlayer player) {
        try (Connection connection = this.implementConnection();){
            if (player.getName() == null) {
                return;
            }
            PreparedStatement statement = this.prepareStatement(connection, "INSERT INTO " + tablePrefix + "_players (uuid, name, timestamp_last_joined) VALUES (?, ?, ?)");
            statement.setString(1, player.getUniqueId().toString());
            statement.setString(2, player.getName().toLowerCase());
            statement.setLong(3, System.currentTimeMillis());
            this.executeUpdate(statement);
            if (previousLocationData.containsKey(player.getUniqueId())) {
                ATPlayer.getPlayer(player).setPreviousLocation(previousLocationData.get(player.getUniqueId()));
                PlayerSQLManager.removeLastLocation(player.getUniqueId());
            }
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.ADD_PLAYER, player.getUniqueId().toString());
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTeleportationOn(UUID uuid) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT teleportation_on FROM " + tablePrefix + "_players WHERE uuid = ?");
            statement.setString(1, uuid.toString());
            ResultSet results = this.executeQuery(statement);
            if (!results.next()) return true;
            boolean bl = results.getBoolean("teleportation_on");
            return bl;
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setTeleportationOn(UUID uuid, boolean enabled) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "UPDATE " + tablePrefix + "_players SET teleportation_on = ? WHERE uuid = ?");
            statement.setBoolean(1, enabled);
            statement.setString(2, uuid.toString());
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.CHANGE_TELEPORTATION, uuid.toString(), String.valueOf(enabled));
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Location getPreviousLocation(String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT x, y, z, yaw, pitch, world FROM " + tablePrefix + "_players WHERE name = ?");
            statement.setString(1, name.toLowerCase());
            ResultSet results = this.executeQuery(statement);
            if (results.next()) {
                try {
                    World world = Bukkit.getWorld((String)results.getString("world"));
                    Location location = new Location(world, results.getDouble("x"), results.getDouble("y"), results.getDouble("z"), results.getFloat("yaw"), results.getFloat("pitch"));
                    return location;
                }
                catch (IllegalArgumentException | NullPointerException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    public void setPreviousLocation(@NotNull String name, @Nullable Location location) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "UPDATE " + tablePrefix + "_players SET x = ?, y = ?, z = ?, yaw = ?, pitch = ?, world = ? WHERE name = ?");
            statement.setObject(1, location == null ? null : Double.valueOf(location.getX()));
            statement.setObject(2, location == null ? null : Double.valueOf(location.getY()));
            statement.setObject(3, location == null ? null : Double.valueOf(location.getZ()));
            statement.setObject(4, location == null ? null : Float.valueOf(location.getYaw()));
            statement.setObject(5, location == null ? null : Float.valueOf(location.getPitch()));
            statement.setObject(6, location == null ? null : location.getWorld().getName());
            statement.setString(7, name.toLowerCase());
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.UPDATE_LOCATION, location.getWorld().getName(), String.valueOf(location.getX()), String.valueOf(location.getY()), String.valueOf(location.getZ()), String.valueOf(location.getYaw()), String.valueOf(location.getPitch()), name);
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getMainHome(String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT main_home FROM " + tablePrefix + "_players WHERE name = ?");
            statement.setString(1, name.toLowerCase());
            ResultSet results = this.executeQuery(statement);
            if (!results.next()) return null;
            String string = results.getString("main_home");
            return string;
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setMainHome(UUID uuid, String home) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "UPDATE " + tablePrefix + "_players SET main_home = ? WHERE uuid = ?");
            statement.setString(1, home);
            statement.setString(2, uuid.toString());
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.SET_MAIN_HOME, home, uuid.toString());
            exception.printStackTrace();
        }
    }

    private static void removeLastLocation(UUID uuid) {
        previousLocationData.remove(uuid);
        lastLocations.set(uuid.toString(), null);
        lastLocations.set("death." + String.valueOf(uuid), null);
        if (previousLocationData.isEmpty()) {
            lastLocFile.delete();
        } else {
            try {
                lastLocations.save(lastLocFile);
            }
            catch (IOException e) {
                CoreClass.getInstance().getLogger().severe("Failed to remove the last location of " + String.valueOf(uuid) + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static PlayerSQLManager get() {
        return instance;
    }
}

