/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.sql;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.data.UnloadedWorldException;
import io.github.niestrat99.advancedteleport.managers.NamedLocationManager;
import io.github.niestrat99.advancedteleport.sql.MetadataSQLManager;
import io.github.niestrat99.advancedteleport.sql.SQLManager;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnSQLManager
extends SQLManager {
    private static SpawnSQLManager instance;

    public SpawnSQLManager() {
        instance = this;
    }

    public static SpawnSQLManager get() {
        return instance;
    }

    @Override
    public void createTable() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            CoreClass.debug("Creating table data for the spawns manager if it is not already set up.");
            try (Connection connection = this.implementConnection();){
                PreparedStatement createTable = this.prepareStatement(connection, "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_spawns (id INTEGER PRIMARY KEY " + this.getStupidAutoIncrementThing() + ", spawn VARCHAR(256) NOT NULL, uuid_creator VARCHAR(256), x DOUBLE NOT NULL, y DOUBLE NOT NULL, z DOUBLE NOT NULL, yaw FLOAT NOT NULL, pitch FLOAT NOT NULL, world VARCHAR(256) NOT NULL, timestamp_created BIGINT NOT NULL, timestamp_updated BIGINT NOT NULL)");
                this.executeUpdate(createTable);
            }
            catch (SQLException exception) {
                CoreClass.getInstance().getLogger().severe("Failed to create the spawns table.");
                exception.printStackTrace();
            }
            this.transferOldData();
            NamedLocationManager.get().loadSpawnData();
        });
    }

    @Override
    public void transferOldData() {
        File file = new File(CoreClass.getInstance().getDataFolder(), "spawn.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration spawnsFile = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection spawns = spawnsFile.getConfigurationSection("spawns");
        if (spawns == null) {
            return;
        }
        String mainSpawn = spawnsFile.getString("main-spawn");
        for (String spawnName : spawns.getKeys(false)) {
            String world;
            ConfigurationSection spawnSection = spawns.getConfigurationSection(spawnName);
            if (spawnSection == null) continue;
            if (spawnSection.contains("mirror")) {
                MetadataSQLManager.get().mirrorSpawn(spawnName, spawnSection.getString("mirror"));
            }
            if ((world = spawnSection.getString("world")) == null) continue;
            this.addSpawn(spawnName, world, null, spawnSection.getDouble("x"), spawnSection.getDouble("y"), spawnSection.getDouble("z"), (float)spawnSection.getDouble("yaw"), (float)spawnSection.getDouble("pitch"));
            if (!spawnName.equals(mainSpawn)) continue;
            try {
                Connection connection = this.implementConnection();
                try {
                    int id = this.getSpawnIdSync(connection, spawnName);
                    MetadataSQLManager.get().addMetadata(connection, String.valueOf(id), "SPAWN", "main_spawn", "true", true);
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        file.renameTo(new File(CoreClass.getInstance().getDataFolder(), "spawn-backup.yml"));
    }

    public CompletableFuture<Void> addSpawn(@NotNull Spawn spawn) {
        return CompletableFuture.runAsync(() -> this.addSpawn(spawn.getName(), spawn.getLocation().getWorld().getName(), spawn.getCreatorUUID(), spawn.getLocation().getX(), spawn.getLocation().getY(), spawn.getLocation().getZ(), spawn.getLocation().getYaw(), spawn.getLocation().getPitch()), CoreClass.async);
    }

    public void addSpawn(@NotNull String name, @NotNull String worldName, @Nullable UUID creator, double x, double y, double z, float yaw, float pitch) {
        this.removeSpawnSync(name);
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "INSERT INTO " + tablePrefix + "_spawns (spawn, uuid_creator, x, y, z, yaw, pitch, world, timestamp_created, timestamp_updated) VALUES (?,?,?,?,?,?,?,?,?,?)");
            statement.setString(1, name);
            statement.setString(2, creator == null ? null : creator.toString());
            statement.setDouble(3, x);
            statement.setDouble(4, y);
            statement.setDouble(5, z);
            statement.setFloat(6, yaw);
            statement.setFloat(7, pitch);
            statement.setString(8, worldName);
            statement.setDouble(9, System.currentTimeMillis());
            statement.setDouble(10, System.currentTimeMillis());
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    public CompletableFuture<Void> removeSpawn(String name) {
        return CompletableFuture.runAsync(() -> this.removeSpawnSync(name), CoreClass.async);
    }

    public void removeSpawnSync(String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_spawns WHERE spawn = ?");
            statement.setString(1, name);
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    public CompletableFuture<Void> moveSpawn(Spawn spawn) {
        return CompletableFuture.runAsync(() -> {
            try (Connection connection = this.implementConnection();){
                PreparedStatement statement = this.prepareStatement(connection, "UPDATE " + tablePrefix + "_spawns SET x = ?, y = ?, z = ?, yaw = ?, pitch = ?, world = ?, timestamp_update = ? WHERE spawn = ?");
                this.prepareLocation(spawn.getLocation(), 1, statement);
                statement.setLong(7, spawn.getUpdatedTime());
                statement.setString(8, spawn.getName());
                this.executeUpdate(statement);
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        }, CoreClass.async);
    }

    public CompletableFuture<List<Spawn>> getSpawns() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Spawn> arrayList;
            block11: {
                Connection connection = this.implementConnection();
                try {
                    ArrayList<Spawn> spawns = new ArrayList<Spawn>();
                    PreparedStatement statement = this.prepareStatement(connection, "SELECT * FROM " + tablePrefix + "_spawns");
                    ResultSet result = this.executeQuery(statement);
                    while (result.next()) {
                        try {
                            Location loc = this.getLocation(result);
                            String uuid = result.getString("uuid_creator");
                            String name = result.getString("spawn");
                            long timestampCreated = result.getLong("timestamp_created");
                            long timestampUpdated = result.getLong("timestamp_updated");
                            Spawn spawn = new Spawn(name, loc, null, uuid == null ? null : UUID.fromString(uuid), timestampCreated, timestampUpdated);
                            spawns.add(spawn);
                        }
                        catch (UnloadedWorldException e) {
                            CoreClass.getInstance().getLogger().warning("Failed to get the spawn for " + result.getString("spawn") + ": " + e.getMessage());
                        }
                    }
                    arrayList = spawns;
                    if (connection == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                connection.close();
            }
            return arrayList;
        }, CoreClass.async);
    }

    public int getSpawnIdSync(Connection connection, String name) throws SQLException {
        PreparedStatement statement = this.prepareStatement(connection, "SELECT id FROM " + tablePrefix + "_spawns WHERE spawn = ?;");
        statement.setString(1, name);
        ResultSet set = this.executeQuery(statement);
        if (set.next()) {
            return set.getInt("id");
        }
        return -1;
    }

    public CompletableFuture<Integer> getSpawnId(String name) {
        return CompletableFuture.supplyAsync(() -> {
            Integer n;
            block8: {
                Connection connection = this.implementConnection();
                try {
                    n = this.getSpawnIdSync(connection, name);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                        return -1;
                    }
                }
                connection.close();
            }
            return n;
        }, CoreClass.async);
    }
}

