/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.sql;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.api.WorldlessLocation;
import io.github.niestrat99.advancedteleport.managers.NamedLocationManager;
import io.github.niestrat99.advancedteleport.sql.DataFailManager;
import io.github.niestrat99.advancedteleport.sql.SQLManager;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class WarpSQLManager
extends SQLManager {
    private static WarpSQLManager instance;

    public WarpSQLManager() {
        instance = this;
    }

    public static WarpSQLManager get() {
        return instance;
    }

    @Override
    public void createTable() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            try (Connection connection = this.implementConnection();){
                CoreClass.debug("Creating table data for the warps manager if it is not already set up.");
                PreparedStatement createTable = this.prepareStatement(connection, "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_warps (id INTEGER PRIMARY KEY " + this.getStupidAutoIncrementThing() + ", warp VARCHAR(256) NOT NULL,uuid_creator VARCHAR(256), x DOUBLE NOT NULL,y DOUBLE NOT NULL,z DOUBLE NOT NULL,yaw FLOAT NOT NULL,pitch FLOAT NOT NULL,world VARCHAR(256) NOT NULL,price VARCHAR(256),timestamp_created BIGINT NOT NULL,timestamp_updated BIGINT NOT NULL)");
                this.executeUpdate(createTable);
            }
            catch (SQLException exception) {
                CoreClass.getInstance().getLogger().severe("Failed to create the warps table.");
                exception.printStackTrace();
            }
            this.transferOldData();
        });
    }

    @Override
    public void transferOldData() {
        this.addWarps();
        File file = new File(CoreClass.getInstance().getDataFolder(), "warps.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration warps = YamlConfiguration.loadConfiguration((File)file);
        for (String warp : warps.getKeys(false)) {
            String world;
            ConfigurationSection warpSection = warps.getConfigurationSection(warp);
            if (warpSection == null || (world = warpSection.getString("world")) == null) continue;
            WorldlessLocation location = new WorldlessLocation(world, warpSection.getDouble("x"), warpSection.getDouble("y"), warpSection.getDouble("z"), (float)warpSection.getDouble("yaw"), (float)warpSection.getDouble("pitch"));
            Warp warpObj = new Warp(null, warp, location, -1L, -1L);
            this.addWarp(warpObj);
            NamedLocationManager.get().registerWarp(warpObj);
        }
        file.renameTo(new File(CoreClass.getInstance().getDataFolder(), "warps-backup.yml"));
    }

    private void addWarps() {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT * FROM " + tablePrefix + "_warps");
            ResultSet results = this.executeQuery(statement);
            while (results.next()) {
                String creator = results.getString("uuid_creator");
                NamedLocationManager.get().registerWarp(new Warp(creator == null ? null : UUID.fromString(creator), results.getString("warp"), new WorldlessLocation(results.getString("world"), results.getDouble("x"), results.getDouble("y"), results.getDouble("z"), results.getFloat("yaw"), results.getFloat("pitch")), results.getLong("timestamp_created"), results.getLong("timestamp_updated")));
            }
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    public void addWarp(Warp warp) {
        Location location = warp.getLocation();
        UUID creator = warp.getCreator();
        String name = warp.getName();
        long created = warp.getCreatedTime();
        long updated = warp.getUpdatedTime();
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "INSERT INTO " + tablePrefix + "_warps (warp, uuid_creator, x, y, z, yaw, pitch, world, timestamp_created, timestamp_updated) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setString(1, name);
            statement.setString(2, creator == null ? null : creator.toString());
            statement.setDouble(3, location.getX());
            statement.setDouble(4, location.getY());
            statement.setDouble(5, location.getZ());
            statement.setDouble(6, location.getYaw());
            statement.setDouble(7, location.getPitch());
            statement.setString(8, location.getWorld().getName());
            statement.setLong(9, created);
            statement.setLong(10, updated);
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.ADD_WARP, location.getWorld().getName(), String.valueOf(location.getX()), String.valueOf(location.getY()), String.valueOf(location.getZ()), String.valueOf(location.getYaw()), String.valueOf(location.getPitch()), name, creator == null ? null : creator.toString(), String.valueOf(created), String.valueOf(updated));
            exception.printStackTrace();
        }
    }

    public void removeWarp(String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_warps WHERE warp = ?");
            statement.setString(1, name);
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.DELETE_WARP, name);
            exception.printStackTrace();
        }
    }

    public void moveWarp(Location newLocation, String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "UPDATE " + tablePrefix + "_warps SET x = ?, y = ?, z = ?, yaw = ?, pitch = ?, world = ?, timestamp_updated = ? WHERE warp = ?");
            this.prepareLocation(newLocation, 1, statement);
            statement.setLong(7, System.currentTimeMillis());
            statement.setString(8, name);
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.MOVE_WARP, newLocation.getWorld().getName(), String.valueOf(newLocation.getX()), String.valueOf(newLocation.getY()), String.valueOf(newLocation.getZ()), String.valueOf(newLocation.getYaw()), String.valueOf(newLocation.getPitch()), name);
            exception.printStackTrace();
        }
    }

    public CompletableFuture<Integer> getWarpId(String name) {
        return CompletableFuture.supplyAsync(() -> this.getWarpIdSync(name), CoreClass.async);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWarpIdSync(String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT id FROM " + tablePrefix + "_warps WHERE warp = ?;");
            statement.setString(1, name);
            ResultSet set = this.executeQuery(statement);
            if (!set.next()) return -1;
            int n = set.getInt("id");
            return n;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return -1;
    }

    public void purgeWarps(String worldName) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT warp FROM " + tablePrefix + "_warps WHERE world = ?");
            statement.setString(1, worldName);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Warp warp = AdvancedTeleportAPI.getWarp(set.getString("warp"));
                if (warp == null) continue;
                NamedLocationManager.get().removeWarp(warp);
            }
            set.close();
            statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_warps WHERE world = ?");
            statement.setString(1, worldName);
            this.executeUpdate(statement);
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    public void purgeWarps(UUID creatorID) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT warp FROM " + tablePrefix + "_warps WHERE uuid_creator = ?");
            statement.setString(1, creatorID.toString());
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Warp warp = AdvancedTeleportAPI.getWarp(set.getString("warp"));
                if (warp == null) continue;
                NamedLocationManager.get().removeWarp(warp);
            }
            set.close();
            statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_warps WHERE uuid_creator = ?");
            statement.setString(1, creatorID.toString());
            this.executeUpdate(statement);
        }
        catch (SQLException throwables) {
            throw new RuntimeException(throwables);
        }
    }

    public CompletableFuture<List<Warp>> getWarpsBulk() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Warp> arrayList;
            block9: {
                Connection connection = this.implementConnection();
                try {
                    PreparedStatement statement = this.prepareStatement(connection, "SELECT * FROM " + tablePrefix + "_warps");
                    ResultSet results = this.executeQuery(statement);
                    ArrayList<Warp> warps = new ArrayList<Warp>();
                    while (results.next()) {
                        String creator = results.getString("uuid_creator");
                        warps.add(new Warp(creator == null ? null : UUID.fromString(creator), results.getString("warp"), new WorldlessLocation(results.getString("world"), results.getDouble("x"), results.getDouble("y"), results.getDouble("z"), results.getFloat("yaw"), results.getFloat("pitch")), results.getLong("timestamp_created"), results.getLong("timestamp_updated")));
                    }
                    arrayList = warps;
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                connection.close();
            }
            return arrayList;
        }, CoreClass.async);
    }
}

