/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.TeleportRequest;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.limitations.LimitationsManager;
import io.github.niestrat99.advancedteleport.utilities.DistanceLimiter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ConditionChecker {
    @Contract(value="_, null, _ -> !null; _, !null, _ -> _")
    @Nullable
    public static String canTeleport(Player player, Player target, String command) {
        if (target == null) {
            return "Error.noSuchPlayer";
        }
        if (!player.canSee(target)) {
            return "Error.noSuchPlayer";
        }
        if (target == player) {
            return "Error.requestSentToSelf";
        }
        if (!player.hasPermission("at.admin.request-in-vanish") && !target.canSee(player)) {
            return "Error.cantTPToPlayer";
        }
        String teleportLims = ConditionChecker.canTeleport(player.getLocation(), target.getLocation(), command, player);
        if (teleportLims != null) {
            return teleportLims;
        }
        ATPlayer atTarget = ATPlayer.getPlayer(target);
        if (!atTarget.isTeleportationEnabled()) {
            return "Error.tpOff";
        }
        if (atTarget.hasBlocked((OfflinePlayer)player)) {
            return "Error.tpBlock";
        }
        if ((command.equalsIgnoreCase("tpa") || command.equalsIgnoreCase("tpahere")) && TeleportRequest.getRequestByReqAndResponder(target, player) != null) {
            return "Error.alreadySentRequest";
        }
        return null;
    }

    @Nullable
    public static String canTeleport(Location fromLoc, Location toLoc, String command, Player teleportingPlayer) {
        CoreClass.debug("Requested to see if " + teleportingPlayer.getName() + " can teleport from " + CoreClass.getShortLocation(fromLoc) + " to " + CoreClass.getShortLocation(toLoc) + " using command " + command);
        if (MainConfig.get().ENABLE_DISTANCE_LIMITATIONS.get().booleanValue() && !teleportingPlayer.hasPermission("at.admin.bypass.distance-limit") && fromLoc.getWorld() == toLoc.getWorld() && !DistanceLimiter.canTeleport(toLoc, fromLoc, command, ATPlayer.getPlayer(teleportingPlayer))) {
            return "Error.tooFarAway";
        }
        if (MainConfig.get().ENABLE_TELEPORT_LIMITATIONS.get().booleanValue() && !teleportingPlayer.hasPermission("at.admin.bypass.teleport-limit")) {
            CoreClass.debug("Teleportation limits are enabled and the player is not bypassing them.");
            if (!MainConfig.get().MONITOR_ALL_TELEPORTS_LIMITS.get().booleanValue() && command == null) {
                return null;
            }
            if (!LimitationsManager.canTeleport(teleportingPlayer, toLoc, command)) {
                return "Error.cantTPToWorldLim";
            }
        }
        return null;
    }

    public static List<String> getPlayers(Player player) {
        ArrayList<String> players = new ArrayList<String>();
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (!player.canSee(target)) continue;
            players.add(target.getName());
        }
        return players;
    }

    public static <T> T validate(T object, String message) {
        if (object != null) {
            return object;
        }
        throw new NullPointerException(message);
    }
}

