/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities;

import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.utilities.ConditionChecker;
import io.github.niestrat99.advancedteleport.utilities.RandomCoords;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RandomTPAlgorithms {
    private static final HashMap<String, Algorithm> algorithms = new HashMap();

    public static void init() {
        algorithms.put("binary", (player, world) -> {
            Location location = RandomCoords.generateCoords(world);
            while (ConditionChecker.canTeleport(player.getLocation(), location, "tpr", player) != null) {
                location = RandomCoords.generateCoords(world);
            }
            location.setY(128.0);
            int jumpAmount = 128;
            if (world.getEnvironment() == World.Environment.NETHER) {
                location.setY(64.0);
                jumpAmount = 64;
            }
            boolean validLocation = false;
            boolean up = false;
            Location tempLoc = location.clone();
            while (!validLocation) {
                if ((jumpAmount /= 2) == 0) {
                    return RandomTPAlgorithms.getAlgorithms().get("binary").fire(player, world);
                }
                Location subTempLocation = tempLoc.clone();
                Material currentMat = up ? subTempLocation.add(0.0, (double)jumpAmount, 0.0).getBlock().getType() : subTempLocation.subtract(0.0, (double)jumpAmount, 0.0).getBlock().getType();
                tempLoc = subTempLocation.clone();
                boolean mustBreak = false;
                if (currentMat != Material.AIR) {
                    for (String material : MainConfig.get().AVOID_BLOCKS.get()) {
                        if (!currentMat.name().equalsIgnoreCase(material)) continue;
                        mustBreak = true;
                        break;
                    }
                    if (mustBreak) {
                        return RandomTPAlgorithms.getAlgorithms().get("binary").fire(player, world);
                    }
                    if (subTempLocation.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR && subTempLocation.clone().add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR) {
                        location = subTempLocation.add(0.5, 0.0, 0.5);
                        validLocation = true;
                        continue;
                    }
                    up = true;
                    continue;
                }
                up = false;
            }
            return location;
        });
    }

    public static HashMap<String, Algorithm> getAlgorithms() {
        return algorithms;
    }

    public static interface Algorithm {
        public Location fire(Player var1, World var2);
    }
}

