/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3;

import com.smushytaco.nickname_detector.shaded.okhttp3.CipherSuite;
import com.smushytaco.nickname_detector.shaded.okhttp3.Handshake;
import com.smushytaco.nickname_detector.shaded.okhttp3.Headers;
import com.smushytaco.nickname_detector.shaded.okhttp3.HttpUrl;
import com.smushytaco.nickname_detector.shaded.okhttp3.MediaType;
import com.smushytaco.nickname_detector.shaded.okhttp3.Protocol;
import com.smushytaco.nickname_detector.shaded.okhttp3.Request;
import com.smushytaco.nickname_detector.shaded.okhttp3.Response;
import com.smushytaco.nickname_detector.shaded.okhttp3.ResponseBody;
import com.smushytaco.nickname_detector.shaded.okhttp3.TlsVersion;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilCommonKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.cache.CacheRequest;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.cache.CacheStrategy;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.cache.DiskLruCache;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskRunner;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.HttpMethod;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.StatusLine;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Platform;
import com.smushytaco.nickname_detector.shaded.okio.Buffer;
import com.smushytaco.nickname_detector.shaded.okio.BufferedSink;
import com.smushytaco.nickname_detector.shaded.okio.BufferedSource;
import com.smushytaco.nickname_detector.shaded.okio.ByteString;
import com.smushytaco.nickname_detector.shaded.okio.FileSystem;
import com.smushytaco.nickname_detector.shaded.okio.ForwardingSink;
import com.smushytaco.nickname_detector.shaded.okio.ForwardingSource;
import com.smushytaco.nickname_detector.shaded.okio.Okio;
import com.smushytaco.nickname_detector.shaded.okio.Path;
import com.smushytaco.nickname_detector.shaded.okio.Sink;
import com.smushytaco.nickname_detector.shaded.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0004UVWTB)\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010#\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b!\u0010\"J\u001d\u0010'\u001a\u00020\u001b2\f\u0010&\u001a\b\u0018\u00010$R\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u001b\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020\u001b\u00a2\u0006\u0004\b+\u0010*J\r\u0010,\u001a\u00020\u001b\u00a2\u0006\u0004\b,\u0010*J\u0013\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-\u00a2\u0006\u0004\b/\u00100J\r\u00102\u001a\u000201\u00a2\u0006\u0004\b2\u00103J\r\u00104\u001a\u000201\u00a2\u0006\u0004\b4\u00103J\r\u00105\u001a\u00020\u0005\u00a2\u0006\u0004\b5\u00106J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u00106J\u000f\u00107\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b7\u0010*J\u000f\u00108\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b8\u0010*J\u000f\u0010\u0004\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010?\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020;H\u0000\u00a2\u0006\u0004\b=\u0010>J\u000f\u0010A\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b@\u0010*J\r\u0010B\u001a\u000201\u00a2\u0006\u0004\bB\u00103J\r\u0010C\u001a\u000201\u00a2\u0006\u0004\bC\u00103J\r\u0010D\u001a\u000201\u00a2\u0006\u0004\bD\u00103R\u001a\u0010E\u001a\u00020%8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bE\u0010F\u001a\u0004\bG\u0010HR\"\u00104\u001a\u0002018\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b4\u0010I\u001a\u0004\bJ\u00103\"\u0004\bK\u0010LR\"\u00102\u001a\u0002018\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b2\u0010I\u001a\u0004\bM\u00103\"\u0004\bN\u0010LR\u0016\u0010B\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010IR\u0016\u0010C\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010IR\u0016\u0010D\u001a\u0002018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010IR\u0011\u0010P\u001a\u00020O8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0011\u0010\u0004\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010:R\u0011\u0010R\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\bR\u0010S\u00a8\u0006X"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "Lcom/smushytaco/nickname_detector/shaded/okio/Path;", "directory", "", "maxSize", "Lcom/smushytaco/nickname_detector/shaded/okio/FileSystem;", "fileSystem", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okio/Path;JLcom/smushytaco/nickname_detector/shaded/okio/FileSystem;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;)V", "(Lcom/smushytaco/nickname_detector/shaded/okio/FileSystem;Lcom/smushytaco/nickname_detector/shaded/okio/Path;J)V", "Ljava/io/File;", "(Ljava/io/File;J)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "request", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "get$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "get", "response", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/CacheRequest;", "put$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/CacheRequest;", "put", "", "remove$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)V", "remove", "cached", "network", "update$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)V", "update", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache;", "editor", "abortQuietly", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Editor;)V", "initialize", "()V", "delete", "evictAll", "", "", "urls", "()Ljava/util/Iterator;", "", "writeAbortCount", "()I", "writeSuccessCount", "size", "()J", "flush", "close", "-deprecated_directory", "()Ljava/io/File;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/CacheStrategy;", "cacheStrategy", "trackResponse$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/CacheStrategy;)V", "trackResponse", "trackConditionalCacheHit$okhttp", "trackConditionalCacheHit", "networkCount", "hitCount", "requestCount", "cache", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache;", "getCache$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache;", "I", "getWriteSuccessCount$okhttp", "setWriteSuccessCount$okhttp", "(I)V", "getWriteAbortCount$okhttp", "setWriteAbortCount$okhttp", "", "isClosed", "()Z", "directoryPath", "()Lcom/smushytaco/nickname_detector/shaded/okio/Path;", "Companion", "RealCacheRequest", "Entry", "CacheResponseBody", "okhttp"})
public final class Cache
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public Cache(@NotNull Path directory, long maxSize, @NotNull FileSystem fileSystem2, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        this.cache = new DiskLruCache(fileSystem2, directory, 201105, 2, maxSize, taskRunner);
    }

    public Cache(@NotNull FileSystem fileSystem2, @NotNull Path directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(directory, maxSize, fileSystem2, TaskRunner.INSTANCE);
    }

    public Cache(@NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(FileSystem.SYSTEM, Path.Companion.get$default(Path.Companion, directory, false, 1, null), maxSize);
    }

    @NotNull
    public final DiskLruCache getCache$okhttp() {
        return this.cache;
    }

    public final int getWriteSuccessCount$okhttp() {
        return this.writeSuccessCount;
    }

    public final void setWriteSuccessCount$okhttp(int n) {
        this.writeSuccessCount = n;
    }

    public final int getWriteAbortCount$okhttp() {
        return this.writeAbortCount;
    }

    public final void setWriteAbortCount$okhttp(int n) {
        this.writeAbortCount = n;
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    @Nullable
    public final Response get$okhttp(@NotNull Request request) {
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String key = Companion.key(request.url());
        try {
            DiskLruCache.Snapshot snapshot2 = this.cache.get(key);
            if (snapshot2 == null) {
                return null;
            }
            snapshot = snapshot2;
        }
        catch (IOException iOException) {
            return null;
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        try {
            Entry iOException = new Entry(snapshot3.getSource(0));
        }
        catch (IOException iOException) {
            _UtilCommonKt.closeQuietly(snapshot3);
            return null;
        }
        Entry entry = iOException;
        Response response = entry.response(snapshot3);
        if (!entry.matches(request, response)) {
            _UtilCommonKt.closeQuietly(response.body());
            return null;
        }
        return response;
    }

    @Nullable
    public final CacheRequest put$okhttp(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String requestMethod = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove$okhttp(response.request());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (!Intrinsics.areEqual((Object)requestMethod, (Object)"GET")) {
            return null;
        }
        if (Companion.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = DiskLruCache.edit$default(this.cache, Companion.key(response.request().url()), 0L, 2, null);
            if (editor2 == null) {
                return null;
            }
            editor = editor2;
            entry.writeTo(editor);
            return new RealCacheRequest(editor);
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
            return null;
        }
    }

    public final void remove$okhttp(@NotNull Request request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.cache.remove(Companion.key(request.url()));
    }

    public final void update$okhttp(@NotNull Response cached, @NotNull Response network) {
        Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Entry entry = new Entry(network);
        ResponseBody responseBody = cached.body();
        Intrinsics.checkNotNull((Object)responseBody, (String)"null cannot be cast to non-null type okhttp3.Cache.CacheResponseBody");
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)responseBody).getSnapshot();
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = snapshot.edit();
            if (editor2 == null) {
                return;
            }
            editor = editor2;
            entry.writeTo(editor);
            editor.commit();
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
        }
    }

    private final void abortQuietly(DiskLruCache.Editor editor) {
        try {
            DiskLruCache.Editor editor2 = editor;
            if (editor2 != null) {
                editor2.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    @NotNull
    public final Iterator<String> urls() throws IOException {
        return new Iterator<String>(this){
            private final Iterator<DiskLruCache.Snapshot> delegate;
            private String nextUrl;
            private boolean canRemove;
            {
                this.delegate = $receiver.getCache$okhttp().snapshots();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    try {
                        Closeable closeable = this.delegate.next();
                        Throwable throwable = null;
                        try {
                            DiskLruCache.Snapshot snapshot = (DiskLruCache.Snapshot)closeable;
                            boolean bl = false;
                            BufferedSource metadata = Okio.buffer(snapshot.getSource(0));
                            this.nextUrl = metadata.readUtf8LineStrict();
                            boolean bl2 = true;
                            return bl2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return false;
            }

            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                Intrinsics.checkNotNull((Object)string);
                String result = string;
                this.nextUrl = null;
                this.canRemove = true;
                return result;
            }

            public void remove() {
                if (!this.canRemove) {
                    boolean bl = false;
                    String string = "remove() before next()";
                    throw new IllegalStateException(string.toString());
                }
                this.delegate.remove();
            }
        };
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    @JvmName(name="directory")
    @NotNull
    public final File directory() {
        return this.cache.getDirectory().toFile();
    }

    @JvmName(name="directoryPath")
    @NotNull
    public final Path directoryPath() {
        return this.cache.getDirectory();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="directory", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_directory")
    @NotNull
    public final File -deprecated_directory() {
        return this.cache.getDirectory().toFile();
    }

    public final synchronized void trackResponse$okhttp(@NotNull CacheStrategy cacheStrategy) {
        Intrinsics.checkNotNullParameter((Object)cacheStrategy, (String)"cacheStrategy");
        int n = this.requestCount;
        this.requestCount = n + 1;
        if (cacheStrategy.getNetworkRequest() != null) {
            n = this.networkCount;
            this.networkCount = n + 1;
        } else if (cacheStrategy.getCacheResponse() != null) {
            n = this.hitCount;
            this.hitCount = n + 1;
        }
    }

    public final synchronized void trackConditionalCacheHit$okhttp() {
        int n = this.hitCount;
        this.hitCount = n + 1;
    }

    public final synchronized int networkCount() {
        return this.networkCount;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int requestCount() {
        return this.requestCount;
    }

    @JvmStatic
    @NotNull
    public static final String key(@NotNull HttpUrl url) {
        return Companion.key(url);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u0006\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u000f\u0010\u0007\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0007\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0004\u001a\u00060\u0002R\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cache$CacheResponseBody;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/ResponseBody;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache;", "snapshot", "", "contentType", "contentLength", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;Ljava/lang/String;Ljava/lang/String;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/MediaType;", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/MediaType;", "", "()J", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "source", "()Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;", "getSnapshot", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;", "Ljava/lang/String;", "bodySource", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "okhttp"})
    private static final class CacheResponseBody
    extends ResponseBody {
        @NotNull
        private final DiskLruCache.Snapshot snapshot;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;
        @NotNull
        private final BufferedSource bodySource;

        public CacheResponseBody(@NotNull DiskLruCache.Snapshot snapshot, @Nullable String contentType, @Nullable String contentLength) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.snapshot = snapshot;
            this.contentType = contentType;
            this.contentLength = contentLength;
            Source source2 = this.snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource(source2){

                @Override
                public void close() throws IOException {
                    this.getSnapshot().close();
                    super.close();
                }
            });
        }

        @NotNull
        public final DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @Nullable
        public MediaType contentType() {
            String string = this.contentType;
            return string != null ? MediaType.Companion.parse(string) : null;
        }

        @Override
        public long contentLength() {
            String string = this.contentLength;
            return string != null ? _UtilCommonKt.toLongOrDefault(string, -1L) : -1L;
        }

        @Override
        @NotNull
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u0015*\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001d\u001a\u00020\u0011*\u00020\u000f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001d\u0010!R\u0014\u0010\"\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0014\u0010%\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010#\u00a8\u0006'"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cache$Companion;", "", "<init>", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "", "key", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;)Ljava/lang/String;", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "source", "", "readInt$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;)I", "readInt", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "cachedResponse", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "cachedRequest", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "newRequest", "", "varyMatches", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)Z", "hasVaryAll", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Z", "", "varyFields", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;)Ljava/util/Set;", "varyHeaders", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "requestHeaders", "responseHeaders", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "VERSION", "I", "ENTRY_METADATA", "ENTRY_BODY", "ENTRY_COUNT", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,838:1\n2746#2,3:839\n*S KotlinDebug\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n*L\n777#1:839,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String key(@NotNull HttpUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return ByteString.Companion.encodeUtf8(url.toString()).md5().hex();
        }

        public final int readInt$okhttp(@NotNull BufferedSource source2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            try {
                long result = source2.readDecimalLong();
                String line = source2.readUtf8LineStrict();
                if (result < 0L || result > Integer.MAX_VALUE || ((CharSequence)line).length() > 0) {
                    throw new IOException("expected an int but was \"" + result + line + '\"');
                }
                return (int)result;
            }
            catch (NumberFormatException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean varyMatches(@NotNull Response cachedResponse, @NotNull Headers cachedRequest, @NotNull Request newRequest) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
                Intrinsics.checkNotNullParameter((Object)cachedRequest, (String)"cachedRequest");
                Intrinsics.checkNotNullParameter((Object)newRequest, (String)"newRequest");
                Iterable $this$none$iv = this.varyFields(cachedResponse.headers());
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual(cachedRequest.values(it), newRequest.headers(it)))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean hasVaryAll(@NotNull Response $this$hasVaryAll) {
            Intrinsics.checkNotNullParameter((Object)$this$hasVaryAll, (String)"<this>");
            return this.varyFields($this$hasVaryAll.headers()).contains("*");
        }

        private final Set<String> varyFields(Headers $this$varyFields) {
            Set result = null;
            int n = $this$varyFields.size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.equals((String)"Vary", (String)$this$varyFields.name(i), (boolean)true)) continue;
                String value = $this$varyFields.value(i);
                if (result == null) {
                    result = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                }
                char[] cArray = new char[]{','};
                for (String varyField : StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                    result.add(((Object)StringsKt.trim((CharSequence)varyField)).toString());
                }
            }
            Set set = result;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public final Headers varyHeaders(@NotNull Response $this$varyHeaders) {
            Intrinsics.checkNotNullParameter((Object)$this$varyHeaders, (String)"<this>");
            Response response = $this$varyHeaders.networkResponse();
            Intrinsics.checkNotNull((Object)response);
            Headers requestHeaders = response.request().headers();
            Headers responseHeaders = $this$varyHeaders.headers();
            return this.varyHeaders(requestHeaders, responseHeaders);
        }

        private final Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
            Set<String> varyFields = this.varyFields(responseHeaders);
            if (varyFields.isEmpty()) {
                return Headers.EMPTY;
            }
            Headers.Builder result = new Headers.Builder();
            int n = requestHeaders.size();
            for (int i = 0; i < n; ++i) {
                String fieldName = requestHeaders.name(i);
                if (!varyFields.contains(fieldName)) continue;
                result.add(fieldName, requestHeaders.value(i));
            }
            return result.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0019\u0010\r\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\tR\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010\u0007\u001a\u00020\u00062\n\u0010 \u001a\u00060\u001fR\u00020\n\u00a2\u0006\u0004\b\u0007\u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00101\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u0010*R\u0014\u00102\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010'R\u0016\u00104\u001a\u0004\u0018\u0001038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u00109\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108\u00a8\u0006;"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cache$Entry;", "", "Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "rawSource", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okio/Source;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "response", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache;", "editor", "", "writeTo", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Editor;)V", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "source", "", "Ljava/security/cert/Certificate;", "readCertificateList", "(Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;)Ljava/util/List;", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;", "sink", "certificates", "writeCertList", "(Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;Ljava/util/List;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "request", "", "matches", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Z", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;", "snapshot", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "varyHeaders", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "", "requestMethod", "Ljava/lang/String;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Protocol;", "protocol", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Protocol;", "", "code", "I", "message", "responseHeaders", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Handshake;", "handshake", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Handshake;", "", "sentRequestMillis", "J", "receivedResponseMillis", "Companion", "okhttp"})
    private static final class Entry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HttpUrl url;
        @NotNull
        private final Headers varyHeaders;
        @NotNull
        private final String requestMethod;
        @NotNull
        private final Protocol protocol;
        private final int code;
        @NotNull
        private final String message;
        @NotNull
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        @NotNull
        private static final String SENT_MILLIS = Platform.Companion.get().getPrefix() + "-Sent-Millis";
        @NotNull
        private static final String RECEIVED_MILLIS = Platform.Companion.get().getPrefix() + "-Received-Millis";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public Entry(@NotNull Source rawSource) throws IOException {
            Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
            Closeable closeable = rawSource;
            Throwable throwable = null;
            try {
                Source it = (Source)closeable;
                boolean bl = false;
                BufferedSource source2 = Okio.buffer(rawSource);
                String urlLine = source2.readUtf8LineStrict();
                HttpUrl httpUrl = HttpUrl.Companion.parse(urlLine);
                if (httpUrl == null) {
                    void it2;
                    IOException iOException;
                    IOException iOException2 = iOException = new IOException("Cache corruption for " + urlLine);
                    Entry entry = this;
                    boolean bl2 = false;
                    Platform.Companion.get().log("cache corruption", 5, (Throwable)it2);
                    Entry entry2 = entry;
                    throw (Throwable)iOException;
                }
                this.url = httpUrl;
                this.requestMethod = source2.readUtf8LineStrict();
                Headers.Builder varyHeadersBuilder = new Headers.Builder();
                int varyRequestHeaderLineCount = Companion.readInt$okhttp(source2);
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    varyHeadersBuilder.addLenient$okhttp(source2.readUtf8LineStrict());
                }
                this.varyHeaders = varyHeadersBuilder.build();
                StatusLine statusLine = StatusLine.Companion.parse(source2.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder responseHeadersBuilder = new Headers.Builder();
                int responseHeaderLineCount = Companion.readInt$okhttp(source2);
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    responseHeadersBuilder.addLenient$okhttp(source2.readUtf8LineStrict());
                }
                String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                responseHeadersBuilder.removeAll(SENT_MILLIS);
                responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                String string = sendRequestMillisString;
                this.sentRequestMillis = string != null ? Long.parseLong(string) : 0L;
                String string2 = receivedResponseMillisString;
                this.receivedResponseMillis = string2 != null ? Long.parseLong(string2) : 0L;
                this.responseHeaders = responseHeadersBuilder.build();
                if (this.url.isHttps()) {
                    String blank = source2.readUtf8LineStrict();
                    if (((CharSequence)blank).length() > 0) {
                        throw new IOException("expected \"\" but was \"" + blank + '\"');
                    }
                    String cipherSuiteString = source2.readUtf8LineStrict();
                    CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
                    List<Certificate> peerCertificates = this.readCertificateList(source2);
                    List<Certificate> localCertificates = this.readCertificateList(source2);
                    TlsVersion tlsVersion = !source2.exhausted() ? TlsVersion.Companion.forJavaName(source2.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.Companion.get(tlsVersion, cipherSuite, peerCertificates, localCertificates);
                } else {
                    this.handshake = null;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public Entry(@NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.url = response.request().url();
            this.varyHeaders = Companion.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeTo(@NotNull DiskLruCache.Editor editor) throws IOException {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Closeable closeable = Okio.buffer(editor.newSink(0));
            Throwable throwable = null;
            try {
                int i;
                BufferedSink sink2 = (BufferedSink)closeable;
                boolean bl = false;
                sink2.writeUtf8(this.url.toString()).writeByte(10);
                sink2.writeUtf8(this.requestMethod).writeByte(10);
                sink2.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
                int n = this.varyHeaders.size();
                for (i = 0; i < n; ++i) {
                    sink2.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
                }
                sink2.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
                sink2.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
                n = this.responseHeaders.size();
                for (i = 0; i < n; ++i) {
                    sink2.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
                }
                sink2.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
                sink2.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
                if (this.url.isHttps()) {
                    sink2.writeByte(10);
                    Handshake handshake = this.handshake;
                    Intrinsics.checkNotNull((Object)handshake);
                    sink2.writeUtf8(handshake.cipherSuite().javaName()).writeByte(10);
                    this.writeCertList(sink2, this.handshake.peerCertificates());
                    this.writeCertList(sink2, this.handshake.localCertificates());
                    sink2.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final List<Certificate> readCertificateList(BufferedSource source2) throws IOException {
            int length = Companion.readInt$okhttp(source2);
            if (length == -1) {
                return CollectionsKt.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result = new ArrayList<Certificate>(length);
                for (int i = 0; i < length; ++i) {
                    ByteString certificateBytes;
                    String line = source2.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    if (ByteString.Companion.decodeBase64(line) == null) {
                        throw new IOException("Corrupt certificate in cache entry");
                    }
                    bytes.write(certificateBytes);
                    result.add(certificateFactory.generateCertificate(bytes.inputStream()));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private final void writeCertList(BufferedSink sink2, List<? extends Certificate> certificates) throws IOException {
            try {
                sink2.writeDecimalLong(certificates.size()).writeByte(10);
                for (Certificate certificate : certificates) {
                    byte[] bytes = certificate.getEncoded();
                    Intrinsics.checkNotNull((Object)bytes);
                    String line = ByteString.Companion.of$default(ByteString.Companion, bytes, 0, 0, 3, null).base64();
                    sink2.writeUtf8(line).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean matches(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return Intrinsics.areEqual((Object)this.url, (Object)request.url()) && Intrinsics.areEqual((Object)this.requestMethod, (Object)request.method()) && Companion.varyMatches(response, this.varyHeaders, request);
        }

        @NotNull
        public final Response response(@NotNull DiskLruCache.Snapshot snapshot) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength = this.responseHeaders.get("Content-Length");
            Request cacheRequest = new Request(this.url, this.varyHeaders, this.requestMethod, null, 8, null);
            return new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, contentType, contentLength)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cache$Entry$Companion;", "", "<init>", "()V", "", "SENT_MILLIS", "Ljava/lang/String;", "RECEIVED_MILLIS", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0018\u0010\u0004\u001a\u00060\u0002R\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\rR\u0014\u0010\u000e\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cache$RealCacheRequest;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/CacheRequest;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache;", "editor", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cache;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Editor;)V", "", "abort", "()V", "Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "body", "()Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "cacheOut", "Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "", "done", "Z", "getDone", "()Z", "setDone", "(Z)V", "okhttp"})
    private final class RealCacheRequest
    implements CacheRequest {
        @NotNull
        private final DiskLruCache.Editor editor;
        @NotNull
        private final Sink cacheOut;
        @NotNull
        private final Sink body;
        private boolean done;

        public RealCacheRequest(DiskLruCache.Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.cacheOut = this.editor.newSink(1);
            Sink sink2 = this.cacheOut;
            this.body = new ForwardingSink(sink2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    RealCacheRequest realCacheRequest = this;
                    Cache cache2 = Cache.this;
                    Cache cache3 = cache;
                    synchronized (cache3) {
                        boolean bl = false;
                        if (realCacheRequest.getDone()) {
                            return;
                        }
                        realCacheRequest.setDone(true);
                        int n = cache2.getWriteSuccessCount$okhttp();
                        cache2.setWriteSuccessCount$okhttp(n + 1);
                        int n2 = n;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            Cache cache2 = Cache.this;
            Cache cache3 = cache;
            synchronized (cache3) {
                boolean bl = false;
                if (this.done) {
                    return;
                }
                this.done = true;
                int n = cache2.getWriteAbortCount$okhttp();
                cache2.setWriteAbortCount$okhttp(n + 1);
                int n2 = n;
            }
            _UtilCommonKt.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        @NotNull
        public Sink body() {
            return this.body;
        }
    }
}

