/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Task;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskQueue;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\u001a5\u0010\t\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a;\u0010\r\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a+\u0010\u0010\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"Ljava/util/logging/Logger;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;", "task", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "queue", "Lkotlin/Function0;", "", "messageBlock", "", "taskLog", "(Ljava/util/logging/Logger;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;Lkotlin/jvm/functions/Function0;)V", "T", "block", "logElapsed", "(Ljava/util/logging/Logger;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "message", "log", "(Ljava/util/logging/Logger;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;Ljava/lang/String;)V", "", "ns", "formatDuration", "(J)Ljava/lang/String;", "okhttp"})
public final class TaskLoggerKt {
    public static final void taskLog(@NotNull Logger $this$taskLog, @NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$taskLog, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"messageBlock");
        boolean $i$f$taskLog = false;
        if ($this$taskLog.isLoggable(Level.FINE)) {
            TaskLoggerKt.log($this$taskLog, task, queue, (String)messageBlock.invoke());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T logElapsed(@NotNull Logger $this$logElapsed, @NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$logElapsed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$logElapsed = false;
        long startNs = -1L;
        boolean loggingEnabled = $this$logElapsed.isLoggable(Level.FINE);
        if (loggingEnabled) {
            startNs = queue.getTaskRunner$okhttp().getBackend().nanoTime();
            TaskLoggerKt.log($this$logElapsed, task, queue, "starting");
        }
        boolean completedNormally = false;
        try {
            Object result = block.invoke();
            completedNormally = true;
            object = result;
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            if (loggingEnabled) {
                long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
                if (completedNormally) {
                    TaskLoggerKt.log($this$logElapsed, task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
                } else {
                    TaskLoggerKt.log($this$logElapsed, task, queue, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs));
                }
            }
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        if (loggingEnabled) {
            long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
            TaskLoggerKt.log($this$logElapsed, task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
        }
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }

    private static final void log(Logger $this$log, Task task, TaskQueue queue, String message) {
        StringBuilder stringBuilder = new StringBuilder().append(queue.getName$okhttp()).append(' ');
        String string = "%-22s";
        Object[] objectArray = new Object[]{message};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        $this$log.fine(stringBuilder.append(string2).append(": ").append(task.getName()).toString());
    }

    @NotNull
    public static final String formatDuration(long ns) {
        String s = ns <= -999500000L ? (ns - (long)500000000) / (long)1000000000 + " s " : (ns <= -999500L ? (ns - (long)500000) / (long)1000000 + " ms" : (ns <= 0L ? (ns - (long)500) / (long)1000 + " \u00b5s" : (ns < 999500L ? (ns + (long)500) / (long)1000 + " \u00b5s" : (ns < 999500000L ? (ns + (long)500000) / (long)1000000 + " ms" : (ns + (long)500000000) / (long)1000000000 + " s "))));
        String string = "%6s";
        Object[] objectArray = new Object[]{s};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

