/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Task;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskLoggerKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskRunner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001?B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0004\b\r\u0010\u0011J7\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001c\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001d\u001a\u00020\f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\f\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u000f\u0010\"\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010$R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010$R\"\u0010\u001f\u001a\u00020\u00128\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010*\u001a\u0004\b+\u0010!\"\u0004\b,\u0010-R$\u0010.\u001a\u0004\u0018\u00010\b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R \u00105\u001a\b\u0012\u0004\u0012\u00020\b048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\"\u00109\u001a\u00020\u00128\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010*\u001a\u0004\b:\u0010!\"\u0004\b;\u0010-R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020\b0<8F\u00a2\u0006\u0006\u001a\u0004\b=\u00108\u00a8\u0006@"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "name", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;Ljava/lang/String;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;", "task", "", "delayNanos", "", "schedule", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;J)V", "Lkotlin/Function0;", "block", "(Ljava/lang/String;JLkotlin/jvm/functions/Function0;)V", "", "cancelable", "execute", "(Ljava/lang/String;JZLkotlin/jvm/functions/Function0;)V", "Ljava/util/concurrent/CountDownLatch;", "idleLatch", "()Ljava/util/concurrent/CountDownLatch;", "recurrence", "scheduleAndDecide$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;JZ)Z", "scheduleAndDecide", "cancelAll", "()V", "shutdown", "cancelAllAndDecide$okhttp", "()Z", "cancelAllAndDecide", "toString", "()Ljava/lang/String;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "getTaskRunner$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "Ljava/lang/String;", "getName$okhttp", "Z", "getShutdown$okhttp", "setShutdown$okhttp", "(Z)V", "activeTask", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;", "getActiveTask$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;", "setActiveTask$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;)V", "", "futureTasks", "Ljava/util/List;", "getFutureTasks$okhttp", "()Ljava/util/List;", "cancelActiveTask", "getCancelActiveTask$okhttp", "setCancelActiveTask$okhttp", "", "getScheduledTasks", "scheduledTasks", "AwaitIdleTask", "okhttp"})
@SourceDebugExtension(value={"SMAP\nTaskQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 3 TaskLogger.kt\nokhttp3/internal/concurrent/TaskLoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n63#2:242\n63#2:243\n63#2:252\n49#2,4:268\n63#2:272\n49#2,4:273\n63#2:277\n26#3,4:244\n26#3,4:248\n26#3,4:253\n26#3,4:257\n26#3,4:278\n360#4,7:261\n*S KotlinDebug\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n*L\n48#1:242\n64#1:243\n122#1:252\n202#1:268,4\n204#1:272\n212#1:273,4\n214#1:277\n67#1:244,4\n70#1:248,4\n173#1:253,4\n179#1:257,4\n231#1:278,4\n188#1:261,7\n*E\n"})
public final class TaskQueue {
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final String name;
    private boolean shutdown;
    @Nullable
    private Task activeTask;
    @NotNull
    private final List<Task> futureTasks;
    private boolean cancelActiveTask;

    public TaskQueue(@NotNull TaskRunner taskRunner, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.taskRunner = taskRunner;
        this.name = name;
        this.futureTasks = new ArrayList();
    }

    @NotNull
    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    @NotNull
    public final String getName$okhttp() {
        return this.name;
    }

    public final boolean getShutdown$okhttp() {
        return this.shutdown;
    }

    public final void setShutdown$okhttp(boolean bl) {
        this.shutdown = bl;
    }

    @Nullable
    public final Task getActiveTask$okhttp() {
        return this.activeTask;
    }

    public final void setActiveTask$okhttp(@Nullable Task task) {
        this.activeTask = task;
    }

    @NotNull
    public final List<Task> getFutureTasks$okhttp() {
        return this.futureTasks;
    }

    public final boolean getCancelActiveTask$okhttp() {
        return this.cancelActiveTask;
    }

    public final void setCancelActiveTask$okhttp(boolean bl) {
        this.cancelActiveTask = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Task> getScheduledTasks() {
        List list;
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.futureTasks);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void schedule(@NotNull Task task, long delayNanos) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.shutdown) {
                if (task.getCancelable()) {
                    void $this$taskLog$iv;
                    Logger logger = this.taskRunner.getLogger$okhttp();
                    Task task2 = task;
                    TaskQueue queue$iv = this;
                    boolean $i$f$taskLog = false;
                    if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                        void task$iv;
                        TaskQueue taskQueue = queue$iv;
                        void var13_17 = task$iv;
                        void var14_19 = $this$taskLog$iv;
                        boolean bl2 = false;
                        String string = "schedule canceled (queue is shutdown)";
                        TaskLoggerKt.access$log((Logger)var14_19, (Task)var13_17, taskQueue, string);
                    }
                    return;
                }
                Logger $this$taskLog$iv = this.taskRunner.getLogger$okhttp();
                Task task$iv = task;
                TaskQueue queue$iv = this;
                boolean $i$f$taskLog = false;
                if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                    TaskQueue taskQueue = queue$iv;
                    Task task3 = task$iv;
                    Logger logger = $this$taskLog$iv;
                    boolean bl3 = false;
                    String string = "schedule failed (queue is shutdown)";
                    TaskLoggerKt.access$log(logger, task3, taskQueue, string);
                }
                throw new RejectedExecutionException();
            }
            if (this.scheduleAndDecide$okhttp(task, delayNanos, false)) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void schedule$default(TaskQueue taskQueue, Task task, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        taskQueue.schedule(task, l);
    }

    public final void schedule(@NotNull String name, long delayNanos, @NotNull Function0<Long> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.schedule(new Task(name, block){
            final /* synthetic */ Function0<Long> $block;
            {
                this.$block = $block;
                super($name, false, 2, null);
            }

            public long runOnce() {
                return ((Number)this.$block.invoke()).longValue();
            }
        }, delayNanos);
    }

    public static /* synthetic */ void schedule$default(TaskQueue taskQueue, String string, long l, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        taskQueue.schedule(string, l, (Function0<Long>)function0);
    }

    public final void execute(@NotNull String name, long delayNanos, boolean cancelable, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.schedule(new Task(name, cancelable, block){
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$block = $block;
                super($name, $cancelable);
            }

            public long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, delayNanos);
    }

    public static /* synthetic */ void execute$default(TaskQueue taskQueue, String string, long l, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        taskQueue.execute(string, l, bl, (Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CountDownLatch idleLatch() {
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block9: {
                block8: {
                    boolean bl = false;
                    if (this.activeTask != null || !this.futureTasks.isEmpty()) break block8;
                    CountDownLatch countDownLatch = new CountDownLatch(0);
                    return countDownLatch;
                }
                Task existingTask = this.activeTask;
                if (!(existingTask instanceof AwaitIdleTask)) break block9;
                CountDownLatch countDownLatch = ((AwaitIdleTask)existingTask).getLatch();
                return countDownLatch;
            }
            for (Task futureTask : this.futureTasks) {
                if (!(futureTask instanceof AwaitIdleTask)) continue;
                CountDownLatch countDownLatch = ((AwaitIdleTask)futureTask).getLatch();
                return countDownLatch;
            }
            AwaitIdleTask newTask = new AwaitIdleTask();
            if (this.scheduleAndDecide$okhttp(newTask, 0L, false)) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            CountDownLatch countDownLatch = newTask.getLatch();
            return countDownLatch;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean scheduleAndDecide$okhttp(@NotNull Task task, long delayNanos, boolean recurrence) {
        int insertAt;
        block7: {
            int n;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.initQueue$okhttp(this);
            long now = this.taskRunner.getBackend().nanoTime();
            long executeNanoTime = now + delayNanos;
            int existingIndex = this.futureTasks.indexOf(task);
            if (existingIndex != -1) {
                if (task.getNextExecuteNanoTime$okhttp() <= executeNanoTime) {
                    void $this$taskLog$iv;
                    Logger logger = this.taskRunner.getLogger$okhttp();
                    Task task2 = task;
                    TaskQueue queue$iv = this;
                    boolean $i$f$taskLog = false;
                    if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                        void task$iv;
                        TaskQueue taskQueue = queue$iv;
                        void var19_19 = task$iv;
                        void var18_21 = $this$taskLog$iv;
                        boolean bl = false;
                        String string = "already scheduled";
                        TaskLoggerKt.access$log((Logger)var18_21, (Task)var19_19, taskQueue, string);
                    }
                    return false;
                }
                this.futureTasks.remove(existingIndex);
            }
            task.setNextExecuteNanoTime$okhttp(executeNanoTime);
            Logger $this$taskLog$iv = this.taskRunner.getLogger$okhttp();
            Task task$iv = task;
            TaskQueue queue$iv = this;
            boolean $i$f$taskLog = false;
            if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                TaskQueue taskQueue = queue$iv;
                Task task3 = task$iv;
                Logger logger = $this$taskLog$iv;
                boolean bl = false;
                String string = recurrence ? "run again after " + TaskLoggerKt.formatDuration(executeNanoTime - now) : "scheduled after " + TaskLoggerKt.formatDuration(executeNanoTime - now);
                TaskLoggerKt.access$log(logger, task3, taskQueue, string);
            }
            List<Task> $this$indexOfFirst$iv = this.futureTasks;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Task> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Task item$iv;
                Task it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getNextExecuteNanoTime$okhttp() - now > delayNanos) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = insertAt = -1;
        }
        if (insertAt == -1) {
            insertAt = this.futureTasks.size();
        }
        this.futureTasks.add(insertAt, task);
        return insertAt == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelAll() {
        Lockable $this$assertLockNotHeld$iv = this.taskRunner;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Lockable $this$assertLockNotHeld$iv = this.taskRunner;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        Lockable $this$withLock$iv = this.taskRunner;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this.shutdown = true;
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean cancelAllAndDecide$okhttp() {
        if (this.activeTask != null) {
            Task task = this.activeTask;
            Intrinsics.checkNotNull((Object)task);
            if (task.getCancelable()) {
                this.cancelActiveTask = true;
            }
        }
        boolean tasksCanceled = false;
        for (int i = this.futureTasks.size() - 1; -1 < i; --i) {
            void $this$taskLog$iv;
            if (!this.futureTasks.get(i).getCancelable()) continue;
            Logger logger = this.taskRunner.getLogger$okhttp();
            Task task = this.futureTasks.get(i);
            TaskQueue queue$iv = this;
            boolean $i$f$taskLog = false;
            if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                void task$iv;
                TaskQueue taskQueue = queue$iv;
                void var9_9 = task$iv;
                void var8_8 = $this$taskLog$iv;
                boolean bl = false;
                String string = "canceled";
                TaskLoggerKt.access$log((Logger)var8_8, (Task)var9_9, taskQueue, string);
            }
            tasksCanceled = true;
            this.futureTasks.remove(i);
        }
        return tasksCanceled;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue$AwaitIdleTask;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;", "<init>", "()V", "", "runOnce", "()J", "Ljava/util/concurrent/CountDownLatch;", "latch", "Ljava/util/concurrent/CountDownLatch;", "getLatch", "()Ljava/util/concurrent/CountDownLatch;", "okhttp"})
    private static final class AwaitIdleTask
    extends Task {
        @NotNull
        private final CountDownLatch latch = new CountDownLatch(1);

        public AwaitIdleTask() {
            super(_UtilJvmKt.okHttpName + " awaitIdle", false);
        }

        @NotNull
        public final CountDownLatch getLatch() {
            return this.latch;
        }

        @Override
        public long runOnce() {
            this.latch.countDown();
            return -1L;
        }
    }
}

