/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection;

import com.smushytaco.nickname_detector.shaded.okhttp3.Address;
import com.smushytaco.nickname_detector.shaded.okhttp3.ConnectionPool;
import com.smushytaco.nickname_detector.shaded.okhttp3.Route;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Task;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskQueue;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskRunner;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ConnectionListener;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealCall;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnectionPool;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Platform;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u00018\u0018\u0000 >2\u00020\u0001:\u0001>B1\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u000fJA\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001b\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001b\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020 \u00a2\u0006\u0004\b%\u0010&J\u0015\u0010(\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010*\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020 \u00a2\u0006\u0004\b,\u0010&R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010-R\u001a\u0010\u000b\u001a\u00020\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010.\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00109\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001b0;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=\u00a8\u0006?"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "maxIdleConnections", "", "keepAliveDuration", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;", "connectionListener", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;)V", "idleConnectionCount", "()I", "connectionCount", "", "doExtensiveHealthChecks", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "address", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealCall;", "call", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;", "routes", "requireMultiplexed", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "callAcquirePooledConnection$okhttp", "(ZLcom/smushytaco/nickname_detector/shaded/okhttp3/Address;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealCall;Ljava/util/List;Z)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "callAcquirePooledConnection", "connection", "", "put", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;)V", "connectionBecameIdle", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;)Z", "evictAll", "()V", "now", "closeConnections", "(J)J", "pruneAndGetAllocationCount", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;J)I", "scheduleCloser", "I", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;", "getConnectionListener$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;", "keepAliveDurationNs", "J", "getKeepAliveDurationNs$okhttp", "()J", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "cleanupQueue", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "com/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$cleanupTask$1", "cleanupTask", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealConnectionPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,326:1\n1#2:327\n1788#3,3:328\n1791#3:332\n63#4:331\n63#4:333\n63#4:334\n55#4,4:335\n55#4,4:339\n63#4:343\n63#4:344\n63#4:345\n55#4,4:346\n*S KotlinDebug\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n*L\n64#1:328,3\n64#1:332\n65#1:331\n92#1:333\n111#1:334\n127#1:335,4\n139#1:339,4\n157#1:343\n201#1:344\n247#1:345\n287#1:346,4\n*E\n"})
public final class RealConnectionPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxIdleConnections;
    @NotNull
    private final ConnectionListener connectionListener;
    private final long keepAliveDurationNs;
    @NotNull
    private final TaskQueue cleanupQueue;
    @NotNull
    private final cleanupTask.1 cleanupTask;
    @NotNull
    private final ConcurrentLinkedQueue<RealConnection> connections;

    public RealConnectionPool(@NotNull TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, @NotNull TimeUnit timeUnit, @NotNull ConnectionListener connectionListener) {
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkNotNullParameter((Object)connectionListener, (String)"connectionListener");
        this.maxIdleConnections = maxIdleConnections;
        this.connectionListener = connectionListener;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.cleanupQueue = taskRunner.newQueue();
        String string = _UtilJvmKt.okHttpName + " ConnectionPool connection closer";
        this.cleanupTask = new Task(this, string){
            final /* synthetic */ RealConnectionPool this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false, 2, null);
            }

            public long runOnce() {
                return this.this$0.closeConnections(System.nanoTime());
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        if (!(keepAliveDuration > 0L)) {
            boolean bl = false;
            String string2 = "keepAliveDuration <= 0: " + keepAliveDuration;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final ConnectionListener getConnectionListener$okhttp() {
        return this.connectionListener;
    }

    public final long getKeepAliveDurationNs$okhttp() {
        return this.keepAliveDurationNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int idleConnectionCount() {
        int n;
        Iterable $this$count$iv = this.connections;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean bl;
                RealConnection it = (RealConnection)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                Lockable $this$withLock$iv = it;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl3 = false;
                    bl = it.getCalls().isEmpty();
                }
                if (!bl || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int connectionCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RealConnection callAcquirePooledConnection$okhttp(boolean doExtensiveHealthChecks, @NotNull Address address, @NotNull RealCall call, @Nullable List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Iterator<RealConnection> iterator = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RealConnection> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Socket socket;
            boolean bl;
            RealConnection connection = iterator2.next();
            Intrinsics.checkNotNull((Object)connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl2;
                boolean bl3 = false;
                if (requireMultiplexed && !connection.isMultiplexed$okhttp()) {
                    bl2 = false;
                } else if (!connection.isEligible$okhttp(address, routes)) {
                    bl2 = false;
                } else {
                    call.acquireConnectionNoEvents(connection);
                    bl2 = true;
                }
                bl = bl2;
            }
            boolean acquired = bl;
            if (!acquired) continue;
            if (connection.isHealthy(doExtensiveHealthChecks)) {
                return connection;
            }
            boolean noNewExchangesEvent = false;
            Lockable $this$withLock$iv2 = connection;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl4 = false;
                noNewExchangesEvent = !connection.getNoNewExchanges();
                connection.setNoNewExchanges(true);
                socket = call.releaseConnectionNoEvents$okhttp();
            }
            Socket toClose = socket;
            if (toClose != null) {
                _UtilJvmKt.closeQuietly(toClose);
                this.connectionListener.connectionClosed(connection);
                continue;
            }
            if (!noNewExchangesEvent) continue;
            this.connectionListener.noNewExchanges(connection);
        }
        return null;
    }

    public final void put(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Lockable $this$assertLockHeld$iv = connection;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        this.connections.add(connection);
        this.scheduleCloser();
    }

    public final boolean connectionBecameIdle(@NotNull RealConnection connection) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Lockable $this$assertLockHeld$iv = connection;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            connection.setNoNewExchanges(true);
            this.connections.remove(connection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            bl = true;
        } else {
            this.scheduleCloser();
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Iterator<RealConnection> iterator = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RealConnection> i = iterator;
        while (i.hasNext()) {
            Socket socket;
            RealConnection connection = i.next();
            Intrinsics.checkNotNull((Object)connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                Socket socket2;
                boolean bl = false;
                if (connection.getCalls().isEmpty()) {
                    i.remove();
                    connection.setNoNewExchanges(true);
                    socket2 = connection.socket();
                } else {
                    socket2 = null;
                }
                socket = socket2;
            }
            Socket socketToClose = socket;
            if (socketToClose == null) continue;
            _UtilJvmKt.closeQuietly(socketToClose);
            this.connectionListener.connectionClosed(connection);
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long closeConnections(long now) {
        long earliestOldIdleAtNs = 0L;
        earliestOldIdleAtNs = now - this.keepAliveDurationNs + 1L;
        RealConnection earliestOldConnection = null;
        long earliestEvictableIdleAtNs = 0L;
        earliestEvictableIdleAtNs = Long.MAX_VALUE;
        RealConnection earliestEvictableConnection = null;
        int inUseConnectionCount = 0;
        int evictableConnectionCount = 0;
        Iterator<RealConnection> iterator = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RealConnection> iterator2 = iterator;
        while (iterator2.hasNext()) {
            RealConnection connection = iterator2.next();
            Intrinsics.checkNotNull((Object)connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl = false;
                if (this.pruneAndGetAllocationCount(connection, now) > 0) {
                    ++inUseConnectionCount;
                } else {
                    long idleAtNs = connection.getIdleAtNs();
                    if (idleAtNs < earliestOldIdleAtNs) {
                        earliestOldIdleAtNs = idleAtNs;
                        earliestOldConnection = connection;
                    }
                    ++evictableConnectionCount;
                    if (idleAtNs < earliestEvictableIdleAtNs) {
                        earliestEvictableIdleAtNs = idleAtNs;
                        earliestEvictableConnection = connection;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        RealConnection toEvict = null;
        long toEvictIdleAtNs = 0L;
        if (earliestOldConnection != null) {
            toEvict = earliestOldConnection;
            toEvictIdleAtNs = earliestOldIdleAtNs;
        } else if (evictableConnectionCount > this.maxIdleConnections) {
            toEvict = earliestEvictableConnection;
            toEvictIdleAtNs = earliestEvictableIdleAtNs;
        } else {
            toEvict = null;
            toEvictIdleAtNs = -1L;
        }
        if (toEvict != null) {
            Lockable $this$withLock$iv = toEvict;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                block22: {
                    block21: {
                        boolean bl = false;
                        if (!(!((Collection)toEvict.getCalls()).isEmpty())) break block21;
                        long l = 0L;
                        return l;
                    }
                    if (toEvict.getIdleAtNs() == toEvictIdleAtNs) break block22;
                    long l = 0L;
                    return l;
                }
                toEvict.setNoNewExchanges(true);
                boolean bl = this.connections.remove(toEvict);
            }
            _UtilJvmKt.closeQuietly(toEvict.socket());
            this.connectionListener.connectionClosed(toEvict);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
        if (earliestEvictableConnection != null) {
            return earliestEvictableIdleAtNs + this.keepAliveDurationNs - now;
        }
        if (inUseConnectionCount > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    private final int pruneAndGetAllocationCount(RealConnection connection, long now) {
        Lockable $this$assertLockHeld$iv = connection;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        List<Reference<RealCall>> references = connection.getCalls();
        int i = 0;
        while (i < references.size()) {
            Reference<RealCall> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Intrinsics.checkNotNull(reference, (String)"null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            RealCall.CallReference callReference = (RealCall.CallReference)reference;
            String message = "A connection to " + connection.route().address().url() + " was leaked. Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message, callReference.getCallStackTrace());
            references.remove(i);
            if (!references.isEmpty()) continue;
            connection.setIdleAtNs(now - this.keepAliveDurationNs);
            return 0;
        }
        return references.size();
    }

    public final void scheduleCloser() {
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$Companion;", "", "<init>", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/ConnectionPool;", "connectionPool", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "get", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/ConnectionPool;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RealConnectionPool get(@NotNull ConnectionPool connectionPool) {
            Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
            return connectionPool.getDelegate$okhttp();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

