/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http;

import com.smushytaco.nickname_detector.shaded.okhttp3.Cookie;
import com.smushytaco.nickname_detector.shaded.okhttp3.CookieJar;
import com.smushytaco.nickname_detector.shaded.okhttp3.Headers;
import com.smushytaco.nickname_detector.shaded.okhttp3.Interceptor;
import com.smushytaco.nickname_detector.shaded.okhttp3.MediaType;
import com.smushytaco.nickname_detector.shaded.okhttp3.Request;
import com.smushytaco.nickname_detector.shaded.okhttp3.RequestBody;
import com.smushytaco.nickname_detector.shaded.okhttp3.Response;
import com.smushytaco.nickname_detector.shaded.okhttp3.ResponseBody;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.HttpHeaders;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.RealResponseBody;
import com.smushytaco.nickname_detector.shaded.okio.GzipSource;
import com.smushytaco.nickname_detector.shaded.okio.Okio;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/BridgeInterceptor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/CookieJar;", "cookieJar", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/CookieJar;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor$Chain;", "chain", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "intercept", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor$Chain;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Cookie;", "cookies", "", "cookieHeader", "(Ljava/util/List;)Ljava/lang/String;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/CookieJar;", "okhttp"})
@SourceDebugExtension(value={"SMAP\nBridgeInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeInterceptor.kt\nokhttp3/internal/http/BridgeInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1878#2,3:126\n*S KotlinDebug\n*F\n+ 1 BridgeInterceptor.kt\nokhttp3/internal/http/BridgeInterceptor\n*L\n119#1:126,3\n*E\n"})
public final class BridgeInterceptor
implements Interceptor {
    @NotNull
    private final CookieJar cookieJar;

    public BridgeInterceptor(@NotNull CookieJar cookieJar) {
        Intrinsics.checkNotNullParameter((Object)cookieJar, (String)"cookieJar");
        this.cookieJar = cookieJar;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        ResponseBody responseBody;
        List<Cookie> cookies;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request userRequest = chain.request();
        Request.Builder requestBuilder = userRequest.newBuilder();
        RequestBody body = userRequest.body();
        if (body != null) {
            Request.Builder builder;
            long contentLength;
            MediaType contentType = body.contentType();
            if (contentType != null) {
                requestBuilder.header("Content-Type", contentType.toString());
            }
            if ((contentLength = body.contentLength()) != -1L) {
                requestBuilder.header("Content-Length", String.valueOf(contentLength));
                builder = requestBuilder.removeHeader("Transfer-Encoding");
            } else {
                requestBuilder.header("Transfer-Encoding", "chunked");
                builder = requestBuilder.removeHeader("Content-Length");
            }
        }
        if (userRequest.header("Host") == null) {
            requestBuilder.header("Host", _UtilJvmKt.toHostHeader$default(userRequest.url(), false, 1, null));
        }
        if (userRequest.header("Connection") == null) {
            requestBuilder.header("Connection", "Keep-Alive");
        }
        boolean transparentGzip = false;
        if (userRequest.header("Accept-Encoding") == null && userRequest.header("Range") == null) {
            transparentGzip = true;
            requestBuilder.header("Accept-Encoding", "gzip");
        }
        if (!((Collection)(cookies = this.cookieJar.loadForRequest(userRequest.url()))).isEmpty()) {
            requestBuilder.header("Cookie", this.cookieHeader(cookies));
        }
        if (userRequest.header("User-Agent") == null) {
            requestBuilder.header("User-Agent", "okhttp/5.3.2");
        }
        Request networkRequest = requestBuilder.build();
        Response networkResponse = chain.proceed(networkRequest);
        HttpHeaders.receiveHeaders(this.cookieJar, networkRequest.url(), networkResponse.headers());
        Response.Builder responseBuilder = networkResponse.newBuilder().request(networkRequest);
        if (transparentGzip && StringsKt.equals((String)"gzip", (String)Response.header$default(networkResponse, "Content-Encoding", null, 2, null), (boolean)true) && HttpHeaders.promisesBody(networkResponse) && (responseBody = networkResponse.body()) != null) {
            GzipSource gzipSource = new GzipSource(responseBody.source());
            Headers strippedHeaders = networkResponse.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            responseBuilder.headers(strippedHeaders);
            String contentType = Response.header$default(networkResponse, "Content-Type", null, 2, null);
            responseBuilder.body(new RealResponseBody(contentType, -1L, Okio.buffer(gzipSource)));
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final String cookieHeader(List<Cookie> cookies) {
        StringBuilder stringBuilder;
        StringBuilder $this$cookieHeader_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = cookies;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cookie;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Cookie cookie2 = (Cookie)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index > 0) {
                $this$cookieHeader_u24lambda_u240.append("; ");
            }
            $this$cookieHeader_u24lambda_u240.append(cookie.name()).append('=').append(cookie.value());
        }
        return stringBuilder.toString();
    }
}

