/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okio.ByteString;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001bR\u0014\u0010 \u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010\u001bR\u0014\u0010!\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b!\u0010\u001bR\u0014\u0010\"\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001bR\u0014\u0010#\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b#\u0010\u001bR\u0014\u0010$\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b$\u0010\u001bR\u0014\u0010%\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010\u001bR\u0014\u0010&\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010\u001bR\u0014\u0010'\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010\u001bR\u0014\u0010(\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010\u001bR\u0014\u0010)\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b)\u0010\u001bR\u0014\u0010*\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b*\u0010\u001bR\u0014\u0010+\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b+\u0010\u001bR\u0014\u0010,\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b,\u0010\u001bR\u0014\u0010-\u001a\u00020\u00068\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b-\u0010\u001bR\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001c\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00100R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00100\u00a8\u00063"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2;", "", "<init>", "()V", "", "inbound", "", "streamId", "length", "type", "flags", "", "frameLog", "(ZIIII)Ljava/lang/String;", "", "windowSizeIncrement", "frameLogWindowUpdate", "(ZIIJ)Ljava/lang/String;", "formattedType$okhttp", "(I)Ljava/lang/String;", "formattedType", "formatFlags", "(II)Ljava/lang/String;", "Lcom/smushytaco/nickname_detector/shaded/okio/ByteString;", "CONNECTION_PREFACE", "Lcom/smushytaco/nickname_detector/shaded/okio/ByteString;", "INITIAL_MAX_FRAME_SIZE", "I", "TYPE_DATA", "TYPE_HEADERS", "TYPE_PRIORITY", "TYPE_RST_STREAM", "TYPE_SETTINGS", "TYPE_PUSH_PROMISE", "TYPE_PING", "TYPE_GOAWAY", "TYPE_WINDOW_UPDATE", "TYPE_CONTINUATION", "FLAG_NONE", "FLAG_ACK", "FLAG_END_STREAM", "FLAG_END_HEADERS", "FLAG_END_PUSH_PROMISE", "FLAG_PADDED", "FLAG_PRIORITY", "FLAG_COMPRESSED", "", "FRAME_NAMES", "[Ljava/lang/String;", "FLAGS", "BINARY", "okhttp"})
public final class Http2 {
    @NotNull
    public static final Http2 INSTANCE;
    @JvmField
    @NotNull
    public static final ByteString CONNECTION_PREFACE;
    public static final int INITIAL_MAX_FRAME_SIZE = 16384;
    public static final int TYPE_DATA = 0;
    public static final int TYPE_HEADERS = 1;
    public static final int TYPE_PRIORITY = 2;
    public static final int TYPE_RST_STREAM = 3;
    public static final int TYPE_SETTINGS = 4;
    public static final int TYPE_PUSH_PROMISE = 5;
    public static final int TYPE_PING = 6;
    public static final int TYPE_GOAWAY = 7;
    public static final int TYPE_WINDOW_UPDATE = 8;
    public static final int TYPE_CONTINUATION = 9;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ACK = 1;
    public static final int FLAG_END_STREAM = 1;
    public static final int FLAG_END_HEADERS = 4;
    public static final int FLAG_END_PUSH_PROMISE = 4;
    public static final int FLAG_PADDED = 8;
    public static final int FLAG_PRIORITY = 32;
    public static final int FLAG_COMPRESSED = 32;
    @NotNull
    private static final String[] FRAME_NAMES;
    @NotNull
    private static final String[] FLAGS;
    @NotNull
    private static final String[] BINARY;

    private Http2() {
    }

    @NotNull
    public final String frameLog(boolean inbound, int streamId, int length, int type, int flags) {
        String formattedType = this.formattedType$okhttp(type);
        String formattedFlags = this.formatFlags(type, flags);
        String direction = inbound ? "<<" : ">>";
        Object[] objectArray = new Object[]{direction, streamId, length, formattedType, formattedFlags};
        return _UtilJvmKt.format("%s 0x%08x %5d %-13s %s", objectArray);
    }

    @NotNull
    public final String frameLogWindowUpdate(boolean inbound, int streamId, int length, long windowSizeIncrement) {
        String formattedType = this.formattedType$okhttp(8);
        String direction = inbound ? "<<" : ">>";
        Object[] objectArray = new Object[]{direction, streamId, length, formattedType, windowSizeIncrement};
        return _UtilJvmKt.format("%s 0x%08x %5d %-13s %d", objectArray);
    }

    @NotNull
    public final String formattedType$okhttp(int type) {
        String string;
        if (type < FRAME_NAMES.length) {
            string = FRAME_NAMES[type];
        } else {
            Object[] objectArray = new Object[]{type};
            string = _UtilJvmKt.format("0x%02x", objectArray);
        }
        return string;
    }

    @NotNull
    public final String formatFlags(int type, int flags) {
        String string;
        if (flags == 0) {
            return "";
        }
        switch (type) {
            case 4: 
            case 6: {
                return flags == 1 ? "ACK" : BINARY[flags];
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return BINARY[flags];
            }
        }
        if (flags < FLAGS.length) {
            String string2 = FLAGS[flags];
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            string = BINARY[flags];
        }
        String result = string;
        return type == 5 && (flags & 4) != 0 ? StringsKt.replace$default((String)result, (String)"HEADERS", (String)"PUSH_PROMISE", (boolean)false, (int)4, null) : (type == 0 && (flags & 0x20) != 0 ? StringsKt.replace$default((String)result, (String)"PRIORITY", (String)"COMPRESSED", (boolean)false, (int)4, null) : result);
    }

    /*
     * WARNING - void declaration
     */
    static {
        int nArray;
        void var0_2;
        INSTANCE = new Http2();
        CONNECTION_PREFACE = ByteString.Companion.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        String[] stringArray = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FRAME_NAMES = stringArray;
        FLAGS = new String[64];
        boolean n2 = false;
        Object[] i = new String[256];
        while (var0_2 < 256) {
            nArray = var0_2++;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toBinaryString(nArray), (String)"toBinaryString(...)");
            i[nArray] = StringsKt.replace$default((String)_UtilJvmKt.format("%8s", objectArray), (char)' ', (char)'0', (boolean)false, (int)4, null);
        }
        BINARY = i;
        Http2.FLAGS[0] = "";
        Http2.FLAGS[1] = "END_STREAM";
        i = new int[1];
        i[0] = (String)true;
        Object[] objectArray = i;
        Http2.FLAGS[8] = "PADDED";
        nArray = objectArray.length;
        for (int j = 0; j < nArray; ++j) {
            String prefixFlag = objectArray[j];
            Http2.FLAGS[prefixFlag | 8] = FLAGS[prefixFlag] + "|PADDED";
        }
        Http2.FLAGS[4] = "END_HEADERS";
        Http2.FLAGS[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        int[] nArray2 = new int[]{4, 32, 36};
        for (int frameFlag : nArray2) {
            for (String prefixFlag : objectArray) {
                Http2.FLAGS[prefixFlag | frameFlag] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag];
                Http2.FLAGS[prefixFlag | frameFlag | 8] = FLAGS[prefixFlag] + '|' + FLAGS[frameFlag] + "|PADDED";
            }
        }
        int n = FLAGS.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (FLAGS[i2] != null) continue;
            Http2.FLAGS[i2] = BINARY[i2];
        }
    }
}

