/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2;

import com.smushytaco.nickname_detector.shaded.okhttp3.Headers;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilCommonKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskQueue;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskRunner;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.BufferedSocket;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.ConnectionShutdownException;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.ErrorCode;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.FlowControlListener;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Header;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Http2Reader;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Http2Stream;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Http2Writer;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.PushObserver;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Settings;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.flowcontrol.WindowCounter;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Platform;
import com.smushytaco.nickname_detector.shaded.okio.Buffer;
import com.smushytaco.nickname_detector.shaded.okio.BufferedSource;
import com.smushytaco.nickname_detector.shaded.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0007\u0018\u0000 \u00c1\u00012\u00020\u00012\u00020\u0002:\b\u00c2\u0001\u00c3\u0001\u00c4\u0001\u00c1\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001f\u0010 J-\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001eJ-\u0010%\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u00a2\u0006\u0004\b#\u0010$J/\u0010)\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010(\u001a\u00020\u0011\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010/\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0004\b-\u0010.J\u001f\u00102\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u00100\u001a\u00020+H\u0000\u00a2\u0006\u0004\b1\u0010.J\u001f\u00106\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b4\u00105J%\u0010:\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007\u00a2\u0006\u0004\b:\u0010;J\r\u0010<\u001a\u00020\u0013\u00a2\u0006\u0004\b<\u0010=J\r\u0010:\u001a\u00020\u0013\u00a2\u0006\u0004\b:\u0010=J\r\u0010>\u001a\u00020\u0013\u00a2\u0006\u0004\b>\u0010=J\r\u0010?\u001a\u00020\u0013\u00a2\u0006\u0004\b?\u0010=J\u0015\u0010@\u001a\u00020\u00132\u0006\u00100\u001a\u00020+\u00a2\u0006\u0004\b@\u0010AJ\u000f\u0010B\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\bB\u0010=J)\u0010B\u001a\u00020\u00132\u0006\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020+2\b\u0010F\u001a\u0004\u0018\u00010EH\u0000\u00a2\u0006\u0004\bG\u0010HJ\u0019\u0010J\u001a\u00020\u00132\b\u0010I\u001a\u0004\u0018\u00010EH\u0002\u00a2\u0006\u0004\bJ\u0010KJ\u0019\u0010M\u001a\u00020\u00132\b\b\u0002\u0010L\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\bM\u0010NJ\u0015\u0010Q\u001a\u00020\u00132\u0006\u0010P\u001a\u00020O\u00a2\u0006\u0004\bQ\u0010RJ\u0015\u0010T\u001a\u00020\u001b2\u0006\u0010S\u001a\u00020\u0011\u00a2\u0006\u0004\bT\u0010UJ\u000f\u0010W\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\bV\u0010=J\u0017\u0010Z\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\bX\u0010YJ%\u0010]\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u00a2\u0006\u0004\b[\u0010\\J-\u0010a\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010^\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b_\u0010`J/\u0010f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010c\u001a\u00020b2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\bd\u0010eJ\u001f\u0010h\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0004\bg\u0010.R\u001a\u0010i\u001a\u00020\u001b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bi\u0010j\u001a\u0004\bk\u0010lR\u001a\u0010n\u001a\u00020m8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bn\u0010o\u001a\u0004\bp\u0010qR&\u0010s\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bs\u0010t\u001a\u0004\bu\u0010vR\u001a\u0010x\u001a\u00020w8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bx\u0010y\u001a\u0004\bz\u0010{R#\u0010|\u001a\u00020\u00078\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0013\n\u0004\b|\u0010}\u001a\u0004\b~\u0010\t\"\u0005\b\u007f\u0010\u0080\u0001R'\u0010\u0081\u0001\u001a\u00020\u00078\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0016\n\u0005\b\u0081\u0001\u0010}\u001a\u0005\b\u0082\u0001\u0010\t\"\u0006\b\u0083\u0001\u0010\u0080\u0001R\u0018\u0010\u0084\u0001\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0084\u0001\u0010jR\u0018\u0010\u0086\u0001\u001a\u00030\u0085\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0086\u0001\u0010\u0087\u0001R\u0018\u0010\u0089\u0001\u001a\u00030\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0089\u0001\u0010\u008a\u0001R\u0018\u0010\u008b\u0001\u001a\u00030\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008b\u0001\u0010\u008a\u0001R\u0018\u0010\u008c\u0001\u001a\u00030\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008c\u0001\u0010\u008a\u0001R\u0018\u0010\u008e\u0001\u001a\u00030\u008d\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008e\u0001\u0010\u008f\u0001R\u0019\u0010\u0090\u0001\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0090\u0001\u0010\u0091\u0001R\u0019\u0010\u0092\u0001\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u0091\u0001R\u0019\u0010\u0093\u0001\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0093\u0001\u0010\u0091\u0001R\u0019\u0010\u0094\u0001\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0094\u0001\u0010\u0091\u0001R\u0019\u0010\u0095\u0001\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0095\u0001\u0010\u0091\u0001R\u0019\u0010\u0096\u0001\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0096\u0001\u0010\u0091\u0001R\u0019\u0010\u0097\u0001\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0097\u0001\u0010\u0091\u0001R \u0010\u0099\u0001\u001a\u00030\u0098\u00018\u0000X\u0080\u0004\u00a2\u0006\u0010\n\u0006\b\u0099\u0001\u0010\u009a\u0001\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001R\u001c\u0010\u009d\u0001\u001a\u00020O8\u0006\u00a2\u0006\u0010\n\u0006\b\u009d\u0001\u0010\u009e\u0001\u001a\u0006\b\u009f\u0001\u0010\u00a0\u0001R(\u0010\u00a1\u0001\u001a\u00020O8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u00a1\u0001\u0010\u009e\u0001\u001a\u0006\b\u00a2\u0001\u0010\u00a0\u0001\"\u0005\b\u00a3\u0001\u0010RR\u001d\u0010\u00a5\u0001\u001a\u00030\u00a4\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u00a5\u0001\u0010\u00a6\u0001\u001a\u0006\b\u00a7\u0001\u0010\u00a8\u0001R*\u0010\u00aa\u0001\u001a\u00020\u00112\u0007\u0010\u00a9\u0001\u001a\u00020\u00118\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u00aa\u0001\u0010\u0091\u0001\u001a\u0006\b\u00ab\u0001\u0010\u00ac\u0001R*\u0010\u00ad\u0001\u001a\u00020\u00112\u0007\u0010\u00a9\u0001\u001a\u00020\u00118\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u00ad\u0001\u0010\u0091\u0001\u001a\u0006\b\u00ae\u0001\u0010\u00ac\u0001R \u0010\u00b0\u0001\u001a\u00030\u00af\u00018\u0000X\u0080\u0004\u00a2\u0006\u0010\n\u0006\b\u00b0\u0001\u0010\u00b1\u0001\u001a\u0006\b\u00b2\u0001\u0010\u00b3\u0001R\u001d\u0010\u00b5\u0001\u001a\u00030\u00b4\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u00b5\u0001\u0010\u00b6\u0001\u001a\u0006\b\u00b7\u0001\u0010\u00b8\u0001R!\u0010\u00ba\u0001\u001a\u00070\u00b9\u0001R\u00020\u00008\u0006\u00a2\u0006\u0010\n\u0006\b\u00ba\u0001\u0010\u00bb\u0001\u001a\u0006\b\u00bc\u0001\u0010\u00bd\u0001R\u001e\u0010\u00bf\u0001\u001a\t\u0012\u0004\u0012\u00020\u00070\u00be\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00bf\u0001\u0010\u00c0\u0001\u00a8\u0006\u00c5\u0001"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Lockable;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;", "builder", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;)V", "", "openStreamCount", "()I", "id", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "getStream", "(I)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "streamId", "removeStream$okhttp", "removeStream", "", "read", "", "updateConnectionFlowControl$okhttp", "(J)V", "updateConnectionFlowControl", "associatedStreamId", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Header;", "requestHeaders", "", "out", "pushStream", "(ILjava/util/List;Z)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "newStream", "(Ljava/util/List;Z)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "outFinished", "alternating", "writeHeaders$okhttp", "(IZLjava/util/List;)V", "writeHeaders", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "buffer", "byteCount", "writeData", "(IZLcom/smushytaco/nickname_detector/shaded/okio/Buffer;J)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;", "errorCode", "writeSynResetLater$okhttp", "(ILcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;)V", "writeSynResetLater", "statusCode", "writeSynReset$okhttp", "writeSynReset", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "(IJ)V", "writeWindowUpdateLater", "reply", "payload1", "payload2", "writePing", "(ZII)V", "writePingAndAwaitPong", "()V", "awaitPong", "flush", "shutdown", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;)V", "close", "connectionCode", "streamCode", "Ljava/io/IOException;", "cause", "close$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;Ljava/io/IOException;)V", "e", "failConnection", "(Ljava/io/IOException;)V", "sendConnectionPreface", "start", "(Z)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "settings", "setSettings", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;)V", "nowNs", "isHealthy", "(J)Z", "sendDegradedPingLater$okhttp", "sendDegradedPingLater", "pushedStream$okhttp", "(I)Z", "pushedStream", "pushRequestLater$okhttp", "(ILjava/util/List;)V", "pushRequestLater", "inFinished", "pushHeadersLater$okhttp", "(ILjava/util/List;Z)V", "pushHeadersLater", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "source", "pushDataLater$okhttp", "(ILcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;IZ)V", "pushDataLater", "pushResetLater$okhttp", "pushResetLater", "client", "Z", "getClient$okhttp", "()Z", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "listener", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "", "streams", "Ljava/util/Map;", "getStreams$okhttp", "()Ljava/util/Map;", "", "connectionName", "Ljava/lang/String;", "getConnectionName$okhttp", "()Ljava/lang/String;", "lastGoodStreamId", "I", "getLastGoodStreamId$okhttp", "setLastGoodStreamId$okhttp", "(I)V", "nextStreamId", "getNextStreamId$okhttp", "setNextStreamId$okhttp", "isShutdown", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "writerQueue", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "pushQueue", "settingsListenerQueue", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/PushObserver;", "pushObserver", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/PushObserver;", "intervalPingsSent", "J", "intervalPongsReceived", "degradedPingsSent", "degradedPongsReceived", "awaitPingsSent", "awaitPongsReceived", "degradedPongDeadlineNs", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;", "flowControlListener", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;", "getFlowControlListener$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;", "okHttpSettings", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/flowcontrol/WindowCounter;", "readBytes", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/flowcontrol/WindowCounter;", "getReadBytes", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/flowcontrol/WindowCounter;", "value", "writeBytesTotal", "getWriteBytesTotal", "()J", "writeBytesMaximum", "getWriteBytesMaximum", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "socket", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "getSocket$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Writer;", "writer", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Writer;", "getWriter", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Writer;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$ReaderRunnable;", "readerRunnable", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$ReaderRunnable;", "", "currentPushRequests", "Ljava/util/Set;", "Companion", "Builder", "ReaderRunnable", "Listener", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 -UtilCommon.kt\nokhttp3/internal/_UtilCommonKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1042:1\n63#2:1043\n63#2:1044\n63#2:1045\n38#2:1046\n63#2:1047\n63#2:1049\n63#2:1050\n63#2:1051\n34#2:1052\n63#2:1053\n63#2:1054\n34#2:1055\n63#2:1056\n63#2:1057\n49#2,4:1058\n63#2:1067\n63#2:1087\n63#2:1088\n63#2:1089\n63#2:1090\n63#2:1091\n63#2:1092\n63#2:1095\n63#2:1101\n63#2:1107\n63#2:1111\n1#3:1048\n228#4,5:1062\n228#4,5:1071\n228#4,5:1077\n228#4,5:1082\n228#4,2:1093\n230#4,3:1096\n228#4,2:1099\n230#4,3:1102\n228#4,2:1105\n230#4,3:1108\n37#5,2:1068\n13805#6:1070\n13806#6:1076\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n*L\n174#1:1043\n176#1:1044\n179#1:1045\n183#1:1046\n190#1:1047\n242#1:1049\n243#1:1050\n313#1:1051\n321#1:1052\n394#1:1053\n405#1:1054\n407#1:1055\n424#1:1056\n426#1:1057\n452#1:1058,4\n459#1:1067\n519#1:1087\n520#1:1088\n531#1:1089\n557#1:1090\n914#1:1091\n152#1:1092\n926#1:1095\n944#1:1101\n971#1:1107\n985#1:1111\n454#1:1062,5\n467#1:1071,5\n473#1:1077,5\n478#1:1082,5\n923#1:1093,2\n923#1:1096,3\n941#1:1099,2\n941#1:1102,3\n967#1:1105,2\n967#1:1108,3\n461#1:1068,2\n466#1:1070\n466#1:1076\n*E\n"})
public final class Http2Connection
implements Closeable,
Lockable {
    @NotNull
    public static final Companion Companion;
    private final boolean client;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Map<Integer, Http2Stream> streams;
    @NotNull
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final TaskQueue writerQueue;
    @NotNull
    private final TaskQueue pushQueue;
    @NotNull
    private final TaskQueue settingsListenerQueue;
    @NotNull
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPingsSent;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    @NotNull
    private final FlowControlListener flowControlListener;
    @NotNull
    private final Settings okHttpSettings;
    @NotNull
    private Settings peerSettings;
    @NotNull
    private final WindowCounter readBytes;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final BufferedSocket socket;
    @NotNull
    private final Http2Writer writer;
    @NotNull
    private final ReaderRunnable readerRunnable;
    @NotNull
    private final Set<Integer> currentPushRequests;
    public static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    @NotNull
    private static final Settings DEFAULT_SETTINGS;
    public static final int INTERVAL_PING = 1;
    public static final int DEGRADED_PING = 2;
    public static final int AWAIT_PING = 3;
    public static final int DEGRADED_PONG_TIMEOUT_NS = 1000000000;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(@NotNull Builder builder) {
        Settings settings;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = builder.getClient$okhttp();
        this.listener = builder.getListener$okhttp();
        this.streams = new LinkedHashMap();
        this.connectionName = builder.getConnectionName$okhttp();
        this.nextStreamId = builder.getClient$okhttp() ? 3 : 2;
        this.taskRunner = builder.getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = builder.getPushObserver$okhttp();
        this.flowControlListener = builder.getFlowControlListener$okhttp();
        Settings settings2 = settings = new Settings();
        Http2Connection http2Connection = this;
        boolean bl = false;
        if (builder.getClient$okhttp()) {
            void $this$okHttpSettings_u24lambda_u240;
            $this$okHttpSettings_u24lambda_u240.set(4, 0x1000000);
        }
        http2Connection.okHttpSettings = settings;
        this.peerSettings = DEFAULT_SETTINGS;
        this.readBytes = new WindowCounter(0);
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = builder.getSocket$okhttp();
        this.writer = new Http2Writer(this.socket.getSink(), this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(this.socket.getSource(), this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (builder.getPingIntervalMillis$okhttp() != 0) {
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(builder.getPingIntervalMillis$okhttp());
            this.writerQueue.schedule(this.connectionName + " ping", pingIntervalNanos, (Function0<Long>)((Function0)() -> Http2Connection._init_$lambda$0(this, pingIntervalNanos)));
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    @NotNull
    public final Listener getListener$okhttp() {
        return this.listener;
    }

    @NotNull
    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    @NotNull
    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final void setNextStreamId$okhttp(int n) {
        this.nextStreamId = n;
    }

    @NotNull
    public final FlowControlListener getFlowControlListener$okhttp() {
        return this.flowControlListener;
    }

    @NotNull
    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    @NotNull
    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final void setPeerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.peerSettings = settings;
    }

    @NotNull
    public final WindowCounter getReadBytes() {
        return this.readBytes;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    @NotNull
    public final BufferedSocket getSocket$okhttp() {
        return this.socket;
    }

    @NotNull
    public final Http2Writer getWriter() {
        return this.writer;
    }

    @NotNull
    public final ReaderRunnable getReaderRunnable() {
        return this.readerRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int openStreamCount() {
        int n;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            n = this.streams.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Http2Stream getStream(int id) {
        Http2Stream http2Stream;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            http2Stream = this.streams.get(id);
        }
        return http2Stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Http2Stream removeStream$okhttp(int streamId) {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            Http2Stream stream = this.streams.remove(streamId);
            Lockable $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$notifyAll$iv).notifyAll();
            Http2Stream http2Stream = stream;
            return http2Stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateConnectionFlowControl$okhttp(long read) {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            WindowCounter.update$default(this.readBytes, read, 0L, 2, null);
            long readBytesToAcknowledge = this.readBytes.getUnacknowledged();
            if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
                this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
                WindowCounter.update$default(this.readBytes, 0L, readBytesToAcknowledge, 1, null);
            }
            this.flowControlListener.receivingConnectionWindowChanged(this.readBytes);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Http2Stream pushStream(int associatedStreamId, @NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        if (!(!this.client)) {
            boolean bl = false;
            String string = "Client cannot push requests.";
            throw new IllegalStateException(string.toString());
        }
        return this.newStream(associatedStreamId, requestHeaders, out);
    }

    @NotNull
    public final Http2Stream newStream(@NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        return this.newStream(0, requestHeaders, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        boolean outFinished = !out;
        boolean inFinished = false;
        boolean flushHeaders = false;
        Http2Stream stream = null;
        int streamId = 0;
        Lockable $this$withLock$iv = this.writer;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            Lockable $this$withLock$iv2 = this;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl2 = false;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, inFinished, null);
                boolean bl3 = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
                Unit unit = Unit.INSTANCE;
            }
            if (associatedStreamId == 0) {
                this.writer.headers(outFinished, streamId, requestHeaders);
            } else {
                if (!(!this.client)) {
                    boolean bl4 = false;
                    String string = "client streams shouldn't have associated stream IDs";
                    throw new IllegalArgumentException(string.toString());
                }
                this.writer.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (flushHeaders) {
            this.writer.flush();
        }
        return stream;
    }

    public final void writeHeaders$okhttp(int streamId, boolean outFinished, @NotNull List<Header> alternating) throws IOException {
        Intrinsics.checkNotNullParameter(alternating, (String)"alternating");
        this.writer.headers(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int streamId, boolean outFinished, @Nullable Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = 0L;
        byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite = 0;
            Lockable $this$withLock$iv = this;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl = false;
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Lockable $this$wait$iv = this;
                        boolean $i$f$wait = false;
                        Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(byteCount2, this.writeBytesMaximum - this.writeBytesTotal);
                toWrite = Math.min(toWrite, this.writer.maxDataLength());
                this.writeBytesTotal += (long)toWrite;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    public final void writeSynResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue.execute$default(this.writerQueue, this.connectionName + '[' + streamId + "] writeSynReset", 0L, false, () -> Http2Connection.writeSynResetLater$lambda$0(this, streamId, errorCode), 6, null);
    }

    public final void writeSynReset$okhttp(int streamId, @NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        this.writer.rstStream(streamId, statusCode);
    }

    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        TaskQueue.execute$default(this.writerQueue, this.connectionName + '[' + streamId + "] windowUpdate", 0L, false, () -> Http2Connection.writeWindowUpdateLater$lambda$0(this, streamId, unacknowledgedBytesRead), 6, null);
    }

    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            this.writer.ping(reply, payload1, payload2);
        }
        catch (IOException e) {
            this.failConnection(e);
        }
    }

    public final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePing() throws InterruptedException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            long l = this.awaitPingsSent;
            this.awaitPingsSent = l + 1L;
            long l2 = l;
        }
        this.writePing(false, 3, 1330343787);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitPong() throws InterruptedException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            while (this.awaitPongsReceived < this.awaitPingsSent) {
                Lockable $this$wait$iv = this;
                boolean $i$f$wait = false;
                Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$wait$iv).wait();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(@NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Lockable $this$withLock$iv = this.writer;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            int lastGoodStreamId = 0;
            Lockable $this$withLock$iv2 = this;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl2 = false;
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.goAway(lastGoodStreamId, statusCode, _UtilCommonKt.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$okhttp(@NotNull ErrorCode connectionCode, @NotNull ErrorCode streamCode, @Nullable IOException cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionCode), (String)"connectionCode");
        Intrinsics.checkNotNullParameter((Object)((Object)streamCode), (String)"streamCode");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean $i$f$ignoreIoExceptions = false;
        try {
            boolean bl = false;
            this.shutdown(connectionCode);
        }
        catch (IOException iOException) {
        }
        Http2Stream[] streamsToClose = null;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (!this.streams.isEmpty()) {
                Collection<Http2Stream> $this$toTypedArray$iv = this.streams.values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                streamsToClose = thisCollection$iv.toArray(new Http2Stream[0]);
                this.streams.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream element$iv;
                Http2Stream stream = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                boolean $i$f$ignoreIoExceptions2 = false;
                try {
                    boolean bl2 = false;
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {
                }
            }
        }
        boolean $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl = false;
            this.writer.close();
        }
        catch (IOException iOException) {
        }
        $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl = false;
            this.socket.cancel();
        }
        catch (IOException iOException) {
        }
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    private final void failConnection(IOException e) {
        this.close$okhttp(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, e);
    }

    @JvmOverloads
    public final void start(boolean sendConnectionPreface) throws IOException {
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                this.writer.windowUpdate(0, windowSize - 65535);
            }
        }
        TaskQueue.execute$default(this.taskRunner.newQueue(), this.connectionName, 0L, false, this.readerRunnable, 6, null);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        http2Connection.start(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Lockable $this$withLock$iv = this.writer;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            Lockable $this$withLock$iv2 = this;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl2 = false;
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
                Unit unit = Unit.INSTANCE;
            }
            this.writer.settings(settings);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isHealthy(long nowNs) {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (!this.isShutdown) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.degradedPongsReceived >= this.degradedPingsSent || nowNs < this.degradedPongDeadlineNs) break block6;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendDegradedPingLater$okhttp() {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + (long)1000000000;
            Unit unit = Unit.INSTANCE;
        }
        TaskQueue.execute$default(this.writerQueue, this.connectionName + " ping", 0L, false, () -> Http2Connection.sendDegradedPingLater$lambda$1(this), 6, null);
    }

    public final boolean pushedStream$okhttp(int streamId) {
        return streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushRequestLater$okhttp(int streamId, @NotNull List<Header> requestHeaders) {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            boolean bl2 = this.currentPushRequests.add(streamId);
        }
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onRequest", 0L, false, () -> Http2Connection.pushRequestLater$lambda$1(this, streamId, requestHeaders), 6, null);
    }

    public final void pushHeadersLater$okhttp(int streamId, @NotNull List<Header> requestHeaders, boolean inFinished) {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onHeaders", 0L, false, () -> Http2Connection.pushHeadersLater$lambda$0(this, streamId, requestHeaders, inFinished), 6, null);
    }

    public final void pushDataLater$okhttp(int streamId, @NotNull BufferedSource source2, int byteCount, boolean inFinished) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Buffer buffer = new Buffer();
        source2.require(byteCount);
        source2.read(buffer, byteCount);
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onData", 0L, false, () -> Http2Connection.pushDataLater$lambda$0(this, streamId, buffer, byteCount, inFinished), 6, null);
    }

    public final void pushResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onReset", 0L, false, () -> Http2Connection.pushResetLater$lambda$0(this, streamId, errorCode), 6, null);
    }

    @JvmOverloads
    public final void start() throws IOException {
        Http2Connection.start$default(this, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long _init_$lambda$0(Http2Connection this$0, long $pingIntervalNanos) {
        boolean bl;
        Lockable $this$withLock$iv = this$0;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl2;
            boolean bl3 = false;
            if (this$0.intervalPongsReceived < this$0.intervalPingsSent) {
                bl2 = true;
            } else {
                long l = this$0.intervalPingsSent;
                this$0.intervalPingsSent = l + 1L;
                bl2 = false;
            }
            bl = bl2;
        }
        boolean failDueToMissingPong = bl;
        if (failDueToMissingPong) {
            this$0.failConnection(null);
            return -1L;
        }
        this$0.writePing(false, 1, 0);
        return $pingIntervalNanos;
    }

    private static final Unit writeSynResetLater$lambda$0(Http2Connection this$0, int $streamId, ErrorCode $errorCode) {
        try {
            this$0.writeSynReset$okhttp($streamId, $errorCode);
        }
        catch (IOException e) {
            this$0.failConnection(e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeWindowUpdateLater$lambda$0(Http2Connection this$0, int $streamId, long $unacknowledgedBytesRead) {
        try {
            this$0.writer.windowUpdate($streamId, $unacknowledgedBytesRead);
        }
        catch (IOException e) {
            this$0.failConnection(e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendDegradedPingLater$lambda$1(Http2Connection this$0) {
        this$0.writePing(false, 2, 0);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushRequestLater$lambda$1(Http2Connection this$0, int $streamId, List $requestHeaders) {
        block5: {
            boolean cancel = this$0.pushObserver.onRequest($streamId, $requestHeaders);
            boolean $i$f$ignoreIoExceptions = false;
            try {
                boolean bl = false;
                if (!cancel) break block5;
                this$0.writer.rstStream($streamId, ErrorCode.CANCEL);
                Lockable $this$withLock$iv = this$0;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl2 = false;
                    this$0.currentPushRequests.remove($streamId);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException iOException) {
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushHeadersLater$lambda$0(Http2Connection this$0, int $streamId, List $requestHeaders, boolean $inFinished) {
        block6: {
            boolean cancel = this$0.pushObserver.onHeaders($streamId, $requestHeaders, $inFinished);
            boolean $i$f$ignoreIoExceptions = false;
            try {
                boolean bl = false;
                if (cancel) {
                    this$0.writer.rstStream($streamId, ErrorCode.CANCEL);
                }
                if (!cancel && !$inFinished) break block6;
                Lockable $this$withLock$iv = this$0;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl2 = false;
                    this$0.currentPushRequests.remove($streamId);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException iOException) {
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushDataLater$lambda$0(Http2Connection this$0, int $streamId, Buffer $buffer, int $byteCount, boolean $inFinished) {
        block6: {
            boolean $i$f$ignoreIoExceptions = false;
            try {
                boolean bl = false;
                boolean cancel = this$0.pushObserver.onData($streamId, $buffer, $byteCount, $inFinished);
                if (cancel) {
                    this$0.writer.rstStream($streamId, ErrorCode.CANCEL);
                }
                if (!cancel && !$inFinished) break block6;
                Lockable $this$withLock$iv = this$0;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl2 = false;
                    this$0.currentPushRequests.remove($streamId);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException iOException) {
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushResetLater$lambda$0(Http2Connection this$0, int $streamId, ErrorCode $errorCode) {
        this$0.pushObserver.onReset($streamId, $errorCode);
        Lockable $this$withLock$iv = this$0;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this$0.currentPushRequests.remove($streamId);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    static {
        Settings settings;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u240 = settings = new Settings();
        boolean bl = false;
        $this$DEFAULT_SETTINGS_u24lambda_u240.set(4, 65535);
        $this$DEFAULT_SETTINGS_u24lambda_u240.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b*\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\t\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bR\"\u0010\u0003\u001a\u00020\u00028\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010#R\"\u0010\t\u001a\u00020\b8\u0000@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b\t\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\"\u0010)\u001a\u00020\n8\u0000@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010\u000e\u001a\u00020\r8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u0010\u0011\u001a\u00020\u00108\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u0010\u0014\u001a\u00020\u00138\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010\u0017\u001a\u00020\u00168\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006C"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;", "", "", "client", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "<init>", "(ZLcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "socket", "", "peerName", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;Ljava/lang/String;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "listener", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/PushObserver;", "pushObserver", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/PushObserver;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;", "", "pingIntervalMillis", "(I)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;", "flowControlListener", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Builder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "build", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "Z", "getClient$okhttp", "()Z", "setClient$okhttp", "(Z)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "getTaskRunner$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "getSocket$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "setSocket$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;)V", "connectionName", "Ljava/lang/String;", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/PushObserver;)V", "I", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;", "getFlowControlListener$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;", "setFlowControlListener$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/FlowControlListener;)V", "okhttp"})
    public static final class Builder {
        private boolean client;
        @NotNull
        private final TaskRunner taskRunner;
        public BufferedSocket socket;
        public String connectionName;
        @NotNull
        private Listener listener;
        @NotNull
        private PushObserver pushObserver;
        private int pingIntervalMillis;
        @NotNull
        private FlowControlListener flowControlListener;

        public Builder(boolean client, @NotNull TaskRunner taskRunner) {
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            this.client = client;
            this.taskRunner = taskRunner;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
            this.flowControlListener = FlowControlListener.None.INSTANCE;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final void setClient$okhttp(boolean bl) {
            this.client = bl;
        }

        @NotNull
        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        @NotNull
        public final BufferedSocket getSocket$okhttp() {
            BufferedSocket bufferedSocket2 = this.socket;
            if (bufferedSocket2 != null) {
                return bufferedSocket2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            return null;
        }

        public final void setSocket$okhttp(@NotNull BufferedSocket bufferedSocket2) {
            Intrinsics.checkNotNullParameter((Object)bufferedSocket2, (String)"<set-?>");
            this.socket = bufferedSocket2;
        }

        @NotNull
        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectionName");
            return null;
        }

        public final void setConnectionName$okhttp(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.connectionName = string;
        }

        @NotNull
        public final Listener getListener$okhttp() {
            return this.listener;
        }

        public final void setListener$okhttp(@NotNull Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"<set-?>");
            this.listener = listener;
        }

        @NotNull
        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final void setPushObserver$okhttp(@NotNull PushObserver pushObserver) {
            Intrinsics.checkNotNullParameter((Object)pushObserver, (String)"<set-?>");
            this.pushObserver = pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        public final void setPingIntervalMillis$okhttp(int n) {
            this.pingIntervalMillis = n;
        }

        @NotNull
        public final FlowControlListener getFlowControlListener$okhttp() {
            return this.flowControlListener;
        }

        public final void setFlowControlListener$okhttp(@NotNull FlowControlListener flowControlListener) {
            Intrinsics.checkNotNullParameter((Object)flowControlListener, (String)"<set-?>");
            this.flowControlListener = flowControlListener;
        }

        @NotNull
        public final Builder socket(@NotNull BufferedSocket socket, @NotNull String peerName) throws IOException {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Builder $this$socket_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$socket_u24lambda_u240.setSocket$okhttp(socket);
            $this$socket_u24lambda_u240.setConnectionName$okhttp($this$socket_u24lambda_u240.client ? _UtilJvmKt.okHttpName + ' ' + peerName : "MockWebServer " + peerName);
            return builder;
        }

        @NotNull
        public final Builder listener(@NotNull Listener listener) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder $this$listener_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$listener_u24lambda_u240.listener = listener;
            return builder;
        }

        @NotNull
        public final Builder pushObserver(@NotNull PushObserver pushObserver) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pushObserver, (String)"pushObserver");
            Builder $this$pushObserver_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$pushObserver_u24lambda_u240.pushObserver = pushObserver;
            return builder;
        }

        @NotNull
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            Builder builder;
            Builder $this$pingIntervalMillis_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$pingIntervalMillis_u24lambda_u240.pingIntervalMillis = pingIntervalMillis;
            return builder;
        }

        @NotNull
        public final Builder flowControlListener(@NotNull FlowControlListener flowControlListener) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)flowControlListener, (String)"flowControlListener");
            Builder $this$flowControlListener_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$flowControlListener_u24lambda_u240.flowControlListener = flowControlListener;
            return builder;
        }

        @NotNull
        public final Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Companion;", "", "<init>", "()V", "", "OKHTTP_CLIENT_WINDOW_SIZE", "I", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "DEFAULT_SETTINGS", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "INTERVAL_PING", "DEGRADED_PING", "AWAIT_PING", "DEGRADED_PONG_TIMEOUT_NS", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "", "<init>", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "stream", "", "onStream", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "connection", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "settings", "onSettings", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;)V", "Companion", "okhttp"})
    public static abstract class Listener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            public void onStream(Http2Stream stream) throws IOException {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                stream.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(@NotNull Http2Stream var1) throws IOException;

        public void onSettings(@NotNull Http2Connection connection, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "<init>", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "REFUSE_INCOMING_STREAMS", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$Listener;", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0011\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J5\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010!\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b!\u0010 J\u000f\u0010\"\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\"\u0010\tJ'\u0010&\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b&\u0010'J'\u0010+\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010/\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f2\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b/\u00100J/\u00104\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b4\u00105J-\u00108\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f2\u0006\u00106\u001a\u00020\f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0004\b8\u00109J?\u0010@\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020-H\u0016\u00a2\u0006\u0004\b@\u0010AR\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010B\u001a\u0004\bC\u0010D\u00a8\u0006E"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Reader;", "reader", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Reader;)V", "invoke", "()V", "", "inFinished", "", "streamId", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "source", "length", "data", "(ZILcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;I)V", "associatedStreamId", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Header;", "headerBlock", "headers", "(ZIILjava/util/List;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;", "errorCode", "rstStream", "(ILcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;)V", "clearPrevious", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "settings", "(ZLcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;)V", "applyAndAckSettings", "ackSettings", "ack", "payload1", "payload2", "ping", "(ZII)V", "lastGoodStreamId", "Lcom/smushytaco/nickname_detector/shaded/okio/ByteString;", "debugData", "goAway", "(ILcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;Lcom/smushytaco/nickname_detector/shaded/okio/ByteString;)V", "", "windowSizeIncrement", "windowUpdate", "(IJ)V", "streamDependency", "weight", "exclusive", "priority", "(IIIZ)V", "promisedStreamId", "requestHeaders", "pushPromise", "(IILjava/util/List;)V", "", "origin", "protocol", "host", "port", "maxAge", "alternateService", "(ILjava/lang/String;Lcom/smushytaco/nickname_detector/shaded/okio/ByteString;Ljava/lang/String;IJ)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Reader;", "getReader$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Reader;", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 -UtilCommon.kt\nokhttp3/internal/_UtilCommonKt\n*L\n1#1,1042:1\n63#2:1043\n63#2:1044\n63#2:1045\n63#2:1048\n63#2:1049\n38#2:1050\n63#2:1051\n63#2:1054\n38#2:1055\n63#2:1056\n37#3,2:1046\n37#3,2:1052\n228#4,5:1057\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n678#1:1043\n757#1:1044\n758#1:1045\n792#1:1048\n809#1:1049\n819#1:1050\n845#1:1051\n864#1:1054\n866#1:1055\n871#1:1056\n775#1:1046,2\n846#1:1052,2\n703#1:1057,5\n*E\n"})
    public final class ReaderRunnable
    implements Http2Reader.Handler,
    Function0<Unit> {
        @NotNull
        private final Http2Reader reader;

        public ReaderRunnable(Http2Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @NotNull
        public final Http2Reader getReader$okhttp() {
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                errorException = e;
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                Http2Connection.this.close$okhttp(connectionErrorCode, streamErrorCode, errorException);
                _UtilCommonKt.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, @NotNull BufferedSource source2, int length) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushDataLater$okhttp(streamId, source2, length, inFinished);
                return;
            }
            Http2Stream dataStream = Http2Connection.this.getStream(streamId);
            if (dataStream == null) {
                Http2Connection.this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl$okhttp(length);
                source2.skip(length);
                return;
            }
            dataStream.receiveData(source2, length);
            if (inFinished) {
                dataStream.receiveHeaders(Headers.EMPTY, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void headers(boolean inFinished, int streamId, int associatedStreamId, @NotNull List<Header> headerBlock) {
            void $this$withLock$iv;
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushHeadersLater$okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Stream stream = null;
            Lockable lockable = Http2Connection.this;
            Http2Connection http2Connection = Http2Connection.this;
            boolean $i$f$withLock = false;
            void var9_9 = $this$withLock$iv;
            synchronized (var9_9) {
                boolean bl = false;
                stream = http2Connection.getStream(streamId);
                if (stream == null) {
                    if (http2Connection.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Headers headers = _UtilJvmKt.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection, false, inFinished, headers);
                    http2Connection.setLastGoodStreamId$okhttp(streamId);
                    http2Connection.getStreams$okhttp().put(streamId, newStream);
                    TaskQueue.execute$default(http2Connection.taskRunner.newQueue(), http2Connection.getConnectionName$okhttp() + '[' + streamId + "] onStream", 0L, false, () -> ReaderRunnable.headers$lambda$0$0(http2Connection, newStream), 6, null);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            stream.receiveHeaders(_UtilJvmKt.toHeaders(headerBlock), inFinished);
        }

        @Override
        public void rstStream(int streamId, @NotNull ErrorCode errorCode) {
            block1: {
                Http2Stream rstStream;
                Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
                if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                    Http2Connection.this.pushResetLater$okhttp(streamId, errorCode);
                    return;
                }
                Http2Stream http2Stream = rstStream = Http2Connection.this.removeStream$okhttp(streamId);
                if (http2Stream == null) break block1;
                http2Stream.receiveRstStream(errorCode);
            }
        }

        @Override
        public void settings(boolean clearPrevious, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            TaskQueue.execute$default(Http2Connection.this.writerQueue, Http2Connection.this.getConnectionName$okhttp() + " applyAndAckSettings", 0L, false, () -> ReaderRunnable.settings$lambda$0(this, clearPrevious, settings), 6, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void applyAndAckSettings(boolean clearPrevious, @NotNull Settings settings) {
            void $this$withLock$iv;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            long delta = 0L;
            Http2Stream[] streamsToNotify = null;
            Ref.ObjectRef newPeerSettings = new Ref.ObjectRef();
            Http2Stream[] http2StreamArray = (Http2Stream[])Http2Connection.this.getWriter();
            Http2Connection http2Connection = Http2Connection.this;
            boolean $i$f$withLock = false;
            void var8_10 = $this$withLock$iv;
            synchronized (var8_10) {
                boolean bl = false;
                Lockable $this$withLock$iv2 = http2Connection;
                boolean $i$f$withLock2 = false;
                Lockable lockable = $this$withLock$iv2;
                synchronized (lockable) {
                    Http2Stream[] http2StreamArray2;
                    Settings settings2;
                    boolean bl2 = false;
                    Settings previousPeerSettings = http2Connection.getPeerSettings();
                    Ref.ObjectRef objectRef = newPeerSettings;
                    if (clearPrevious) {
                        settings2 = settings;
                    } else {
                        void $this$applyAndAckSettings_u24lambda_u240_u240_u240;
                        Settings settings3;
                        Settings settings4 = settings3 = new Settings();
                        Ref.ObjectRef objectRef2 = objectRef;
                        boolean bl3 = false;
                        $this$applyAndAckSettings_u24lambda_u240_u240_u240.merge(previousPeerSettings);
                        $this$applyAndAckSettings_u24lambda_u240_u240_u240.merge(settings);
                        objectRef = objectRef2;
                        settings2 = settings3;
                    }
                    objectRef.element = settings2;
                    long peerInitialWindowSize = ((Settings)newPeerSettings.element).getInitialWindowSize();
                    delta = peerInitialWindowSize - (long)previousPeerSettings.getInitialWindowSize();
                    if (delta == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                        http2StreamArray2 = null;
                    } else {
                        Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$okhttp().values();
                        boolean $i$f$toTypedArray = false;
                        Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                        http2StreamArray2 = thisCollection$iv.toArray(new Http2Stream[0]);
                    }
                    streamsToNotify = http2StreamArray2;
                    http2Connection.setPeerSettings((Settings)newPeerSettings.element);
                    TaskQueue.execute$default(http2Connection.settingsListenerQueue, http2Connection.getConnectionName$okhttp() + " onSettings", 0L, false, () -> ReaderRunnable.applyAndAckSettings$lambda$0$0$1(http2Connection, newPeerSettings), 6, null);
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    http2Connection.getWriter().applyAndAckSettings((Settings)newPeerSettings.element);
                }
                catch (IOException e) {
                    http2Connection.failConnection(e);
                }
                Unit unit = Unit.INSTANCE;
            }
            if (streamsToNotify != null) {
                for (Http2Stream stream : streamsToNotify) {
                    Lockable $this$withLock$iv3 = stream;
                    boolean $i$f$withLock3 = false;
                    Lockable lockable = $this$withLock$iv3;
                    synchronized (lockable) {
                        boolean bl = false;
                        stream.addBytesToWriteWindow(delta);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            if (ack) {
                void $this$withLock$iv;
                Lockable lockable = Http2Connection.this;
                Http2Connection http2Connection = Http2Connection.this;
                boolean $i$f$withLock = false;
                void var7_7 = $this$withLock$iv;
                synchronized (var7_7) {
                    Object object;
                    boolean bl = false;
                    switch (payload1) {
                        case 1: {
                            long l = http2Connection.intervalPongsReceived;
                            http2Connection.intervalPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 2: {
                            long l = http2Connection.degradedPongsReceived;
                            http2Connection.degradedPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 3: {
                            long l = http2Connection.awaitPongsReceived;
                            http2Connection.awaitPongsReceived = l + 1L;
                            Lockable $this$notifyAll$iv = http2Connection;
                            boolean $i$f$notifyAll = false;
                            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                            ((Object)$this$notifyAll$iv).notifyAll();
                            object = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            object = Unit.INSTANCE;
                        }
                    }
                    Unit unit = object;
                }
            } else {
                TaskQueue.execute$default(Http2Connection.this.writerQueue, Http2Connection.this.getConnectionName$okhttp() + " ping", 0L, false, () -> ReaderRunnable.ping$lambda$1(Http2Connection.this, payload1, payload2), 6, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void goAway(int lastGoodStreamId, @NotNull ErrorCode errorCode, @NotNull ByteString debugData) {
            void $this$withLock$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)debugData, (String)"debugData");
            if (debugData.size() > 0) {
                // empty if block
            }
            Http2Stream[] streamsCopy = null;
            Http2Stream[] http2StreamArray = (Http2Stream[])Http2Connection.this;
            Http2Connection http2Connection = Http2Connection.this;
            boolean $i$f$withLock = false;
            void var8_9 = $this$withLock$iv;
            synchronized (var8_9) {
                boolean bl = false;
                Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$okhttp().values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                streamsCopy = thisCollection$iv.toArray(new Http2Stream[0]);
                http2Connection.isShutdown = true;
                Unit unit = Unit.INSTANCE;
            }
            for (Http2Stream http2Stream : streamsCopy) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                Http2Connection.this.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                void $this$withLock$iv;
                Lockable lockable = Http2Connection.this;
                Http2Connection http2Connection = Http2Connection.this;
                boolean $i$f$withLock = false;
                void var7_9 = $this$withLock$iv;
                synchronized (var7_9) {
                    boolean bl = false;
                    http2Connection.writeBytesMaximum = http2Connection.getWriteBytesMaximum() + windowSizeIncrement;
                    Lockable $this$notifyAll$iv = http2Connection;
                    boolean $i$f$notifyAll = false;
                    Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)$this$notifyAll$iv).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
            }
            Http2Stream stream = Http2Connection.this.getStream(streamId);
            if (stream != null) {
                Lockable $this$withLock$iv = stream;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl = false;
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, @NotNull List<Header> requestHeaders) {
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            Http2Connection.this.pushRequestLater$okhttp(promisedStreamId, requestHeaders);
        }

        @Override
        public void alternateService(int streamId, @NotNull String origin, @NotNull ByteString protocol, @NotNull String host, int port, long maxAge) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        }

        private static final Unit headers$lambda$0$0(Http2Connection this$0, Http2Stream $newStream) {
            try {
                this$0.getListener$okhttp().onStream($newStream);
            }
            catch (IOException e) {
                Platform.Companion.get().log("Http2Connection.Listener failure for " + this$0.getConnectionName$okhttp(), 4, e);
                boolean $i$f$ignoreIoExceptions = false;
                try {
                    boolean bl = false;
                    $newStream.close(ErrorCode.PROTOCOL_ERROR, e);
                }
                catch (IOException iOException) {
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit settings$lambda$0(ReaderRunnable this$0, boolean $clearPrevious, Settings $settings) {
            this$0.applyAndAckSettings($clearPrevious, $settings);
            return Unit.INSTANCE;
        }

        private static final Unit applyAndAckSettings$lambda$0$0$1(Http2Connection this$0, Ref.ObjectRef $newPeerSettings) {
            this$0.getListener$okhttp().onSettings(this$0, (Settings)$newPeerSettings.element);
            return Unit.INSTANCE;
        }

        private static final Unit ping$lambda$1(Http2Connection this$0, int $payload1, int $payload2) {
            this$0.writePing(true, $payload1, $payload2);
            return Unit.INSTANCE;
        }
    }
}

