/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2;

import com.smushytaco.nickname_detector.shaded.okhttp3.Headers;
import com.smushytaco.nickname_detector.shaded.okhttp3.OkHttpClient;
import com.smushytaco.nickname_detector.shaded.okhttp3.Protocol;
import com.smushytaco.nickname_detector.shaded.okhttp3.Request;
import com.smushytaco.nickname_detector.shaded.okhttp3.Response;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.ExchangeCodec;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.HttpHeaders;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.RealInterceptorChain;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.RequestLine;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.StatusLine;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.ErrorCode;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Header;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Http2Connection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Http2Stream;
import com.smushytaco.nickname_detector.shaded.okio.Sink;
import com.smushytaco.nickname_detector.shaded.okio.Socket;
import com.smushytaco.nickname_detector.shaded.okio.Source;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 <2\u00020\u0001:\u0001<B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b#\u0010$J\u0011\u0010&\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b(\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010,R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010-R\u0018\u0010/\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010;\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006="}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2ExchangeCodec;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;", "client", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;", "carrier", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/RealInterceptorChain;", "chain", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "http2Connection", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/RealInterceptorChain;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "request", "", "contentLength", "Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "createRequestBody", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;J)Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "", "writeRequestHeaders", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)V", "flushRequest", "()V", "finishRequest", "", "expectContinue", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response$Builder;", "readResponseHeaders", "(Z)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response$Builder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "response", "reportedContentLength", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)J", "Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "openResponseBodySource", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "peekTrailers", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "cancel", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;", "getCarrier", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/RealInterceptorChain;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "stream", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Protocol;", "protocol", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Protocol;", "canceled", "Z", "isResponseComplete", "()Z", "Lcom/smushytaco/nickname_detector/shaded/okio/Socket;", "getSocket", "()Lcom/smushytaco/nickname_detector/shaded/okio/Socket;", "socket", "Companion", "okhttp"})
public final class Http2ExchangeCodec
implements ExchangeCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExchangeCodec.Carrier carrier;
    @NotNull
    private final RealInterceptorChain chain;
    @NotNull
    private final Http2Connection http2Connection;
    @Nullable
    private volatile Http2Stream stream;
    @NotNull
    private final Protocol protocol;
    private volatile boolean canceled;
    @NotNull
    private static final String CONNECTION = "connection";
    @NotNull
    private static final String HOST = "host";
    @NotNull
    private static final String KEEP_ALIVE = "keep-alive";
    @NotNull
    private static final String PROXY_CONNECTION = "proxy-connection";
    @NotNull
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    @NotNull
    private static final String TE = "te";
    @NotNull
    private static final String ENCODING = "encoding";
    @NotNull
    private static final String UPGRADE = "upgrade";
    @NotNull
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS;
    @NotNull
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS;

    public Http2ExchangeCodec(@NotNull OkHttpClient client, @NotNull ExchangeCodec.Carrier carrier, @NotNull RealInterceptorChain chain, @NotNull Http2Connection http2Connection) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)http2Connection, (String)"http2Connection");
        this.carrier = carrier;
        this.chain = chain;
        this.http2Connection = http2Connection;
        this.protocol = client.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    @NotNull
    public ExchangeCodec.Carrier getCarrier() {
        return this.carrier;
    }

    @Override
    public boolean isResponseComplete() {
        Http2Stream http2Stream = this.stream;
        return http2Stream != null ? http2Stream.isSourceComplete() : false;
    }

    @Override
    @NotNull
    public Socket getSocket() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream;
    }

    @Override
    @NotNull
    public Sink createRequestBody(@NotNull Request request, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSink();
    }

    @Override
    public void writeRequestHeaders(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<Header> requestHeaders = Companion.http2HeadersList(request);
        this.stream = this.http2Connection.newStream(requestHeaders, hasRequestBody);
        if (this.canceled) {
            Http2Stream http2Stream = this.stream;
            Intrinsics.checkNotNull((Object)http2Stream);
            http2Stream.closeLater(ErrorCode.CANCEL);
            throw new IOException("Canceled");
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.readTimeout().timeout(this.chain.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        Http2Stream http2Stream2 = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream2);
        http2Stream2.writeTimeout().timeout(this.chain.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() {
        this.http2Connection.flush();
    }

    @Override
    public void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.getSink().close();
    }

    @Override
    @Nullable
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        Http2Stream http2Stream = this.stream;
        if (http2Stream == null) {
            throw new IOException("stream wasn't created");
        }
        Http2Stream stream = http2Stream;
        Headers headers = stream.takeHeaders(expectContinue);
        Response.Builder responseBuilder = Companion.readHttp2HeadersList(headers, this.protocol);
        return expectContinue && responseBuilder.getCode$okhttp() == 100 ? null : responseBuilder;
    }

    @Override
    public long reportedContentLength(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return !HttpHeaders.promisesBody(response) ? 0L : _UtilJvmKt.headersContentLength(response);
    }

    @Override
    @NotNull
    public Source openResponseBodySource(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSource();
    }

    @Override
    @Nullable
    public Headers peekTrailers() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.peekTrailers();
    }

    @Override
    public void cancel() {
        block0: {
            this.canceled = true;
            Http2Stream http2Stream = this.stream;
            if (http2Stream == null) break block0;
            http2Stream.closeLater(ErrorCode.CANCEL);
        }
    }

    static {
        String[] stringArray = new String[]{CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, ":method", ":path", ":scheme", ":authority"};
        HTTP_2_SKIPPED_REQUEST_HEADERS = _UtilJvmKt.immutableListOf(stringArray);
        stringArray = new String[]{CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE};
        HTTP_2_SKIPPED_RESPONSE_HEADERS = _UtilJvmKt.immutableListOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0013R\u0014\u0010\u0019\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0013R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2ExchangeCodec$Companion;", "", "<init>", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "request", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Header;", "http2HeadersList", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)Ljava/util/List;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "headerBlock", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Protocol;", "protocol", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response$Builder;", "readHttp2HeadersList", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Protocol;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response$Builder;", "", "CONNECTION", "Ljava/lang/String;", "HOST", "KEEP_ALIVE", "PROXY_CONNECTION", "TRANSFER_ENCODING", "TE", "ENCODING", "UPGRADE", "HTTP_2_SKIPPED_REQUEST_HEADERS", "Ljava/util/List;", "HTTP_2_SKIPPED_RESPONSE_HEADERS", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Header> http2HeadersList(@NotNull Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Headers headers = request.headers();
            ArrayList<Header> result = new ArrayList<Header>(headers.size() + 4);
            result.add(new Header(Header.TARGET_METHOD, request.method()));
            result.add(new Header(Header.TARGET_PATH, RequestLine.INSTANCE.requestPath(request.url())));
            String host = request.header("Host");
            if (host != null) {
                result.add(new Header(Header.TARGET_AUTHORITY, host));
            }
            result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                String name;
                String string = headers.name(i);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"toLowerCase(...)");
                if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name) && (!Intrinsics.areEqual((Object)name, (Object)Http2ExchangeCodec.TE) || !Intrinsics.areEqual((Object)headers.value(i), (Object)"trailers"))) continue;
                result.add(new Header(name, headers.value(i)));
            }
            return result;
        }

        @NotNull
        public final Response.Builder readHttp2HeadersList(@NotNull Headers headerBlock, @NotNull Protocol protocol) {
            Intrinsics.checkNotNullParameter((Object)headerBlock, (String)"headerBlock");
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            StatusLine statusLine = null;
            Headers.Builder headersBuilder = new Headers.Builder();
            int n = headerBlock.size();
            for (int i = 0; i < n; ++i) {
                String name = headerBlock.name(i);
                String value = headerBlock.value(i);
                if (Intrinsics.areEqual((Object)name, (Object)":status")) {
                    statusLine = StatusLine.Companion.parse("HTTP/1.1 " + value);
                    continue;
                }
                if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
                headersBuilder.addLenient$okhttp(name, value);
            }
            if (statusLine == null) {
                throw new ProtocolException("Expected ':status' header not present");
            }
            return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

