/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2;

import com.smushytaco.nickname_detector.shaded.okhttp3.Headers;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.ErrorCode;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Header;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Http2Connection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.StreamResetException;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.flowcontrol.WindowCounter;
import com.smushytaco.nickname_detector.shaded.okio.AsyncTimeout;
import com.smushytaco.nickname_detector.shaded.okio.Buffer;
import com.smushytaco.nickname_detector.shaded.okio.BufferedSource;
import com.smushytaco.nickname_detector.shaded.okio.Sink;
import com.smushytaco.nickname_detector.shaded.okio.Socket;
import com.smushytaco.nickname_detector.shaded.okio.Source;
import com.smushytaco.nickname_detector.shaded.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 u2\u00020\u00012\u00020\u0002:\u0004vwuxB3\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J+\u0010\u0018\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\n\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010\u001fJ\u001f\u0010%\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010#\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010*\u001a\u00020\u00172\u0006\u0010)\u001a\u00020!\u00a2\u0006\u0004\b*\u0010+J!\u0010,\u001a\u00020\u00072\u0006\u0010)\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0004\b,\u0010-J\u001d\u00101\u001a\u00020\u00172\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u0003\u00a2\u0006\u0004\b1\u00102J\u001d\u00103\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b3\u00104J\u0015\u00105\u001a\u00020\u00172\u0006\u0010)\u001a\u00020!\u00a2\u0006\u0004\b5\u0010+J\u000f\u00106\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b6\u00107J\u000f\u00109\u001a\u00020\u0017H\u0000\u00a2\u0006\u0004\b8\u0010(J\u0015\u0010<\u001a\u00020\u00172\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\b<\u0010=J\u000f\u0010?\u001a\u00020\u0017H\u0000\u00a2\u0006\u0004\b>\u0010(J\u000f\u0010A\u001a\u00020\u0017H\u0000\u00a2\u0006\u0004\b@\u0010(R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010B\u001a\u0004\bC\u0010DR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010E\u001a\u0004\bF\u0010GR\u0017\u0010I\u001a\u00020H8\u0006\u00a2\u0006\f\n\u0004\bI\u0010J\u001a\u0004\bK\u0010LR*\u0010N\u001a\u00020:2\u0006\u0010M\u001a\u00020:8\u0006@@X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010=R*\u0010S\u001a\u00020:2\u0006\u0010M\u001a\u00020:8\u0006@@X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010O\u001a\u0004\bT\u0010Q\"\u0004\bU\u0010=R\u001a\u0010W\u001a\b\u0012\u0004\u0012\u00020\n0V8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bW\u0010XR\u0016\u0010Y\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u001e\u0010/\u001a\u00060[R\u00020\u00008\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u0010\\\u001a\u0004\b]\u0010^R\u001e\u0010`\u001a\u00060_R\u00020\u00008\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b`\u0010a\u001a\u0004\bb\u0010cR\u001e\u0010\u001e\u001a\u00060dR\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010e\u001a\u0004\bf\u0010gR\u001e\u0010 \u001a\u00060dR\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b \u0010e\u001a\u0004\bh\u0010gR$\u0010)\u001a\u0004\u0018\u00010!8@@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010i\u001a\u0004\bj\u0010k\"\u0004\bl\u0010+R$\u0010$\u001a\u0004\u0018\u00010#8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010m\u001a\u0004\bn\u0010o\"\u0004\bp\u0010qR\u0011\u0010r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\br\u00107R\u0011\u0010s\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bs\u00107R\u0011\u0010t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bt\u00107\u00a8\u0006y"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Lockable;", "Lcom/smushytaco/nickname_detector/shaded/okio/Socket;", "", "id", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "connection", "", "outFinished", "inFinished", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "headers", "<init>", "(ILcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;ZZLcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;)V", "callerIsIdle", "takeHeaders", "(Z)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "peekTrailers", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Header;", "responseHeaders", "flushHeaders", "", "writeHeaders", "(Ljava/util/List;ZZ)V", "trailers", "enqueueTrailers", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;)V", "Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "readTimeout", "()Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "writeTimeout", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;", "rstStatusCode", "Ljava/io/IOException;", "errorException", "close", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;Ljava/io/IOException;)V", "cancel", "()V", "errorCode", "closeLater", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;)V", "closeInternal", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;Ljava/io/IOException;)Z", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "source", "length", "receiveData", "(Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;I)V", "receiveHeaders", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;Z)V", "receiveRstStream", "doReadTimeout", "()Z", "cancelStreamIfNecessary$okhttp", "cancelStreamIfNecessary", "", "delta", "addBytesToWriteWindow", "(J)V", "checkOutNotClosed$okhttp", "checkOutNotClosed", "waitForIo$okhttp", "waitForIo", "I", "getId", "()I", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "getConnection", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Connection;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/flowcontrol/WindowCounter;", "readBytes", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/flowcontrol/WindowCounter;", "getReadBytes", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/flowcontrol/WindowCounter;", "value", "writeBytesTotal", "J", "getWriteBytesTotal", "()J", "setWriteBytesTotal$okhttp", "writeBytesMaximum", "getWriteBytesMaximum", "setWriteBytesMaximum$okhttp", "Ljava/util/ArrayDeque;", "headersQueue", "Ljava/util/ArrayDeque;", "hasResponseHeaders", "Z", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSource;", "getSource", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSink;", "sink", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSink;", "getSink", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSink;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$StreamTimeout;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$StreamTimeout;", "getReadTimeout$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$StreamTimeout;", "getWriteTimeout$okhttp", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;", "getErrorCode$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;", "setErrorCode$okhttp", "Ljava/io/IOException;", "getErrorException$okhttp", "()Ljava/io/IOException;", "setErrorException$okhttp", "(Ljava/io/IOException;)V", "isOpen", "isLocallyInitiated", "isSourceComplete", "Companion", "FramingSource", "FramingSink", "StreamTimeout", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,743:1\n1#2:744\n63#3:745\n63#3:746\n63#3:747\n63#3:748\n63#3:749\n49#3,4:750\n63#3:754\n38#3:755\n63#3:756\n63#3:757\n49#3,4:758\n63#3:762\n38#3:763\n49#3,4:764\n49#3,4:768\n63#3:772\n38#3:773\n63#3:774\n38#3:775\n49#3,4:776\n63#3:780\n38#3:781\n34#3:782\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream\n*L\n89#1:745\n114#1:746\n136#1:747\n149#1:748\n175#1:749\n200#1:750,4\n203#1:754\n207#1:755\n214#1:756\n227#1:757\n272#1:758,4\n274#1:762\n280#1:763\n294#1:764,4\n304#1:768,4\n307#1:772\n321#1:773\n329#1:774\n332#1:775\n543#1:776,4\n547#1:780\n693#1:781\n713#1:782\n*E\n"})
public final class Http2Stream
implements Lockable,
Socket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final Http2Connection connection;
    @NotNull
    private final WindowCounter readBytes;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final ArrayDeque<Headers> headersQueue;
    private boolean hasResponseHeaders;
    @NotNull
    private final FramingSource source;
    @NotNull
    private final FramingSink sink;
    @NotNull
    private final StreamTimeout readTimeout;
    @NotNull
    private final StreamTimeout writeTimeout;
    @Nullable
    private ErrorCode errorCode;
    @Nullable
    private IOException errorException;
    public static final long EMIT_BUFFER_SIZE = 16384L;

    public Http2Stream(int id, @NotNull Http2Connection connection, boolean outFinished, boolean inFinished, @Nullable Headers headers) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.id = id;
        this.connection = connection;
        this.readBytes = new WindowCounter(this.id);
        this.writeBytesMaximum = this.connection.getPeerSettings().getInitialWindowSize();
        this.headersQueue = new ArrayDeque();
        this.source = new FramingSource(this.connection.getOkHttpSettings().getInitialWindowSize(), inFinished);
        this.sink = new FramingSink(this, outFinished);
        this.readTimeout = new StreamTimeout();
        this.writeTimeout = new StreamTimeout();
        if (headers != null) {
            if (!(!this.isLocallyInitiated())) {
                boolean $i$a$-check-Http2Stream$32 = false;
                String $i$a$-check-Http2Stream$32 = "locally-initiated streams shouldn't have headers yet";
                throw new IllegalStateException($i$a$-check-Http2Stream$32.toString());
            }
            ((Collection)this.headersQueue).add(headers);
        } else if (!this.isLocallyInitiated()) {
            boolean bl = false;
            String string = "remotely-initiated streams should have headers";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final Http2Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public final WindowCounter getReadBytes() {
        return this.readBytes;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final void setWriteBytesTotal$okhttp(long l) {
        this.writeBytesTotal = l;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final void setWriteBytesMaximum$okhttp(long l) {
        this.writeBytesMaximum = l;
    }

    @Override
    @NotNull
    public FramingSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public FramingSink getSink() {
        return this.sink;
    }

    @NotNull
    public final StreamTimeout getReadTimeout$okhttp() {
        return this.readTimeout;
    }

    @NotNull
    public final StreamTimeout getWriteTimeout$okhttp() {
        return this.writeTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ErrorCode getErrorCode$okhttp() {
        ErrorCode errorCode;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            errorCode = this.errorCode;
        }
        return errorCode;
    }

    public final void setErrorCode$okhttp(@Nullable ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    @Nullable
    public final IOException getErrorException$okhttp() {
        return this.errorException;
    }

    public final void setErrorException$okhttp(@Nullable IOException iOException) {
        this.errorException = iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (this.getErrorCode$okhttp() == null) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                if (!this.getSource().getFinished$okhttp() && !this.getSource().getClosed$okhttp() || !this.getSink().getFinished() && !this.getSink().getClosed() || !this.hasResponseHeaders) break block6;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public final boolean isLocallyInitiated() {
        boolean streamIsClient = (this.id & 1) == 1;
        return this.connection.getClient$okhttp() == streamIsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSourceComplete() {
        boolean bl;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl2 = false;
            bl = this.getSource().getFinished$okhttp() && this.getSource().getReadBuffer().exhausted();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Headers takeHeaders(boolean callerIsIdle) throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            Throwable throwable;
            block11: {
                boolean bl = false;
                while (this.headersQueue.isEmpty() && this.getErrorCode$okhttp() == null) {
                    boolean doReadTimeout;
                    boolean bl2 = doReadTimeout = callerIsIdle || this.doReadTimeout();
                    if (doReadTimeout) {
                        this.readTimeout.enter();
                    }
                    try {
                        this.waitForIo$okhttp();
                    }
                    finally {
                        if (!doReadTimeout) continue;
                        this.readTimeout.exitAndThrowIfTimedOut();
                    }
                }
                if (!(!((Collection)this.headersQueue).isEmpty())) break block11;
                Headers headers = this.headersQueue.removeFirst();
                Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"removeFirst(...)");
                Headers headers2 = headers;
                return headers2;
            }
            IOException iOException = this.errorException;
            if (iOException != null) {
                throwable = iOException;
            } else {
                ErrorCode errorCode = this.getErrorCode$okhttp();
                Intrinsics.checkNotNull((Object)((Object)errorCode));
                throwable = new StreamResetException(errorCode);
            }
            throw throwable;
        }
    }

    public static /* synthetic */ Headers takeHeaders$default(Http2Stream http2Stream, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return http2Stream.takeHeaders(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Headers peekTrailers() throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block8: {
                boolean bl = false;
                if (!this.getSource().getFinished$okhttp() || !this.getSource().getReceiveBuffer().exhausted() || !this.getSource().getReadBuffer().exhausted()) break block8;
                Headers headers = this.getSource().getTrailers();
                if (headers == null) {
                    headers = Headers.EMPTY;
                }
                Headers headers2 = headers;
                return headers2;
            }
            if (this.getErrorCode$okhttp() != null) {
                Throwable throwable;
                IOException iOException = this.errorException;
                if (iOException != null) {
                    throwable = iOException;
                } else {
                    ErrorCode errorCode = this.getErrorCode$okhttp();
                    Intrinsics.checkNotNull((Object)((Object)errorCode));
                    throwable = new StreamResetException(errorCode);
                }
                throw throwable;
            }
            Headers headers = null;
            return headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeHeaders(@NotNull List<Header> responseHeaders, boolean outFinished, boolean flushHeaders) throws IOException {
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean flushHeaders2 = false;
        flushHeaders2 = flushHeaders;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this.hasResponseHeaders = true;
            if (outFinished) {
                this.getSink().setFinished(true);
                Lockable $this$notifyAll$iv = this;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (!flushHeaders2) {
            $this$withLock$iv = this;
            $i$f$withLock = false;
            lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl = false;
                flushHeaders2 = this.connection.getWriteBytesTotal() >= this.connection.getWriteBytesMaximum();
                Unit unit = Unit.INSTANCE;
            }
        }
        this.connection.writeHeaders$okhttp(this.id, outFinished, responseHeaders);
        if (flushHeaders2) {
            this.connection.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueTrailers(@NotNull Headers trailers) {
        Intrinsics.checkNotNullParameter((Object)trailers, (String)"trailers");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (!(!this.getSink().getFinished())) {
                boolean $i$a$-check-Http2Stream$enqueueTrailers$1$22 = false;
                String $i$a$-check-Http2Stream$enqueueTrailers$1$22 = "already finished";
                throw new IllegalStateException($i$a$-check-Http2Stream$enqueueTrailers$1$22.toString());
            }
            if (!(trailers.size() != 0)) {
                boolean bl2 = false;
                String string = "trailers.size() == 0";
                throw new IllegalArgumentException(string.toString());
            }
            this.getSink().setTrailers(trailers);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Timeout readTimeout() {
        return this.readTimeout;
    }

    @NotNull
    public final Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public final void close(@NotNull ErrorCode rstStatusCode, @Nullable IOException errorException) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)rstStatusCode), (String)"rstStatusCode");
        if (!this.closeInternal(rstStatusCode, errorException)) {
            return;
        }
        this.connection.writeSynReset$okhttp(this.id, rstStatusCode);
    }

    @Override
    public void cancel() {
        this.closeLater(ErrorCode.CANCEL);
    }

    public final void closeLater(@NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater$okhttp(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean closeInternal(ErrorCode errorCode, IOException errorException) {
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block7: {
                block6: {
                    boolean bl = false;
                    if (this.getErrorCode$okhttp() == null) break block6;
                    boolean bl2 = false;
                    return bl2;
                }
                this.errorCode = errorCode;
                this.errorException = errorException;
                Lockable $this$notifyAll$iv = this;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
                if (!this.getSource().getFinished$okhttp() || !this.getSink().getFinished()) break block7;
                boolean bl = false;
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        this.connection.removeStream$okhttp(this.id);
        return true;
    }

    public final void receiveData(@NotNull BufferedSource source2, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        this.getSource().receive$okhttp(source2, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveHeaders(@NotNull Headers headers, boolean inFinished) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean open = false;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (!this.hasResponseHeaders || headers.get(":status") != null || headers.get(":method") != null) {
                this.hasResponseHeaders = true;
                ((Collection)this.headersQueue).add(headers);
            } else {
                this.getSource().setTrailers(headers);
            }
            if (inFinished) {
                this.getSource().setFinished$okhttp(true);
            }
            open = this.isOpen();
            Lockable $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$notifyAll$iv).notifyAll();
            Unit unit = Unit.INSTANCE;
        }
        if (!open) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveRstStream(@NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.getErrorCode$okhttp() == null) {
                this.errorCode = errorCode;
                Lockable $this$notifyAll$iv = this;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean doReadTimeout() {
        return !this.connection.getClient$okhttp() || this.getSink().getClosed() || this.getSink().getFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelStreamIfNecessary$okhttp() throws IOException {
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean open = false;
        boolean cancel = false;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            cancel = !this.getSource().getFinished$okhttp() && this.getSource().getClosed$okhttp() && (this.getSink().getFinished() || this.getSink().getClosed());
            open = this.isOpen();
            Unit unit = Unit.INSTANCE;
        }
        if (cancel) {
            this.close(ErrorCode.CANCEL, null);
        } else if (!open) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    public final void addBytesToWriteWindow(long delta) {
        this.writeBytesMaximum += delta;
        if (delta > 0L) {
            Lockable $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$notifyAll$iv).notifyAll();
        }
    }

    public final void checkOutNotClosed$okhttp() throws IOException {
        if (this.getSink().getClosed()) {
            throw new IOException("stream closed");
        }
        if (this.getSink().getFinished()) {
            throw new IOException("stream finished");
        }
        if (this.getErrorCode$okhttp() != null) {
            Throwable throwable;
            IOException iOException = this.errorException;
            if (iOException != null) {
                throwable = iOException;
            } else {
                ErrorCode errorCode = this.getErrorCode$okhttp();
                Intrinsics.checkNotNull((Object)((Object)errorCode));
                throwable = new StreamResetException(errorCode);
            }
            throw throwable;
        }
    }

    public final void waitForIo$okhttp() throws InterruptedIOException {
        try {
            Lockable $this$wait$iv = this;
            boolean $i$f$wait = false;
            Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$wait$iv).wait();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$Companion;", "", "<init>", "()V", "", "EMIT_BUFFER_SIZE", "J", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0011R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u0016\u001a\u0004\b$\u0010\u0018\"\u0004\b%\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSink;", "Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "", "finished", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;Z)V", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "source", "", "byteCount", "", "write", "(Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;J)V", "outFinishedOnLastFrame", "emitFrame", "(Z)V", "flush", "()V", "Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "timeout", "()Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "close", "Z", "getFinished", "()Z", "setFinished", "sendBuffer", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "trailers", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "getTrailers", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "setTrailers", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;)V", "closed", "getClosed", "setClosed", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,743:1\n49#2,4:744\n63#2:748\n49#2,4:749\n63#2:753\n49#2,4:754\n63#2:758\n63#2:759\n38#2:760\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSink\n*L\n582#1:744,4\n598#1:748\n628#1:749,4\n630#1:753\n644#1:754,4\n647#1:758\n676#1:759\n678#1:760\n*E\n"})
    public final class FramingSink
    implements Sink {
        private boolean finished;
        @NotNull
        private final Buffer sendBuffer;
        @Nullable
        private Headers trailers;
        private boolean closed;
        final /* synthetic */ Http2Stream this$0;

        public FramingSink(Http2Stream this$0, boolean finished) {
            this.this$0 = this$0;
            this.finished = finished;
            this.sendBuffer = new Buffer();
        }

        public /* synthetic */ FramingSink(Http2Stream http2Stream, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(http2Stream, bl);
        }

        public final boolean getFinished() {
            return this.finished;
        }

        public final void setFinished(boolean bl) {
            this.finished = bl;
        }

        @Nullable
        public final Headers getTrailers() {
            return this.trailers;
        }

        public final void setTrailers(@Nullable Headers headers) {
            this.trailers = headers;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        public final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Lockable $this$assertLockNotHeld$iv = this.this$0;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            this.sendBuffer.write(source2, byteCount);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void emitFrame(boolean outFinishedOnLastFrame) throws IOException {
            void $this$withLock$iv;
            long toWrite = 0L;
            boolean outFinished = false;
            Lockable lockable = this.this$0;
            Http2Stream http2Stream = this.this$0;
            boolean $i$f$withLock = false;
            void var6_8 = $this$withLock$iv;
            synchronized (var6_8) {
                boolean bl = false;
                http2Stream.getWriteTimeout$okhttp().enter();
                try {
                    while (http2Stream.getWriteBytesTotal() >= http2Stream.getWriteBytesMaximum() && !this.finished && !this.closed && http2Stream.getErrorCode$okhttp() == null) {
                        http2Stream.waitForIo$okhttp();
                    }
                }
                finally {
                    http2Stream.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
                }
                http2Stream.checkOutNotClosed$okhttp();
                toWrite = Math.min(http2Stream.getWriteBytesMaximum() - http2Stream.getWriteBytesTotal(), this.sendBuffer.size());
                http2Stream.setWriteBytesTotal$okhttp(http2Stream.getWriteBytesTotal() + toWrite);
                outFinished = outFinishedOnLastFrame && toWrite == this.sendBuffer.size();
                Unit unit = Unit.INSTANCE;
            }
            this.this$0.getWriteTimeout$okhttp().enter();
            try {
                this.this$0.getConnection().writeData(this.this$0.getId(), outFinished, this.sendBuffer, toWrite);
            }
            finally {
                this.this$0.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void flush() throws IOException {
            void $this$withLock$iv;
            Lockable $this$assertLockNotHeld$iv = this.this$0;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            $this$assertLockNotHeld$iv = this.this$0;
            Http2Stream http2Stream = this.this$0;
            boolean $i$f$withLock = false;
            void var4_5 = $this$withLock$iv;
            synchronized (var4_5) {
                boolean bl = false;
                http2Stream.checkOutNotClosed$okhttp();
                Unit unit = Unit.INSTANCE;
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                this.this$0.getConnection().flush();
            }
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.this$0.getWriteTimeout$okhttp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void close() throws IOException {
            void $this$withLock$iv;
            Lockable $this$assertLockNotHeld$iv = this.this$0;
            boolean $i$f$assertLockNotHeld22 = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            boolean outFinished = false;
            Lockable $i$f$assertLockNotHeld22 = this.this$0;
            Http2Stream http2Stream = this.this$0;
            boolean $i$f$withLock = false;
            void var5_11 = $this$withLock$iv;
            synchronized (var5_11) {
                boolean bl = false;
                if (this.closed) {
                    return;
                }
                outFinished = http2Stream.getErrorCode$okhttp() == null;
                Unit unit = Unit.INSTANCE;
            }
            if (!this.this$0.getSink().finished) {
                boolean hasData = this.sendBuffer.size() > 0L;
                boolean hasTrailers = this.trailers != null;
                if (hasTrailers) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(false);
                    }
                    Http2Connection http2Connection = this.this$0.getConnection();
                    int n = this.this$0.getId();
                    Headers headers = this.trailers;
                    Intrinsics.checkNotNull((Object)headers);
                    http2Connection.writeHeaders$okhttp(n, outFinished, _UtilJvmKt.toHeaderList(headers));
                } else if (hasData) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else if (outFinished) {
                    this.this$0.getConnection().writeData(this.this$0.getId(), true, null, 0L);
                }
            }
            Lockable hasData = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            $i$f$withLock = false;
            var5_11 = $this$withLock$iv;
            synchronized (var5_11) {
                boolean bl = false;
                this.closed = true;
                Lockable $this$notifyAll$iv = http2Stream2;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
                Unit unit = Unit.INSTANCE;
            }
            this.this$0.getConnection().flush();
            this.this$0.cancelStreamIfNecessary$okhttp();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\"\u0010\u0005\u001a\u00020\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b$\u0010!\u001a\u0004\b%\u0010#R$\u0010'\u001a\u0004\u0018\u00010&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\"\u0010-\u001a\u00020\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010\u001b\u001a\u0004\b.\u0010\u001d\"\u0004\b/\u0010\u001f\u00a8\u00060"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$FramingSource;", "Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "", "maxByteCount", "", "finished", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;JZ)V", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "sink", "byteCount", "read", "(Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;J)J", "", "updateConnectionFlowControl", "(J)V", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;", "source", "receive$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSource;J)V", "receive", "Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "timeout", "()Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "close", "()V", "J", "Z", "getFinished$okhttp", "()Z", "setFinished$okhttp", "(Z)V", "receiveBuffer", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "getReceiveBuffer", "()Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "readBuffer", "getReadBuffer", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "trailers", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "getTrailers", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "setTrailers", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;)V", "closed", "getClosed$okhttp", "setClosed$okhttp", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,743:1\n1#2:744\n63#3:745\n49#3,4:746\n49#3,4:750\n63#3:754\n63#3:755\n38#3:756\n63#3:757\n38#3:758\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n*L\n390#1:745\n453#1:746,4\n467#1:750,4\n474#1:754\n500#1:755\n507#1:756\n528#1:757\n532#1:758\n*E\n"})
    public final class FramingSource
    implements Source {
        private final long maxByteCount;
        private boolean finished;
        @NotNull
        private final Buffer receiveBuffer;
        @NotNull
        private final Buffer readBuffer;
        @Nullable
        private Headers trailers;
        private boolean closed;

        public FramingSource(long maxByteCount, boolean finished) {
            this.maxByteCount = maxByteCount;
            this.finished = finished;
            this.receiveBuffer = new Buffer();
            this.readBuffer = new Buffer();
        }

        public final boolean getFinished$okhttp() {
            return this.finished;
        }

        public final void setFinished$okhttp(boolean bl) {
            this.finished = bl;
        }

        @NotNull
        public final Buffer getReceiveBuffer() {
            return this.receiveBuffer;
        }

        @NotNull
        public final Buffer getReadBuffer() {
            return this.readBuffer;
        }

        @Nullable
        public final Headers getTrailers() {
            return this.trailers;
        }

        public final void setTrailers(@Nullable Headers headers) {
            this.trailers = headers;
        }

        public final boolean getClosed$okhttp() {
            return this.closed;
        }

        public final void setClosed$okhttp(boolean bl) {
            this.closed = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long read(@NotNull Buffer sink2, long byteCount) throws IOException {
            IOException errorExceptionToDeliver;
            long readBytesDelivered;
            boolean tryAgain;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean bl = false;
                String string = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException(string.toString());
            }
            do {
                void $this$withLock$iv;
                tryAgain = false;
                readBytesDelivered = 0L;
                readBytesDelivered = -1L;
                errorExceptionToDeliver = null;
                Lockable lockable = Http2Stream.this;
                Http2Stream http2Stream = Http2Stream.this;
                boolean $i$f$withLock = false;
                void var10_10 = $this$withLock$iv;
                synchronized (var10_10) {
                    boolean bl = false;
                    boolean doReadTimeout = http2Stream.doReadTimeout();
                    if (doReadTimeout) {
                        http2Stream.getReadTimeout$okhttp().enter();
                    }
                    try {
                        IOException iOException;
                        if (http2Stream.getErrorCode$okhttp() != null && !this.finished && (iOException = http2Stream.getErrorException$okhttp()) == null) {
                            ErrorCode errorCode = http2Stream.getErrorCode$okhttp();
                            Intrinsics.checkNotNull((Object)((Object)errorCode));
                            iOException = errorExceptionToDeliver = (IOException)new StreamResetException(errorCode);
                        }
                        if (this.closed) {
                            throw new IOException("stream closed");
                        }
                        if (this.readBuffer.size() > 0L) {
                            readBytesDelivered = this.readBuffer.read(sink2, Math.min(byteCount, this.readBuffer.size()));
                            WindowCounter.update$default(http2Stream.getReadBytes(), readBytesDelivered, 0L, 2, null);
                            long unacknowledgedBytesRead = http2Stream.getReadBytes().getUnacknowledged();
                            if (errorExceptionToDeliver == null && unacknowledgedBytesRead >= (long)(http2Stream.getConnection().getOkHttpSettings().getInitialWindowSize() / 2)) {
                                http2Stream.getConnection().writeWindowUpdateLater$okhttp(http2Stream.getId(), unacknowledgedBytesRead);
                                WindowCounter.update$default(http2Stream.getReadBytes(), 0L, unacknowledgedBytesRead, 1, null);
                            }
                        } else if (!this.finished && errorExceptionToDeliver == null) {
                            http2Stream.waitForIo$okhttp();
                            tryAgain = true;
                        }
                    }
                    finally {
                        if (doReadTimeout) {
                            http2Stream.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Http2Stream.this.getConnection().getFlowControlListener$okhttp().receivingStreamWindowChanged(Http2Stream.this.getId(), Http2Stream.this.getReadBytes(), this.readBuffer.size());
            } while (tryAgain);
            if (readBytesDelivered != -1L) {
                return readBytesDelivered;
            }
            if (errorExceptionToDeliver != null) {
                throw (Throwable)errorExceptionToDeliver;
            }
            return -1L;
        }

        private final void updateConnectionFlowControl(long read) {
            Lockable $this$assertLockNotHeld$iv = Http2Stream.this;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            Http2Stream.this.getConnection().updateConnectionFlowControl$okhttp(read);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void receive$okhttp(@NotNull BufferedSource source2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Lockable $this$assertLockNotHeld$iv = Http2Stream.this;
            boolean $i$f$assertLockNotHeld = false;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
            }
            long remainingByteCount = 0L;
            remainingByteCount = byteCount;
            while (remainingByteCount > 0L) {
                void $this$withLock$iv;
                boolean finished = false;
                boolean flowControlError = false;
                Lockable $this$withLock$iv2 = Http2Stream.this;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv2;
                synchronized (lockable) {
                    boolean bl = false;
                    finished = this.finished;
                    flowControlError = remainingByteCount + this.readBuffer.size() > this.maxByteCount;
                    Unit unit = Unit.INSTANCE;
                }
                if (flowControlError) {
                    source2.skip(remainingByteCount);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (finished) {
                    source2.skip(remainingByteCount);
                    return;
                }
                long read = source2.read(this.receiveBuffer, remainingByteCount);
                if (read == -1L) {
                    throw new EOFException();
                }
                remainingByteCount -= read;
                lockable = Http2Stream.this;
                Http2Stream http2Stream = Http2Stream.this;
                boolean $i$f$withLock2 = false;
                void var12_15 = $this$withLock$iv;
                synchronized (var12_15) {
                    boolean bl = false;
                    if (this.closed) {
                        this.receiveBuffer.clear();
                    } else {
                        boolean wasEmpty = this.readBuffer.size() == 0L;
                        this.readBuffer.writeAll(this.receiveBuffer);
                        if (wasEmpty) {
                            Lockable $this$notifyAll$iv = http2Stream;
                            boolean $i$f$notifyAll = false;
                            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                            ((Object)$this$notifyAll$iv).notifyAll();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            this.updateConnectionFlowControl(byteCount);
            Http2Stream.this.getConnection().getFlowControlListener$okhttp().receivingStreamWindowChanged(Http2Stream.this.getId(), Http2Stream.this.getReadBytes(), this.readBuffer.size());
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return Http2Stream.this.getReadTimeout$okhttp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void close() throws IOException {
            void $this$withLock$iv;
            long bytesDiscarded = 0L;
            Lockable lockable = Http2Stream.this;
            Http2Stream http2Stream = Http2Stream.this;
            boolean $i$f$withLock = false;
            void var4_5 = $this$withLock$iv;
            synchronized (var4_5) {
                boolean bl = false;
                this.closed = true;
                bytesDiscarded = this.readBuffer.size();
                this.readBuffer.clear();
                Lockable $this$notifyAll$iv = http2Stream;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$notifyAll$iv).notifyAll();
                Unit unit = Unit.INSTANCE;
            }
            if (bytesDiscarded > 0L) {
                this.updateConnectionFlowControl(bytesDiscarded);
            }
            Http2Stream.this.cancelStreamIfNecessary$okhttp();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream$StreamTimeout;", "Lcom/smushytaco/nickname_detector/shaded/okio/AsyncTimeout;", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Stream;)V", "", "timedOut", "()V", "Ljava/io/IOException;", "cause", "newTimeoutException", "(Ljava/io/IOException;)Ljava/io/IOException;", "exitAndThrowIfTimedOut", "okhttp"})
    public final class StreamTimeout
    extends AsyncTimeout {
        @Override
        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
            Http2Stream.this.getConnection().sendDegradedPingLater$okhttp();
        }

        @Override
        @NotNull
        protected IOException newTimeoutException(@Nullable IOException cause) {
            SocketTimeoutException socketTimeoutException;
            SocketTimeoutException $this$newTimeoutException_u24lambda_u240 = socketTimeoutException = new SocketTimeoutException("timeout");
            boolean bl = false;
            if (cause != null) {
                $this$newTimeoutException_u24lambda_u240.initCause(cause);
            }
            return socketTimeoutException;
        }

        public final void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }
}

