/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.idn;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal.idn.IdnaMappingTableKt;
import com.smushytaco.nickname_detector.shaded.okio.BufferedSink;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0018\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/idn/IdnaMappingTable;", "", "", "sections", "ranges", "mappings", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "", "codePoint", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;", "sink", "", "map", "(ILcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;)Z", "findSectionsIndex", "(I)I", "position", "limit", "findRangesOffset", "(III)I", "Ljava/lang/String;", "getSections", "()Ljava/lang/String;", "getRanges", "getMappings", "okhttp"})
@SourceDebugExtension(value={"SMAP\nIdnaMappingTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTable\n+ 2 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTableKt\n*L\n1#1,286:1\n272#2,13:287\n272#2,13:300\n*S KotlinDebug\n*F\n+ 1 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTable\n*L\n209#1:287,13\n237#1:300,13\n*E\n"})
public final class IdnaMappingTable {
    @NotNull
    private final String sections;
    @NotNull
    private final String ranges;
    @NotNull
    private final String mappings;

    public IdnaMappingTable(@NotNull String sections, @NotNull String ranges, @NotNull String mappings) {
        Intrinsics.checkNotNullParameter((Object)sections, (String)"sections");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
        this.sections = sections;
        this.ranges = ranges;
        this.mappings = mappings;
    }

    @NotNull
    public final String getSections() {
        return this.sections;
    }

    @NotNull
    public final String getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getMappings() {
        return this.mappings;
    }

    public final boolean map(int codePoint, @NotNull BufferedSink sink2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        int sectionsIndex = this.findSectionsIndex(codePoint);
        int rangesPosition = IdnaMappingTableKt.read14BitInt(this.sections, sectionsIndex + 2);
        int rangesLimit = sectionsIndex + 4 < this.sections.length() ? IdnaMappingTableKt.read14BitInt(this.sections, sectionsIndex + 6) : this.ranges.length() / 4;
        int rangesIndex = this.findRangesOffset(codePoint, rangesPosition, rangesLimit);
        char b1 = this.ranges.charAt(rangesIndex + 1);
        boolean bl = '\u0000' <= b1 ? b1 < '@' : false;
        if (bl) {
            int beginIndex = IdnaMappingTableKt.read14BitInt(this.ranges, rangesIndex + 2);
            object = sink2.writeUtf8(this.mappings, beginIndex, beginIndex + b1);
        } else {
            boolean bl2 = '@' <= b1 ? b1 < 'P' : false;
            if (bl2) {
                char b2 = this.ranges.charAt(rangesIndex + 2);
                char b3 = this.ranges.charAt(rangesIndex + 3);
                int codepointDelta = (b1 & 0xF) << 14 | b2 << 7 | b3;
                object = sink2.writeUtf8CodePoint(codePoint - codepointDelta);
            } else {
                boolean bl3 = 'P' <= b1 ? b1 < '`' : false;
                if (bl3) {
                    char b2 = this.ranges.charAt(rangesIndex + 2);
                    char b3 = this.ranges.charAt(rangesIndex + 3);
                    int codepointDelta = (b1 & 0xF) << 14 | b2 << 7 | b3;
                    object = sink2.writeUtf8CodePoint(codePoint + codepointDelta);
                } else if (b1 == 'w') {
                    object = Unit.INSTANCE;
                } else if (b1 == 'x') {
                    object = sink2.writeUtf8CodePoint(codePoint);
                } else {
                    if (b1 == 'y') {
                        sink2.writeUtf8CodePoint(codePoint);
                        return false;
                    }
                    if (b1 == 'z') {
                        object = sink2.writeByte(this.ranges.charAt(rangesIndex + 2));
                    } else if (b1 == '{') {
                        object = sink2.writeByte(this.ranges.charAt(rangesIndex + 2) | 0x80);
                    } else if (b1 == '|') {
                        sink2.writeByte(this.ranges.charAt(rangesIndex + 2));
                        object = sink2.writeByte(this.ranges.charAt(rangesIndex + 3));
                    } else if (b1 == '}') {
                        sink2.writeByte(this.ranges.charAt(rangesIndex + 2) | 0x80);
                        object = sink2.writeByte(this.ranges.charAt(rangesIndex + 3));
                    } else if (b1 == '~') {
                        sink2.writeByte(this.ranges.charAt(rangesIndex + 2));
                        object = sink2.writeByte(this.ranges.charAt(rangesIndex + 3) | 0x80);
                    } else if (b1 == '\u007f') {
                        sink2.writeByte(this.ranges.charAt(rangesIndex + 2) | 0x80);
                        object = sink2.writeByte(this.ranges.charAt(rangesIndex + 3) | 0x80);
                    } else {
                        throw new IllegalStateException(("unexpected rangesIndex for " + codePoint).toString());
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int findSectionsIndex(int codePoint) {
        void v0;
        block3: {
            void limit$iv;
            void position$iv;
            int target = (codePoint & 0x1FFF80) >> 7;
            boolean bl = false;
            int n = this.sections.length() / 4;
            boolean $i$f$binarySearch = false;
            void low$iv = position$iv;
            void high$iv = limit$iv - true;
            while (low$iv <= high$iv) {
                void mid$iv;
                void index = mid$iv = (low$iv + high$iv) / 2;
                boolean bl2 = false;
                void entryIndex = index * 4;
                int b0b1 = IdnaMappingTableKt.read14BitInt(this.sections, (int)entryIndex);
                int compareResult$iv = Intrinsics.compare((int)target, (int)b0b1);
                if (compareResult$iv < 0) {
                    high$iv = mid$iv - true;
                    continue;
                }
                if (compareResult$iv > 0) {
                    low$iv = mid$iv + true;
                    continue;
                }
                v0 = mid$iv;
                break block3;
            }
            v0 = -low$iv - true;
        }
        void offset = v0;
        return (int)(offset >= 0 ? offset * 4 : (-offset - 2) * 4);
    }

    /*
     * WARNING - void declaration
     */
    private final int findRangesOffset(int codePoint, int position, int limit) {
        void v0;
        block3: {
            void limit$iv;
            void position$iv;
            int target = codePoint & 0x7F;
            int n = position;
            int n2 = limit;
            boolean $i$f$binarySearch = false;
            void low$iv = position$iv;
            void high$iv = limit$iv - true;
            while (low$iv <= high$iv) {
                void mid$iv;
                void index = mid$iv = (low$iv + high$iv) / 2;
                boolean bl = false;
                void entryIndex = index * 4;
                char b0 = this.ranges.charAt((int)entryIndex);
                int compareResult$iv = Intrinsics.compare((int)target, (int)b0);
                if (compareResult$iv < 0) {
                    high$iv = mid$iv - true;
                    continue;
                }
                if (compareResult$iv > 0) {
                    low$iv = mid$iv + true;
                    continue;
                }
                v0 = mid$iv;
                break block3;
            }
            v0 = -low$iv - true;
        }
        void offset = v0;
        return (int)(offset >= 0 ? offset * 4 : (-offset - 2) * 4);
    }
}

