/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.ws;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilCommonKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.ws.MessageDeflater;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.ws.WebSocketProtocol;
import com.smushytaco.nickname_detector.shaded.okio.Buffer;
import com.smushytaco.nickname_detector.shaded.okio.BufferedSink;
import com.smushytaco.nickname_detector.shaded.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u001d\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001d\u0010\u0018J\u000f\u0010\u001e\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010$\u001a\u0004\b%\u0010&R\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010 R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010*R\u0016\u0010,\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010 R\u0018\u0010.\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00101\u001a\u0004\u0018\u0001008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00104\u001a\u0004\u0018\u0001038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00066"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/ws/WebSocketWriter;", "Ljava/io/Closeable;", "", "isClient", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;", "sink", "Ljava/util/Random;", "random", "perMessageDeflate", "noContextTakeover", "", "minimumDeflateSize", "<init>", "(ZLcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;Ljava/util/Random;ZZJ)V", "Lcom/smushytaco/nickname_detector/shaded/okio/ByteString;", "payload", "", "writePing", "(Lcom/smushytaco/nickname_detector/shaded/okio/ByteString;)V", "writePong", "", "code", "reason", "writeClose", "(ILcom/smushytaco/nickname_detector/shaded/okio/ByteString;)V", "opcode", "writeControlFrame", "formatOpcode", "data", "writeMessageFrame", "close", "()V", "Z", "Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;", "getSink", "()Lcom/smushytaco/nickname_detector/shaded/okio/BufferedSink;", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "J", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "messageBuffer", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "sinkBuffer", "writerClosed", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/ws/MessageDeflater;", "messageDeflater", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/ws/MessageDeflater;", "", "maskKey", "[B", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer$UnsafeCursor;", "maskCursor", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer$UnsafeCursor;", "okhttp"})
@SourceDebugExtension(value={"SMAP\nWebSocketWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketWriter.kt\nokhttp3/internal/ws/WebSocketWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class WebSocketWriter
implements Closeable {
    private final boolean isClient;
    @NotNull
    private final BufferedSink sink;
    @NotNull
    private final Random random;
    private final boolean perMessageDeflate;
    private final boolean noContextTakeover;
    private final long minimumDeflateSize;
    @NotNull
    private final Buffer messageBuffer;
    @NotNull
    private final Buffer sinkBuffer;
    private boolean writerClosed;
    @Nullable
    private MessageDeflater messageDeflater;
    @Nullable
    private final byte[] maskKey;
    @Nullable
    private final Buffer.UnsafeCursor maskCursor;

    public WebSocketWriter(boolean isClient, @NotNull BufferedSink sink2, @NotNull Random random, boolean perMessageDeflate, boolean noContextTakeover, long minimumDeflateSize) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.isClient = isClient;
        this.sink = sink2;
        this.random = random;
        this.perMessageDeflate = perMessageDeflate;
        this.noContextTakeover = noContextTakeover;
        this.minimumDeflateSize = minimumDeflateSize;
        this.messageBuffer = new Buffer();
        this.sinkBuffer = this.sink.getBuffer();
        this.maskKey = this.isClient ? new byte[4] : null;
        this.maskCursor = this.isClient ? new Buffer.UnsafeCursor() : null;
    }

    @NotNull
    public final BufferedSink getSink() {
        return this.sink;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public final void writePing(@NotNull ByteString payload) throws IOException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.writeControlFrame(9, payload);
    }

    public final void writePong(@NotNull ByteString payload) throws IOException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.writeControlFrame(10, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeClose(int code, @Nullable ByteString reason) throws IOException {
        ByteString payload = ByteString.EMPTY;
        if (code != 0 || reason != null) {
            if (code != 0) {
                WebSocketProtocol.INSTANCE.validateCloseCode(code);
            }
            Buffer $this$writeClose_u24lambda_u240 = new Buffer();
            boolean bl = false;
            $this$writeClose_u24lambda_u240.writeShort(code);
            if (reason != null) {
                $this$writeClose_u24lambda_u240.write(reason);
            }
            payload = $this$writeClose_u24lambda_u240.readByteString();
        }
        try {
            this.writeControlFrame(8, payload);
        }
        finally {
            this.writerClosed = true;
        }
    }

    private final void writeControlFrame(int opcode, ByteString payload) throws IOException {
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int length = payload.size();
        if (!((long)length <= 125L)) {
            boolean $i$a$-require-WebSocketWriter$writeControlFrame$22 = false;
            String $i$a$-require-WebSocketWriter$writeControlFrame$22 = "Payload size must be less than or equal to 125";
            throw new IllegalArgumentException($i$a$-require-WebSocketWriter$writeControlFrame$22.toString());
        }
        int b0 = 0x80 | opcode;
        this.sinkBuffer.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sinkBuffer.writeByte(b1 |= 0x80);
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (length > 0) {
                long payloadStart = this.sinkBuffer.size();
                this.sinkBuffer.write(payload);
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.sinkBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(payloadStart);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.writeByte(b1);
            this.sinkBuffer.write(payload);
        }
        this.sink.flush();
    }

    public final void writeMessageFrame(int formatOpcode, @NotNull ByteString data) throws IOException {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        this.messageBuffer.write(data);
        int b0 = formatOpcode | 0x80;
        if (this.perMessageDeflate && (long)data.size() >= this.minimumDeflateSize) {
            MessageDeflater messageDeflater = this.messageDeflater;
            if (messageDeflater == null) {
                MessageDeflater messageDeflater2;
                MessageDeflater it = messageDeflater2 = new MessageDeflater(this.noContextTakeover);
                boolean bl = false;
                this.messageDeflater = it;
                messageDeflater = messageDeflater2;
            }
            MessageDeflater messageDeflater3 = messageDeflater;
            messageDeflater3.deflate(this.messageBuffer);
            b0 |= 0x40;
        }
        long dataSize = this.messageBuffer.size();
        this.sinkBuffer.writeByte(b0);
        int b1 = 0;
        if (this.isClient) {
            b1 |= 0x80;
        }
        if (dataSize <= 125L) {
            buffer = this.sinkBuffer.writeByte(b1 |= (int)dataSize);
        } else if (dataSize <= 65535L) {
            this.sinkBuffer.writeByte(b1 |= 0x7E);
            buffer = this.sinkBuffer.writeShort((int)dataSize);
        } else {
            this.sinkBuffer.writeByte(b1 |= 0x7F);
            buffer = this.sinkBuffer.writeLong(dataSize);
        }
        if (this.isClient) {
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (dataSize > 0L) {
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.messageBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(0L);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        this.sinkBuffer.write(this.messageBuffer, dataSize);
        this.sink.flush();
    }

    @Override
    public void close() {
        MessageDeflater messageDeflater = this.messageDeflater;
        if (messageDeflater != null) {
            _UtilCommonKt.closeQuietly(messageDeflater);
        }
        _UtilCommonKt.closeQuietly(this.sink);
    }
}

