/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okio;

import com.smushytaco.nickname_detector.shaded.okio.-SegmentedByteString;
import com.smushytaco.nickname_detector.shaded.okio.Buffer;
import com.smushytaco.nickname_detector.shaded.okio.InflaterSource;
import com.smushytaco.nickname_detector.shaded.okio.RealBufferedSource;
import com.smushytaco.nickname_detector.shaded.okio.Segment;
import com.smushytaco.nickname_detector.shaded.okio.Source;
import com.smushytaco.nickname_detector.shaded.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\rJ'\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\u0002\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\"R\u0018\u0010%\u001a\u00060#j\u0002`$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0018\u0010,\u001a\u00060*j\u0002`+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/smushytaco/nickname_detector/shaded/okio/GzipSource;", "Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "source", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okio/Source;)V", "Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;", "sink", "", "byteCount", "read", "(Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;J)J", "", "consumeHeader", "()V", "consumeTrailer", "Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "timeout", "()Lcom/smushytaco/nickname_detector/shaded/okio/Timeout;", "close", "buffer", "offset", "updateCrc", "(Lcom/smushytaco/nickname_detector/shaded/okio/Buffer;JJ)V", "", "name", "", "expected", "actual", "checkEqual", "(Ljava/lang/String;II)V", "", "section", "B", "Lcom/smushytaco/nickname_detector/shaded/okio/RealBufferedSource;", "Lcom/smushytaco/nickname_detector/shaded/okio/RealBufferedSource;", "Ljava/util/zip/Inflater;", "Lcom/smushytaco/nickname_detector/shaded/okio/Inflater;", "inflater", "Ljava/util/zip/Inflater;", "Lcom/smushytaco/nickname_detector/shaded/okio/InflaterSource;", "inflaterSource", "Lcom/smushytaco/nickname_detector/shaded/okio/InflaterSource;", "Ljava/util/zip/CRC32;", "Lcom/smushytaco/nickname_detector/shaded/okio/internal/CRC32;", "crc", "Ljava/util/zip/CRC32;", "com.smushytaco.nickname_detector.shaded.okio"})
@SourceDebugExtension(value={"SMAP\nGzipSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipSource.kt\nokio/GzipSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RealBufferedSource.kt\nokio/RealBufferedSource\n+ 4 GzipSource.kt\nokio/-GzipSourceExtensions\n+ 5 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,222:1\n1#2:223\n63#3:224\n63#3:226\n63#3:228\n63#3:229\n63#3:230\n63#3:232\n63#3:234\n204#4:225\n204#4:227\n204#4:231\n204#4:233\n88#5:235\n*S KotlinDebug\n*F\n+ 1 GzipSource.kt\nokio/GzipSource\n*L\n103#1:224\n105#1:226\n117#1:228\n118#1:229\n120#1:230\n131#1:232\n142#1:234\n104#1:225\n115#1:227\n128#1:231\n139#1:233\n185#1:235\n*E\n"})
public final class GzipSource
implements Source {
    private byte section;
    @NotNull
    private final RealBufferedSource source;
    @NotNull
    private final Inflater inflater;
    @NotNull
    private final InflaterSource inflaterSource;
    @NotNull
    private final CRC32 crc;

    public GzipSource(@NotNull Source source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.source = new RealBufferedSource(source2);
        this.inflater = new Inflater(true);
        this.inflaterSource = new InflaterSource(this.source, this.inflater);
        this.crc = new CRC32();
    }

    @Override
    public long read(@NotNull Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (this.section == 0) {
            this.consumeHeader();
            this.section = 1;
        }
        if (this.section == 1) {
            long offset = sink2.size();
            long result = this.inflaterSource.read(sink2, byteCount);
            if (result != -1L) {
                this.updateCrc(sink2, offset, result);
                return result;
            }
            this.section = (byte)2;
        }
        if (this.section == 2) {
            this.consumeTrailer();
            this.section = (byte)3;
            if (!this.source.exhausted()) {
                throw new IOException("gzip finished without exhausting source");
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final void consumeHeader() throws IOException {
        boolean $i$f$getBuffer;
        void $this$getBit$iv;
        byte $i$f$getBuffer2;
        void $this$getBit$iv2;
        boolean fhcrc;
        byte flags;
        this.source.require(10L);
        RealBufferedSource this_$iv = this.source;
        byte $i$f$getBuffer3 = 0;
        $i$f$getBuffer3 = flags = this_$iv.bufferField.getByte(3L);
        int bit$iv = 1;
        boolean $i$f$getBit = false;
        boolean bl = fhcrc = ($this$getBit$iv2 >> bit$iv & 1) == 1;
        if (fhcrc) {
            RealBufferedSource this_$iv2 = this.source;
            $i$f$getBuffer2 = 0;
            this.updateCrc(this_$iv2.bufferField, 0L, 10L);
        }
        short id1id2 = this.source.readShort();
        this.checkEqual("ID1ID2", 8075, id1id2);
        this.source.skip(8L);
        $i$f$getBuffer2 = flags;
        int bit$iv2 = 2;
        boolean $i$f$getBit2 = false;
        if (($this$getBit$iv >> bit$iv2 & 1) == 1) {
            this.source.require(2L);
            if (fhcrc) {
                RealBufferedSource this_$iv3 = this.source;
                boolean $i$f$getBuffer4 = false;
                this.updateCrc(this_$iv3.bufferField, 0L, 2L);
            }
            RealBufferedSource this_$iv4 = this.source;
            $i$f$getBuffer = false;
            long xlen = this_$iv4.bufferField.readShortLe() & 0xFFFF;
            this.source.require(xlen);
            if (fhcrc) {
                this_$iv4 = this.source;
                $i$f$getBuffer = false;
                this.updateCrc(this_$iv4.bufferField, 0L, xlen);
            }
            this.source.skip(xlen);
        }
        byte xlen = flags;
        bit$iv2 = 3;
        $i$f$getBit2 = false;
        if (($this$getBit$iv >> bit$iv2 & 1) == 1) {
            long index = this.source.indexOf((byte)0);
            if (index == -1L) {
                throw new EOFException();
            }
            if (fhcrc) {
                RealBufferedSource this_$iv5 = this.source;
                $i$f$getBuffer = false;
                this.updateCrc(this_$iv5.bufferField, 0L, index + 1L);
            }
            this.source.skip(index + 1L);
        }
        byte index = flags;
        bit$iv2 = 4;
        $i$f$getBit = false;
        if (($this$getBit$iv >> bit$iv2 & 1) == 1) {
            long index2 = this.source.indexOf((byte)0);
            if (index2 == -1L) {
                throw new EOFException();
            }
            if (fhcrc) {
                RealBufferedSource this_$iv6 = this.source;
                $i$f$getBuffer = false;
                this.updateCrc(this_$iv6.bufferField, 0L, index2 + 1L);
            }
            this.source.skip(index2 + 1L);
        }
        if (fhcrc) {
            this.checkEqual("FHCRC", this.source.readShortLe(), (short)this.crc.getValue());
            this.crc.reset();
        }
    }

    private final void consumeTrailer() throws IOException {
        this.checkEqual("CRC", this.source.readIntLe(), (int)this.crc.getValue());
        this.checkEqual("ISIZE", this.source.readIntLe(), (int)this.inflater.getBytesWritten());
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        this.inflaterSource.close();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCrc(Buffer buffer, long offset, long byteCount) {
        long offset2;
        long byteCount2 = byteCount;
        Segment segment = buffer.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        for (offset2 = offset; offset2 >= (long)(s.limit - s.pos); offset2 -= (long)(s.limit - s.pos)) {
            Intrinsics.checkNotNull((Object)s.next);
        }
        while (byteCount2 > 0L) {
            void a$iv;
            int pos = (int)((long)s.pos + offset2);
            int n = s.limit - pos;
            long b$iv = byteCount2;
            boolean $i$f$minOf = false;
            int toUpdate = (int)Math.min((long)a$iv, b$iv);
            this.crc.update(s.data, pos, toUpdate);
            byteCount2 -= (long)toUpdate;
            offset2 = 0L;
            Intrinsics.checkNotNull((Object)s.next);
        }
    }

    private final void checkEqual(String name, int expected, int actual) {
        if (actual != expected) {
            throw new IOException(name + ": actual 0x" + StringsKt.padStart((String)-SegmentedByteString.toHexString(actual), (int)8, (char)'0') + " != expected 0x" + StringsKt.padStart((String)-SegmentedByteString.toHexString(expected), (int)8, (char)'0'));
        }
    }
}

