/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okio;

import com.smushytaco.nickname_detector.shaded.okio.CipherSink;
import com.smushytaco.nickname_detector.shaded.okio.CipherSource;
import com.smushytaco.nickname_detector.shaded.okio.FileSystem;
import com.smushytaco.nickname_detector.shaded.okio.HashingSink;
import com.smushytaco.nickname_detector.shaded.okio.HashingSource;
import com.smushytaco.nickname_detector.shaded.okio.InputStreamSource;
import com.smushytaco.nickname_detector.shaded.okio.Okio;
import com.smushytaco.nickname_detector.shaded.okio.OutputStreamSink;
import com.smushytaco.nickname_detector.shaded.okio.Pipe;
import com.smushytaco.nickname_detector.shaded.okio.Sink;
import com.smushytaco.nickname_detector.shaded.okio.Socket;
import com.smushytaco.nickname_detector.shaded.okio.Source;
import com.smushytaco.nickname_detector.shaded.okio.Timeout;
import com.smushytaco.nickname_detector.shaded.okio.internal.DefaultSocket;
import com.smushytaco.nickname_detector.shaded.okio.internal.PipeSocket;
import com.smushytaco.nickname_detector.shaded.okio.internal.ResourceFileSystem;
import com.smushytaco.nickname_detector.shaded.okio.internal.SocketAsyncTimeout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=5, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\t\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\n\u001a\u0013\u0010\u000e\u001a\u00020\u000b*\u00020\bH\u0007\u00a2\u0006\u0004\b\f\u0010\r\u001a\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001d\u0010\u0002\u001a\u00020\u0001*\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0017\u001a\u0011\u0010\u0018\u001a\u00020\u0001*\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0014\u00a2\u0006\u0004\b\u0006\u0010\u001a\u001a%\u0010\u0002\u001a\u00020\u0001*\u00020\u001b2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u0011\"\u00020\u001c\u00a2\u0006\u0004\b\u0002\u0010\u001e\u001a%\u0010\u0006\u001a\u00020\u0005*\u00020\u001b2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u0011\"\u00020\u001c\u00a2\u0006\u0004\b\u0006\u0010\u001f\u001a\u0019\u0010#\u001a\u00020\"*\u00020\u00012\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$\u001a\u0019\u0010&\u001a\u00020%*\u00020\u00052\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b&\u0010'\u001a\u0019\u0010+\u001a\u00020**\u00020\u00012\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b+\u0010,\u001a\u0019\u0010.\u001a\u00020-*\u00020\u00052\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b.\u0010/\u001a\u0019\u0010+\u001a\u00020**\u00020\u00012\u0006\u00101\u001a\u000200\u00a2\u0006\u0004\b+\u00102\u001a\u0019\u0010.\u001a\u00020-*\u00020\u00052\u0006\u00101\u001a\u000200\u00a2\u0006\u0004\b.\u00103\u001a\u0011\u00106\u001a\u000205*\u000204\u00a2\u0006\u0004\b6\u00107\u00a8\u00068"}, d2={"Ljava/io/OutputStream;", "Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "sink", "(Ljava/io/OutputStream;)Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "Ljava/io/InputStream;", "Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "source", "(Ljava/io/InputStream;)Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "Ljava/net/Socket;", "(Ljava/net/Socket;)Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "(Ljava/net/Socket;)Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "Lcom/smushytaco/nickname_detector/shaded/okio/Socket;", "socket", "(Ljava/net/Socket;)Lcom/smushytaco/nickname_detector/shaded/okio/Socket;", "asOkioSocket", "", "maxBufferSize", "", "inMemorySocketPair", "(J)[Lcom/smushytaco/nickname_detector/shaded/okio/Socket;", "Ljava/io/File;", "", "append", "(Ljava/io/File;Z)Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "appendingSink", "(Ljava/io/File;)Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "(Ljava/io/File;)Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "Ljava/nio/file/Path;", "Ljava/nio/file/OpenOption;", "options", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lcom/smushytaco/nickname_detector/shaded/okio/Sink;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lcom/smushytaco/nickname_detector/shaded/okio/Source;", "Ljavax/crypto/Cipher;", "cipher", "Lcom/smushytaco/nickname_detector/shaded/okio/CipherSink;", "cipherSink", "(Lcom/smushytaco/nickname_detector/shaded/okio/Sink;Ljavax/crypto/Cipher;)Lcom/smushytaco/nickname_detector/shaded/okio/CipherSink;", "Lcom/smushytaco/nickname_detector/shaded/okio/CipherSource;", "cipherSource", "(Lcom/smushytaco/nickname_detector/shaded/okio/Source;Ljavax/crypto/Cipher;)Lcom/smushytaco/nickname_detector/shaded/okio/CipherSource;", "Ljavax/crypto/Mac;", "mac", "Lcom/smushytaco/nickname_detector/shaded/okio/HashingSink;", "hashingSink", "(Lcom/smushytaco/nickname_detector/shaded/okio/Sink;Ljavax/crypto/Mac;)Lcom/smushytaco/nickname_detector/shaded/okio/HashingSink;", "Lcom/smushytaco/nickname_detector/shaded/okio/HashingSource;", "hashingSource", "(Lcom/smushytaco/nickname_detector/shaded/okio/Source;Ljavax/crypto/Mac;)Lcom/smushytaco/nickname_detector/shaded/okio/HashingSource;", "Ljava/security/MessageDigest;", "digest", "(Lcom/smushytaco/nickname_detector/shaded/okio/Sink;Ljava/security/MessageDigest;)Lcom/smushytaco/nickname_detector/shaded/okio/HashingSink;", "(Lcom/smushytaco/nickname_detector/shaded/okio/Source;Ljava/security/MessageDigest;)Lcom/smushytaco/nickname_detector/shaded/okio/HashingSource;", "Ljava/lang/ClassLoader;", "Lcom/smushytaco/nickname_detector/shaded/okio/FileSystem;", "asResourceFileSystem", "(Ljava/lang/ClassLoader;)Lcom/smushytaco/nickname_detector/shaded/okio/FileSystem;", "com.smushytaco.nickname_detector.shaded.okio"}, xs="com/smushytaco/nickname_detector/shaded/okio/Okio")
final class Okio__JvmOkioKt {
    @NotNull
    public static final Sink sink(@NotNull OutputStream $this$sink) {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        return new OutputStreamSink($this$sink, new Timeout());
    }

    @NotNull
    public static final Source source(@NotNull InputStream $this$source) {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        return new InputStreamSource($this$source, new Timeout());
    }

    @NotNull
    public static final Sink sink(@NotNull java.net.Socket $this$sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        SocketAsyncTimeout timeout2 = new SocketAsyncTimeout($this$sink);
        OutputStream outputStream2 = $this$sink.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"getOutputStream(...)");
        OutputStreamSink sink2 = new OutputStreamSink(outputStream2, timeout2);
        return timeout2.sink(sink2);
    }

    @NotNull
    public static final Source source(@NotNull java.net.Socket $this$source) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        SocketAsyncTimeout timeout2 = new SocketAsyncTimeout($this$source);
        InputStream inputStream2 = $this$source.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        InputStreamSource source2 = new InputStreamSource(inputStream2, timeout2);
        return timeout2.source(source2);
    }

    @JvmName(name="socket")
    @NotNull
    public static final Socket socket(@NotNull java.net.Socket $this$asOkioSocket) {
        Intrinsics.checkNotNullParameter((Object)$this$asOkioSocket, (String)"<this>");
        return new DefaultSocket($this$asOkioSocket);
    }

    @NotNull
    public static final Socket[] inMemorySocketPair(long maxBufferSize) {
        Pipe ab = new Pipe(maxBufferSize);
        Pipe ba = new Pipe(maxBufferSize);
        Socket[] socketArray = new Socket[]{new PipeSocket(ab, ba), new PipeSocket(ba, ab)};
        return socketArray;
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $this$sink, boolean append) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        return Okio.sink(new FileOutputStream($this$sink, append));
    }

    public static /* synthetic */ Sink sink$default(File file, boolean bl, int n, Object object) throws FileNotFoundException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return Okio.sink(file, bl);
    }

    @NotNull
    public static final Sink appendingSink(@NotNull File $this$appendingSink) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$appendingSink, (String)"<this>");
        return Okio.sink(new FileOutputStream($this$appendingSink, true));
    }

    @NotNull
    public static final Source source(@NotNull File $this$source) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        return new InputStreamSource(new FileInputStream($this$source), Timeout.NONE);
    }

    @NotNull
    public static final Sink sink(@NotNull Path $this$sink, OpenOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        OutputStream outputStream2 = Files.newOutputStream($this$sink, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
        return Okio.sink(outputStream2);
    }

    @NotNull
    public static final Source source(@NotNull Path $this$source, OpenOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        InputStream inputStream2 = Files.newInputStream($this$source, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
        return Okio.source(inputStream2);
    }

    @NotNull
    public static final CipherSink cipherSink(@NotNull Sink $this$cipherSink, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter((Object)$this$cipherSink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        return new CipherSink(Okio.buffer($this$cipherSink), cipher);
    }

    @NotNull
    public static final CipherSource cipherSource(@NotNull Source $this$cipherSource, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter((Object)$this$cipherSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        return new CipherSource(Okio.buffer($this$cipherSource), cipher);
    }

    @NotNull
    public static final HashingSink hashingSink(@NotNull Sink $this$hashingSink, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        return new HashingSink($this$hashingSink, mac);
    }

    @NotNull
    public static final HashingSource hashingSource(@NotNull Source $this$hashingSource, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        return new HashingSource($this$hashingSource, mac);
    }

    @NotNull
    public static final HashingSink hashingSink(@NotNull Sink $this$hashingSink, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        return new HashingSink($this$hashingSink, digest);
    }

    @NotNull
    public static final HashingSource hashingSource(@NotNull Source $this$hashingSource, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        return new HashingSource($this$hashingSource, digest);
    }

    @NotNull
    public static final FileSystem asResourceFileSystem(@NotNull ClassLoader $this$asResourceFileSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$asResourceFileSystem, (String)"<this>");
        return new ResourceFileSystem($this$asResourceFileSystem, true, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $this$sink) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        return Okio.sink$default($this$sink, false, 1, null);
    }
}

