/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.mojang_api_parser;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u00138\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/smushytaco/nickname_detector/mojang_api_parser/UUIDSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/util/UUID;", "<init>", "()V", "", "uuidString", "stringToUUID", "(Ljava/lang/String;)Ljava/util/UUID;", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/util/UUID;", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Ljava/util/UUID;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "nickname-detector"})
public final class UUIDSerializer
implements KSerializer<UUID> {
    @NotNull
    public static final UUIDSerializer INSTANCE = new UUIDSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"UUID", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private UUIDSerializer() {
    }

    @NotNull
    public final UUID stringToUUID(@NotNull String uuidString) {
        Intrinsics.checkNotNullParameter(uuidString, "uuidString");
        StringBuilder stringBuilder = new StringBuilder();
        String string = StringsKt.replace$default(uuidString, "-", "", false, 4, null);
        int n = ((CharSequence)string).length();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.charAt(i));
            switch (i) {
                case 7: 
                case 11: 
                case 15: 
                case 19: {
                    stringBuilder.append('-');
                }
            }
        }
        UUID uUID = UUID.fromString(stringBuilder.toString());
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        return uUID;
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public UUID deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        return this.stringToUUID(decoder.decodeString());
    }

    public void serialize(@NotNull Encoder encoder, @NotNull UUID value) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        encoder.encodeString(StringsKt.replace$default(string, "-", "", false, 4, null));
    }
}

