/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3;

import com.smushytaco.nickname_detector.shaded.okhttp3.Interceptor;
import com.smushytaco.nickname_detector.shaded.okhttp3.Request;
import com.smushytaco.nickname_detector.shaded.okhttp3.Response;
import com.smushytaco.nickname_detector.shaded.okhttp3.ResponseBody;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001cB\u001b\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u00108\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/CompressionInterceptor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/CompressionInterceptor$DecompressionAlgorithm;", "algorithms", "<init>", "([Lcom/smushytaco/nickname_detector/shaded/okhttp3/CompressionInterceptor$DecompressionAlgorithm;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor$Chain;", "chain", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "intercept", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor$Chain;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "response", "decompress$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "decompress", "", "encoding", "lookupDecompressor$okhttp", "(Ljava/lang/String;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/CompressionInterceptor$DecompressionAlgorithm;", "lookupDecompressor", "[Lcom/smushytaco/nickname_detector/shaded/okhttp3/CompressionInterceptor$DecompressionAlgorithm;", "getAlgorithms", "()[Lcom/smushytaco/nickname_detector/shaded/okhttp3/CompressionInterceptor$DecompressionAlgorithm;", "acceptEncoding", "Ljava/lang/String;", "getAcceptEncoding$okhttp", "()Ljava/lang/String;", "DecompressionAlgorithm", "okhttp"})
@SourceDebugExtension(value={"SMAP\nCompressionInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressionInterceptor.kt\nokhttp3/CompressionInterceptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,96:1\n11561#2:97\n11896#2,3:98\n*S KotlinDebug\n*F\n+ 1 CompressionInterceptor.kt\nokhttp3/CompressionInterceptor\n*L\n39#1:97\n39#1:98,3\n*E\n"})
public class CompressionInterceptor
implements Interceptor {
    @NotNull
    private final DecompressionAlgorithm[] algorithms;
    @NotNull
    private final String acceptEncoding;

    /*
     * WARNING - void declaration
     */
    public CompressionInterceptor(DecompressionAlgorithm ... algorithms) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(algorithms, "algorithms");
        DecompressionAlgorithm[] decompressionAlgorithmArray = this.algorithms = algorithms;
        CompressionInterceptor compressionInterceptor = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEncoding());
        }
        compressionInterceptor.acceptEncoding = CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final DecompressionAlgorithm[] getAlgorithms() {
        return this.algorithms;
    }

    @NotNull
    public final String getAcceptEncoding$okhttp() {
        return this.acceptEncoding;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter(chain, "chain");
        if (!(this.algorithms.length == 0) && chain.request().header("Accept-Encoding") == null) {
            Request request = chain.request().newBuilder().header("Accept-Encoding", this.acceptEncoding).build();
            Response response2 = chain.proceed(request);
            response = this.decompress$okhttp(response2);
        } else {
            response = chain.proceed(chain.request());
        }
        return response;
    }

    @NotNull
    public final Response decompress$okhttp(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        if (!HttpHeaders.promisesBody(response)) {
            return response;
        }
        ResponseBody body = response.body();
        String string = Response.header$default(response, "Content-Encoding", null, 2, null);
        if (string == null) {
            return response;
        }
        String encoding = string;
        DecompressionAlgorithm decompressionAlgorithm = this.lookupDecompressor$okhttp(encoding);
        if (decompressionAlgorithm == null) {
            return response;
        }
        DecompressionAlgorithm algorithm = decompressionAlgorithm;
        BufferedSource decompressedSource = Okio.buffer(algorithm.decompress(body.source()));
        return response.newBuilder().removeHeader("Content-Encoding").removeHeader("Content-Length").body(ResponseBody.Companion.create(decompressedSource, body.contentType(), -1L)).build();
    }

    @Nullable
    public final DecompressionAlgorithm lookupDecompressor$okhttp(@NotNull String encoding) {
        DecompressionAlgorithm decompressionAlgorithm;
        block1: {
            Intrinsics.checkNotNullParameter(encoding, "encoding");
            DecompressionAlgorithm[] decompressionAlgorithmArray = this.algorithms;
            int n = decompressionAlgorithmArray.length;
            for (int i = 0; i < n; ++i) {
                DecompressionAlgorithm decompressionAlgorithm2;
                DecompressionAlgorithm it = decompressionAlgorithm2 = decompressionAlgorithmArray[i];
                boolean bl = false;
                if (!StringsKt.equals(it.getEncoding(), encoding, true)) continue;
                decompressionAlgorithm = decompressionAlgorithm2;
                break block1;
            }
            decompressionAlgorithm = null;
        }
        return decompressionAlgorithm;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00078&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/CompressionInterceptor$DecompressionAlgorithm;", "", "Lokio/BufferedSource;", "compressedSource", "Lokio/Source;", "decompress", "(Lokio/BufferedSource;)Lokio/Source;", "", "getEncoding", "()Ljava/lang/String;", "encoding", "okhttp"})
    public static interface DecompressionAlgorithm {
        @NotNull
        public String getEncoding();

        @NotNull
        public Source decompress(@NotNull BufferedSource var1);
    }
}

