/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3;

import com.smushytaco.nickname_detector.shaded.okhttp3.Address;
import com.smushytaco.nickname_detector.shaded.okhttp3.Protocol;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._HostnamesCommonKt;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0014\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0007\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u0003\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0007\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u0005\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0007\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u0007\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "address", "Ljava/net/Proxy;", "proxy", "Ljava/net/InetSocketAddress;", "socketAddress", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;Ljava/net/Proxy;Ljava/net/InetSocketAddress;)V", "-deprecated_address", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "-deprecated_proxy", "()Ljava/net/Proxy;", "-deprecated_socketAddress", "()Ljava/net/InetSocketAddress;", "", "requiresTunnel", "()Z", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "Ljava/net/Proxy;", "Ljava/net/InetSocketAddress;", "okhttp"})
public final class Route {
    @NotNull
    private final Address address;
    @NotNull
    private final Proxy proxy;
    @NotNull
    private final InetSocketAddress socketAddress;

    public Route(@NotNull Address address, @NotNull Proxy proxy, @NotNull InetSocketAddress socketAddress) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(proxy, "proxy");
        Intrinsics.checkNotNullParameter(socketAddress, "socketAddress");
        this.address = address;
        this.proxy = proxy;
        this.socketAddress = socketAddress;
    }

    @JvmName(name="address")
    @NotNull
    public final Address address() {
        return this.address;
    }

    @JvmName(name="proxy")
    @NotNull
    public final Proxy proxy() {
        return this.proxy;
    }

    @JvmName(name="socketAddress")
    @NotNull
    public final InetSocketAddress socketAddress() {
        return this.socketAddress;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="address", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_address")
    @NotNull
    public final Address -deprecated_address() {
        return this.address;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="proxy", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_proxy")
    @NotNull
    public final Proxy -deprecated_proxy() {
        return this.proxy;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="socketAddress", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_socketAddress")
    @NotNull
    public final InetSocketAddress -deprecated_socketAddress() {
        return this.socketAddress;
    }

    public final boolean requiresTunnel() {
        if (this.proxy.type() != Proxy.Type.HTTP) {
            return false;
        }
        return this.address.sslSocketFactory() != null || this.address.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Route && Intrinsics.areEqual(((Route)other).address, this.address) && Intrinsics.areEqual(((Route)other).proxy, this.proxy) && Intrinsics.areEqual(((Route)other).socketAddress, this.socketAddress);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.address.hashCode();
        result = 31 * result + this.proxy.hashCode();
        result = 31 * result + this.socketAddress.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String addressHostname = this.address.url().host();
        Object object = this.socketAddress.getAddress();
        String socketHostname = object != null && (object = ((InetAddress)object).getHostAddress()) != null ? _HostnamesCommonKt.toCanonicalHost((String)object) : null;
        StringBuilder stringBuilder2 = StringsKt.contains$default((CharSequence)addressHostname, ':', false, 2, null) ? $this$toString_u24lambda_u240.append("[").append(addressHostname).append("]") : $this$toString_u24lambda_u240.append(addressHostname);
        if (this.address.url().port() != this.socketAddress.getPort() || Intrinsics.areEqual(addressHostname, socketHostname)) {
            $this$toString_u24lambda_u240.append(":");
            $this$toString_u24lambda_u240.append(this.address.url().port());
        }
        if (!Intrinsics.areEqual(addressHostname, socketHostname)) {
            StringBuilder stringBuilder3 = Intrinsics.areEqual(this.proxy, Proxy.NO_PROXY) ? $this$toString_u24lambda_u240.append(" at ") : $this$toString_u24lambda_u240.append(" via proxy ");
            StringBuilder stringBuilder4 = socketHostname == null ? $this$toString_u24lambda_u240.append("<unresolved>") : (StringsKt.contains$default((CharSequence)socketHostname, ':', false, 2, null) ? $this$toString_u24lambda_u240.append("[").append(socketHostname).append("]") : $this$toString_u24lambda_u240.append(socketHostname));
            $this$toString_u24lambda_u240.append(":");
            $this$toString_u24lambda_u240.append(this.socketAddress.getPort());
        }
        return stringBuilder.toString();
    }
}

