/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilCommonKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Task;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskLoggerKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 92\u00020\u0001:\u0003:;9B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\n\u00a2\u0006\u0004\b!\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010+R\u0016\u00101\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010+R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\b028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\b028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108\u00a8\u0006<"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Lockable;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$Backend;", "backend", "Ljava/util/logging/Logger;", "logger", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$Backend;Ljava/util/logging/Logger;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "taskQueue", "", "kickCoordinator$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;)V", "kickCoordinator", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;", "task", "beforeRun", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;)V", "", "delayNanos", "", "completedNormally", "afterRun", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;JZ)V", "awaitTaskToRun", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Task;", "startAnotherThread", "()V", "newQueue", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "", "activeQueues", "()Ljava/util/List;", "cancelAll", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$Backend;", "getBackend", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$Backend;", "logger$1", "Ljava/util/logging/Logger;", "getLogger$okhttp", "()Ljava/util/logging/Logger;", "", "nextQueueName", "I", "coordinatorWaiting", "Z", "coordinatorWakeUpAt", "J", "executeCallCount", "runCallCount", "", "busyQueues", "Ljava/util/List;", "readyQueues", "Ljava/lang/Runnable;", "runnable", "Ljava/lang/Runnable;", "Companion", "Backend", "RealBackend", "okhttp"})
@SourceDebugExtension(value={"SMAP\nTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,364:1\n55#2,4:365\n55#2,4:369\n55#2,4:373\n55#2,4:377\n55#2,4:381\n63#2:385\n63#2:386\n55#2,4:387\n*S KotlinDebug\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner\n*L\n107#1:365,4\n125#1:369,4\n140#1:373,4\n171#1:377,4\n251#1:381,4\n259#1:385\n268#1:386\n274#1:387,4\n*E\n"})
public final class TaskRunner
implements Lockable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Backend backend;
    @NotNull
    private final Logger logger$1;
    private int nextQueueName;
    private boolean coordinatorWaiting;
    private long coordinatorWakeUpAt;
    private int executeCallCount;
    private int runCallCount;
    @NotNull
    private final List<TaskQueue> busyQueues;
    @NotNull
    private final List<TaskQueue> readyQueues;
    @NotNull
    private final Runnable runnable;
    @NotNull
    private static final Logger logger;
    @JvmField
    @NotNull
    public static final TaskRunner INSTANCE;

    public TaskRunner(@NotNull Backend backend, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(backend, "backend");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.backend = backend;
        this.logger$1 = logger;
        this.nextQueueName = 10000;
        this.busyQueues = new ArrayList();
        this.readyQueues = new ArrayList();
        this.runnable = new Runnable(this){
            final /* synthetic */ TaskRunner this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Unit unit;
                Task $i$a$-withLock-TaskRunner$runnable$1$run$task$23332;
                void $this$withLock$iv;
                Task task2 = null;
                Lockable lockable = this.this$0;
                TaskRunner taskRunner = this.this$0;
                boolean $i$f$withLock3222 = false;
                Object object = $this$withLock$iv;
                synchronized (object) {
                    boolean $i$a$-withLock-TaskRunner$runnable$1$run$task$23332 = false;
                    int n = TaskRunner.access$getRunCallCount$p(taskRunner);
                    TaskRunner.access$setRunCallCount$p(taskRunner, n + 1);
                    $i$a$-withLock-TaskRunner$runnable$1$run$task$23332 = taskRunner.awaitTaskToRun();
                }
                Task task = $i$a$-withLock-TaskRunner$runnable$1$run$task$23332;
                if (task == null) {
                    return;
                }
                task2 = task;
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                try {
                    while (true) {
                        Task task3;
                        Task task4;
                        void $this$withLock$iv2;
                        long l;
                        Lockable task$iv;
                        block19: {
                            long elapsedNs$iv;
                            TaskQueue queue$iv;
                            void $this$logElapsed$iv;
                            currentThread.setName(task2.getName());
                            object = this.this$0.getLogger$okhttp();
                            $i$a$-withLock-TaskRunner$runnable$1$run$task$23332 = task2;
                            Intrinsics.checkNotNull(task2.getQueue$okhttp());
                            boolean $i$f$logElapsed = false;
                            long startNs$iv = -1L;
                            boolean loggingEnabled$iv = $this$logElapsed$iv.isLoggable(Level.FINE);
                            if (loggingEnabled$iv) {
                                startNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime();
                                TaskLoggerKt.access$log((Logger)$this$logElapsed$iv, (Task)((Object)task$iv), queue$iv, "starting");
                            }
                            boolean completedNormally$iv = false;
                            try {
                                boolean bl = false;
                                long result$iv = task2.runOnce();
                                completedNormally$iv = true;
                                l = result$iv;
                                if (!loggingEnabled$iv) break block19;
                                elapsedNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                            }
                            catch (Throwable throwable) {
                                if (!loggingEnabled$iv) throw throwable;
                                elapsedNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                                if (completedNormally$iv) {
                                    TaskLoggerKt.access$log((Logger)$this$logElapsed$iv, (Task)((Object)task$iv), queue$iv, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs$iv));
                                    throw throwable;
                                }
                                TaskLoggerKt.access$log((Logger)$this$logElapsed$iv, (Task)((Object)task$iv), queue$iv, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs$iv));
                                throw throwable;
                            }
                            TaskLoggerKt.access$log((Logger)$this$logElapsed$iv, (Task)((Object)task$iv), queue$iv, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs$iv));
                        }
                        long delayNanos = l;
                        task$iv = this.this$0;
                        TaskRunner taskRunner2 = this.this$0;
                        boolean $i$f$withLock2 = false;
                        unit = $this$withLock$iv2;
                        synchronized (unit) {
                            boolean bl = false;
                            TaskRunner.access$afterRun(taskRunner2, task2, delayNanos, true);
                            task4 = taskRunner2.awaitTaskToRun();
                        }
                        if (task4 == null) {
                            return;
                        }
                        task2 = task3;
                        continue;
                        break;
                    }
                }
                catch (Throwable thrown) {
                    void $this$withLock$iv3;
                    Lockable $i$f$withLock3222 = this.this$0;
                    object = this.this$0;
                    boolean $i$f$withLock4 = false;
                    void taskRunner2 = $this$withLock$iv3;
                    synchronized (taskRunner2) {
                        boolean bl = false;
                        TaskRunner.access$afterRun((TaskRunner)object, task2, -1L, false);
                        unit = Unit.INSTANCE;
                    }
                    if (!(thrown instanceof InterruptedException)) throw thrown;
                    Thread.currentThread().interrupt();
                    return;
                }
                finally {
                    currentThread.setName(oldName);
                }
            }
        };
    }

    public /* synthetic */ TaskRunner(Backend backend, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = TaskRunner.logger;
        }
        this(backend, logger);
    }

    @NotNull
    public final Backend getBackend() {
        return this.backend;
    }

    @NotNull
    public final Logger getLogger$okhttp() {
        return this.logger$1;
    }

    public final void kickCoordinator$okhttp(@NotNull TaskQueue taskQueue) {
        Intrinsics.checkNotNullParameter(taskQueue, "taskQueue");
        Lockable $this$assertLockHeld$iv = this;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        if (taskQueue.getActiveTask$okhttp() == null) {
            if (!((Collection)taskQueue.getFutureTasks$okhttp()).isEmpty()) {
                _UtilCommonKt.addIfAbsent(this.readyQueues, taskQueue);
            } else {
                this.readyQueues.remove(taskQueue);
            }
        }
        if (this.coordinatorWaiting) {
            this.backend.coordinatorNotify(this);
        } else {
            this.startAnotherThread();
        }
    }

    private final void beforeRun(Task task) {
        Lockable $this$assertLockHeld$iv = this;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        task.setNextExecuteNanoTime$okhttp(-1L);
        TaskQueue taskQueue = task.getQueue$okhttp();
        Intrinsics.checkNotNull(taskQueue);
        TaskQueue queue = taskQueue;
        queue.getFutureTasks$okhttp().remove(task);
        this.readyQueues.remove(queue);
        queue.setActiveTask$okhttp(task);
        this.busyQueues.add(queue);
    }

    private final void afterRun(Task task, long delayNanos, boolean completedNormally) {
        Lockable $this$assertLockHeld$iv = this;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        TaskQueue taskQueue = task.getQueue$okhttp();
        Intrinsics.checkNotNull(taskQueue);
        TaskQueue queue = taskQueue;
        if (!(queue.getActiveTask$okhttp() == task)) {
            throw new IllegalStateException("Check failed.");
        }
        boolean cancelActiveTask = queue.getCancelActiveTask$okhttp();
        queue.setCancelActiveTask$okhttp(false);
        queue.setActiveTask$okhttp(null);
        this.busyQueues.remove(queue);
        if (delayNanos != -1L && !cancelActiveTask && !queue.getShutdown$okhttp()) {
            queue.scheduleAndDecide$okhttp(task, delayNanos, true);
        }
        if (!((Collection)queue.getFutureTasks$okhttp()).isEmpty()) {
            this.readyQueues.add(queue);
            if (!completedNormally) {
                this.startAnotherThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Task awaitTaskToRun() {
        Lockable $this$assertLockHeld$iv = this;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        while (!this.readyQueues.isEmpty()) {
            long now = this.backend.nanoTime();
            long minDelayNanos = Long.MAX_VALUE;
            Task readyTask = null;
            boolean multipleReadyTasks = false;
            for (TaskQueue queue : this.readyQueues) {
                Task candidate = queue.getFutureTasks$okhttp().get(0);
                long candidateDelay = Math.max(0L, candidate.getNextExecuteNanoTime$okhttp() - now);
                if (candidateDelay > 0L) {
                    minDelayNanos = Math.min(candidateDelay, minDelayNanos);
                    continue;
                }
                if (readyTask != null) {
                    multipleReadyTasks = true;
                    break;
                }
                readyTask = candidate;
            }
            if (readyTask != null) {
                this.beforeRun(readyTask);
                if (multipleReadyTasks || !this.coordinatorWaiting && !((Collection)this.readyQueues).isEmpty()) {
                    this.startAnotherThread();
                }
                return readyTask;
            }
            if (this.coordinatorWaiting) {
                if (minDelayNanos < this.coordinatorWakeUpAt - now) {
                    this.backend.coordinatorNotify(this);
                }
                return null;
            }
            this.coordinatorWaiting = true;
            this.coordinatorWakeUpAt = now + minDelayNanos;
            try {
                this.backend.coordinatorWait(this, minDelayNanos);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.cancelAll();
                continue;
            }
            finally {
                this.coordinatorWaiting = false;
                continue;
            }
            break;
        }
        return null;
    }

    private final void startAnotherThread() {
        Lockable $this$assertLockHeld$iv = this;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        if (this.executeCallCount > this.runCallCount) {
            return;
        }
        int n = this.executeCallCount;
        this.executeCallCount = n + 1;
        this.backend.execute(this, this.runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TaskQueue newQueue() {
        int n;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            int n2 = this.nextQueueName;
            this.nextQueueName = n2 + 1;
            n = n2;
        }
        int name = n;
        return new TaskQueue(this, "" + 'Q' + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<TaskQueue> activeQueues() {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            List<TaskQueue> list = CollectionsKt.plus((Collection)this.busyQueues, (Iterable)this.readyQueues);
            return list;
        }
    }

    public final void cancelAll() {
        int i;
        Lockable $this$assertLockHeld$iv = this;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        for (i = this.busyQueues.size() - 1; -1 < i; --i) {
            this.busyQueues.get(i).cancelAllAndDecide$okhttp();
        }
        for (i = this.readyQueues.size() - 1; -1 < i; --i) {
            TaskQueue queue = this.readyQueues.get(i);
            queue.cancelAllAndDecide$okhttp();
            if (!queue.getFutureTasks$okhttp().isEmpty()) continue;
            this.readyQueues.remove(i);
        }
    }

    public static final /* synthetic */ int access$getRunCallCount$p(TaskRunner $this) {
        return $this.runCallCount;
    }

    public static final /* synthetic */ void access$setRunCallCount$p(TaskRunner $this, int n) {
        $this.runCallCount = n;
    }

    public static final /* synthetic */ void access$afterRun(TaskRunner $this, Task task, long delayNanos, boolean completedNormally) {
        $this.afterRun(task, delayNanos, completedNormally);
    }

    static {
        Logger logger = Logger.getLogger(TaskRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        TaskRunner.logger = logger;
        INSTANCE = new TaskRunner(new RealBackend(_UtilJvmKt.threadFactory(_UtilJvmKt.okHttpName + " TaskRunner", true)), null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\"\u0004\b\u0000\u0010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH&\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0012H&\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$Backend;", "", "", "nanoTime", "()J", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "coordinatorNotify", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;)V", "nanos", "coordinatorWait", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;J)V", "T", "Ljava/util/concurrent/BlockingQueue;", "queue", "decorate", "(Ljava/util/concurrent/BlockingQueue;)Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "runnable", "execute", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;Ljava/lang/Runnable;)V", "okhttp"})
    public static interface Backend {
        public long nanoTime();

        public void coordinatorNotify(@NotNull TaskRunner var1);

        public void coordinatorWait(@NotNull TaskRunner var1, long var2);

        @NotNull
        public <T> BlockingQueue<T> decorate(@NotNull BlockingQueue<T> var1);

        public void execute(@NotNull TaskRunner var1, @NotNull Runnable var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$Companion;", "", "<init>", "()V", "Ljava/util/logging/Logger;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "INSTANCE", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012\"\u0004\b\u0000\u0010\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$RealBackend;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner$Backend;", "Ljava/util/concurrent/ThreadFactory;", "threadFactory", "<init>", "(Ljava/util/concurrent/ThreadFactory;)V", "", "nanoTime", "()J", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "coordinatorNotify", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;)V", "nanos", "coordinatorWait", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;J)V", "T", "Ljava/util/concurrent/BlockingQueue;", "queue", "decorate", "(Ljava/util/concurrent/BlockingQueue;)Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "runnable", "execute", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;Ljava/lang/Runnable;)V", "shutdown", "()V", "Ljava/util/concurrent/ThreadPoolExecutor;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner$RealBackend\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,364:1\n36#2:365\n55#2,4:366\n41#2,6:370\n*S KotlinDebug\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner$RealBackend\n*L\n324#1:365\n337#1:366,4\n339#1:370,6\n*E\n"})
    public static final class RealBackend
    implements Backend {
        @NotNull
        private final ThreadPoolExecutor executor;

        public RealBackend(@NotNull ThreadFactory threadFactory) {
            Intrinsics.checkNotNullParameter(threadFactory, "threadFactory");
            this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), threadFactory);
        }

        @NotNull
        public final ThreadPoolExecutor getExecutor() {
            return this.executor;
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }

        @Override
        public void coordinatorNotify(@NotNull TaskRunner taskRunner) {
            Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
            Lockable $this$notify$iv = taskRunner;
            boolean $i$f$notify = false;
            ((Object)$this$notify$iv).notify();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void coordinatorWait(@NotNull TaskRunner taskRunner, long nanos) throws InterruptedException {
            Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
            Lockable $this$assertLockHeld$iv = taskRunner;
            boolean $i$f$assertLockHeld = false;
            if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
            }
            if (nanos > 0L) {
                $this$assertLockHeld$iv = taskRunner;
                long nanos$iv = nanos;
                boolean $i$f$awaitNanos = false;
                long ms$iv = nanos$iv / 1000000L;
                long ns$iv = nanos$iv - ms$iv * 1000000L;
                if (ms$iv > 0L || nanos$iv > 0L) {
                    void $this$awaitNanos$iv;
                    ((Object)$this$awaitNanos$iv).wait(ms$iv, (int)ns$iv);
                }
            }
        }

        @Override
        @NotNull
        public <T> BlockingQueue<T> decorate(@NotNull BlockingQueue<T> queue) {
            Intrinsics.checkNotNullParameter(queue, "queue");
            return queue;
        }

        @Override
        public void execute(@NotNull TaskRunner taskRunner, @NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
            Intrinsics.checkNotNullParameter(runnable2, "runnable");
            this.executor.execute(runnable2);
        }

        public final void shutdown() {
            this.executor.shutdown();
        }
    }
}

