/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Task;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskQueue;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskRunner;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ExchangeFinder;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.FailedPlan;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RoutePlanner;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\"\u0010$\u001a\u0010\u0012\f\u0012\n #*\u0004\u0018\u00010\u000b0\u000b0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/FastFallbackExchangeFinder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ExchangeFinder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;", "routePlanner", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "find", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner$ConnectResult;", "launchTcpConnect", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner$ConnectResult;", "", "timeout", "Ljava/util/concurrent/TimeUnit;", "unit", "awaitTcpConnect", "(JLjava/util/concurrent/TimeUnit;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner$ConnectResult;", "", "cancelInFlightConnects", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;", "getRoutePlanner", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "connectDelayNanos", "J", "nextTcpConnectAtNanos", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner$Plan;", "tcpConnectsInFlight", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/util/concurrent/BlockingQueue;", "kotlin.jvm.PlatformType", "connectResults", "Ljava/util/concurrent/BlockingQueue;", "okhttp"})
public final class FastFallbackExchangeFinder
implements ExchangeFinder {
    @NotNull
    private final RoutePlanner routePlanner;
    @NotNull
    private final TaskRunner taskRunner;
    private final long connectDelayNanos;
    private long nextTcpConnectAtNanos;
    @NotNull
    private final CopyOnWriteArrayList<RoutePlanner.Plan> tcpConnectsInFlight;
    @NotNull
    private final BlockingQueue<RoutePlanner.ConnectResult> connectResults;

    public FastFallbackExchangeFinder(@NotNull RoutePlanner routePlanner, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter(routePlanner, "routePlanner");
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        this.routePlanner = routePlanner;
        this.taskRunner = taskRunner;
        this.connectDelayNanos = TimeUnit.MILLISECONDS.toNanos(250L);
        this.nextTcpConnectAtNanos = Long.MIN_VALUE;
        this.tcpConnectsInFlight = new CopyOnWriteArrayList();
        this.connectResults = this.taskRunner.getBackend().decorate(new LinkedBlockingDeque());
    }

    @Override
    @NotNull
    public RoutePlanner getRoutePlanner() {
        return this.routePlanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RealConnection find() {
        IOException firstException = null;
        try {
            while (!((Collection)this.tcpConnectsInFlight).isEmpty() || RoutePlanner.hasNext$default(this.getRoutePlanner(), null, 1, null)) {
                RoutePlanner.Plan nextPlan;
                Throwable throwable;
                if (this.getRoutePlanner().isCanceled()) {
                    throw new IOException("Canceled");
                }
                long now = this.taskRunner.getBackend().nanoTime();
                long awaitTimeoutNanos = this.nextTcpConnectAtNanos - now;
                RoutePlanner.ConnectResult connectResult = null;
                if (this.tcpConnectsInFlight.isEmpty() || awaitTimeoutNanos <= 0L) {
                    connectResult = this.launchTcpConnect();
                    this.nextTcpConnectAtNanos = now + this.connectDelayNanos;
                    awaitTimeoutNanos = this.connectDelayNanos;
                }
                if (connectResult == null) {
                    RoutePlanner.ConnectResult connectResult2 = this.awaitTcpConnect(awaitTimeoutNanos, TimeUnit.NANOSECONDS);
                    if (connectResult2 == null) continue;
                    connectResult = connectResult2;
                }
                if (connectResult.isSuccess()) {
                    this.cancelInFlightConnects();
                    if (!connectResult.getPlan().isReady()) {
                        connectResult = connectResult.getPlan().connectTlsEtc();
                    }
                    if (connectResult.isSuccess()) {
                        RealConnection realConnection = connectResult.getPlan().handleSuccess();
                        return realConnection;
                    }
                }
                if ((throwable = connectResult.getThrowable()) != null) {
                    if (!(throwable instanceof IOException)) {
                        throw throwable;
                    }
                    if (firstException == null) {
                        firstException = (IOException)throwable;
                    } else {
                        ExceptionsKt.addSuppressed(firstException, throwable);
                    }
                }
                if ((nextPlan = connectResult.getNextPlan()) == null) continue;
                this.getRoutePlanner().getDeferredPlans().addFirst(nextPlan);
            }
        }
        finally {
            this.cancelInFlightConnects();
        }
        IOException iOException = firstException;
        Intrinsics.checkNotNull(iOException);
        throw iOException;
    }

    private final RoutePlanner.ConnectResult launchTcpConnect() {
        RoutePlanner.Plan plan;
        if (RoutePlanner.hasNext$default(this.getRoutePlanner(), null, 1, null)) {
            try {
                plan = this.getRoutePlanner().plan();
            }
            catch (Throwable e) {
                plan = new FailedPlan(e);
            }
        } else {
            return null;
        }
        RoutePlanner.Plan plan2 = plan;
        if (plan2.isReady()) {
            return new RoutePlanner.ConnectResult(plan2, null, null, 6, null);
        }
        if (plan2 instanceof FailedPlan) {
            return ((FailedPlan)plan2).getResult();
        }
        ((Collection)this.tcpConnectsInFlight).add(plan2);
        String taskName = _UtilJvmKt.okHttpName + " connect " + this.getRoutePlanner().getAddress().url().redact();
        TaskQueue.schedule$default(this.taskRunner.newQueue(), new Task(taskName, plan2, this){
            final /* synthetic */ RoutePlanner.Plan $plan;
            final /* synthetic */ FastFallbackExchangeFinder this$0;
            {
                this.$plan = $plan;
                this.this$0 = $receiver;
                super($taskName, false, 2, null);
            }

            public long runOnce() {
                RoutePlanner.ConnectResult connectResult;
                try {
                    connectResult = this.$plan.connectTcp();
                }
                catch (Throwable e) {
                    connectResult = new RoutePlanner.ConnectResult(this.$plan, null, e, 2, null);
                }
                RoutePlanner.ConnectResult connectResult2 = connectResult;
                if (FastFallbackExchangeFinder.access$getTcpConnectsInFlight$p(this.this$0).contains(this.$plan)) {
                    FastFallbackExchangeFinder.access$getConnectResults$p(this.this$0).put(connectResult2);
                }
                return -1L;
            }
        }, 0L, 2, null);
        return null;
    }

    private final RoutePlanner.ConnectResult awaitTcpConnect(long timeout2, TimeUnit unit) {
        if (this.tcpConnectsInFlight.isEmpty()) {
            return null;
        }
        RoutePlanner.ConnectResult connectResult = this.connectResults.poll(timeout2, unit);
        if (connectResult == null) {
            return null;
        }
        RoutePlanner.ConnectResult result = connectResult;
        this.tcpConnectsInFlight.remove(result.getPlan());
        return result;
    }

    private final void cancelInFlightConnects() {
        Iterator<RoutePlanner.Plan> iterator2 = this.tcpConnectsInFlight.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<RoutePlanner.Plan> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            RoutePlanner.Plan retry;
            RoutePlanner.Plan plan = iterator3.next();
            plan.cancel();
            if (plan.retry() == null) continue;
            this.getRoutePlanner().getDeferredPlans().addLast(retry);
        }
        this.tcpConnectsInFlight.clear();
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getTcpConnectsInFlight$p(FastFallbackExchangeFinder $this) {
        return $this.tcpConnectsInFlight;
    }

    public static final /* synthetic */ BlockingQueue access$getConnectResults$p(FastFallbackExchangeFinder $this) {
        return $this.connectResults;
    }
}

