/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection;

import com.smushytaco.nickname_detector.shaded.okhttp3.Address;
import com.smushytaco.nickname_detector.shaded.okhttp3.ConnectionPool;
import com.smushytaco.nickname_detector.shaded.okhttp3.Route;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Task;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskQueue;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskRunner;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.AddressPolicy;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ConnectionListener;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ConnectionUser;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ExchangeFinder;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.PoolConnectionUser;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealCall;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnectionPool;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0089\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001O\u0018\u0000 U2\u00020\u0001:\u0002VUBQ\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0015\u001a\u00020\u0014*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0018J?\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\u001a\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\"\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\"\u00a2\u0006\u0004\b(\u0010)J\r\u0010*\u001a\u00020\u0014\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010-\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J+\u00101\u001a\u00020\u001a2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130/2\u0006\u0010%\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b1\u00102J\u001f\u00103\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b3\u00104J\u001d\u00107\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\r2\u0006\u00106\u001a\u000205\u00a2\u0006\u0004\b7\u00108J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\r\u00a2\u0006\u0004\b\u0015\u00109J\r\u0010:\u001a\u00020\u0014\u00a2\u0006\u0004\b:\u0010+J\u0017\u0010<\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b<\u0010=J\u001b\u0010?\u001a\u00020\u0006*\u00020\u00062\u0006\u0010>\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b?\u0010@R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010AR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010BR\u001a\u0010\u000b\u001a\u00020\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010C\u001a\u0004\bD\u0010ER,\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010FR\u001a\u0010G\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\"\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010KR\u0014\u0010M\u001a\u00020L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0014\u0010P\u001a\u00020O8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u001a\u0010S\u001a\b\u0012\u0004\u0012\u00020\"0R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010T\u00a8\u0006W"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "maxIdleConnections", "", "keepAliveDuration", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;", "connectionListener", "Lkotlin/Function3;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionUser;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ExchangeFinder;", "exchangeFinderFactory", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;Lkotlin/jvm/functions/Function3;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$AddressState;", "", "scheduleOpener", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$AddressState;)V", "idleConnectionCount", "()I", "connectionCount", "", "doExtensiveHealthChecks", "address", "connectionUser", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;", "routes", "requireMultiplexed", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "callAcquirePooledConnection", "(ZLcom/smushytaco/nickname_detector/shaded/okhttp3/Address;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionUser;Ljava/util/List;Z)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "connection", "put", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;)V", "connectionBecameIdle", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;)Z", "evictAll", "()V", "now", "closeConnections", "(J)J", "", "addressStates", "isEvictable", "(Ljava/util/Map;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;)Z", "pruneAndGetAllocationCount", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;J)I", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/AddressPolicy;", "policy", "setPolicy", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/AddressPolicy;)V", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;)V", "scheduleCloser", "state", "openConnections", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$AddressState;)J", "amount", "jitterBy", "(JI)J", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "I", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;", "getConnectionListener$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionListener;", "Lkotlin/jvm/functions/Function3;", "keepAliveDurationNs", "J", "getKeepAliveDurationNs$okhttp", "()J", "Ljava/util/Map;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "cleanupQueue", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "com/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool.cleanupTask.1", "cleanupTask", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Companion", "AddressState", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealConnectionPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,465:1\n1#2:466\n1788#3,3:467\n1791#3:471\n63#4:470\n63#4:472\n63#4:473\n55#4,4:474\n55#4,4:478\n63#4:482\n63#4:483\n63#4:484\n63#4:485\n55#4,4:486\n63#4:490\n63#4:491\n*S KotlinDebug\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n*L\n82#1:467,3\n82#1:471\n83#1:470\n110#1:472\n129#1:473\n145#1:474,4\n157#1:478,4\n176#1:482\n214#1:483\n237#1:484\n285#1:485\n336#1:486,4\n415#1:490\n430#1:491\n*E\n"})
public final class RealConnectionPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner taskRunner;
    private final int maxIdleConnections;
    @NotNull
    private final ConnectionListener connectionListener;
    @NotNull
    private final Function3<RealConnectionPool, Address, ConnectionUser, ExchangeFinder> exchangeFinderFactory;
    private final long keepAliveDurationNs;
    @NotNull
    private volatile Map<Address, AddressState> addressStates;
    @NotNull
    private final TaskQueue cleanupQueue;
    @NotNull
    private final cleanupTask.1 cleanupTask;
    @NotNull
    private final ConcurrentLinkedQueue<RealConnection> connections;
    private static AtomicReferenceFieldUpdater<RealConnectionPool, Map<?, ?>> addressStatesUpdater = AtomicReferenceFieldUpdater.newUpdater(RealConnectionPool.class, Map.class, "addressStates");

    public RealConnectionPool(@NotNull TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, @NotNull TimeUnit timeUnit, @NotNull ConnectionListener connectionListener, @NotNull Function3<? super RealConnectionPool, ? super Address, ? super ConnectionUser, ? extends ExchangeFinder> exchangeFinderFactory) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        Intrinsics.checkNotNullParameter(connectionListener, "connectionListener");
        Intrinsics.checkNotNullParameter(exchangeFinderFactory, "exchangeFinderFactory");
        this.taskRunner = taskRunner;
        this.maxIdleConnections = maxIdleConnections;
        this.connectionListener = connectionListener;
        this.exchangeFinderFactory = exchangeFinderFactory;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.addressStates = MapsKt.emptyMap();
        this.cleanupQueue = this.taskRunner.newQueue();
        String string = _UtilJvmKt.okHttpName + " ConnectionPool connection closer";
        this.cleanupTask = new Task(this, string){
            final /* synthetic */ RealConnectionPool this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false, 2, null);
            }

            public long runOnce() {
                return this.this$0.closeConnections(System.nanoTime());
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        if (!(keepAliveDuration > 0L)) {
            boolean bl = false;
            String string2 = "keepAliveDuration <= 0: " + keepAliveDuration;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final ConnectionListener getConnectionListener$okhttp() {
        return this.connectionListener;
    }

    public final long getKeepAliveDurationNs$okhttp() {
        return this.keepAliveDurationNs;
    }

    private final void scheduleOpener(AddressState $this$scheduleOpener) {
        String string = _UtilJvmKt.okHttpName + " ConnectionPool connection opener";
        TaskQueue.schedule$default($this$scheduleOpener.getQueue(), new Task(this, $this$scheduleOpener, string){
            final /* synthetic */ RealConnectionPool this$0;
            final /* synthetic */ AddressState $this_scheduleOpener;
            {
                this.this$0 = $receiver;
                this.$this_scheduleOpener = $receiver2;
                super($super_call_param$1, false, 2, null);
            }

            public long runOnce() {
                return RealConnectionPool.access$openConnections(this.this$0, this.$this_scheduleOpener);
            }
        }, 0L, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int idleConnectionCount() {
        int n;
        Iterable $this$count$iv = this.connections;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean bl;
                RealConnection it = (RealConnection)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                Lockable $this$withLock$iv = it;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl3 = false;
                    bl = it.getCalls().isEmpty();
                }
                if (!bl || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int connectionCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RealConnection callAcquirePooledConnection(boolean doExtensiveHealthChecks, @NotNull Address address, @NotNull ConnectionUser connectionUser, @Nullable List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(connectionUser, "connectionUser");
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<RealConnection> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Socket socket;
            boolean bl;
            RealConnection connection = iterator3.next();
            Intrinsics.checkNotNull(connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl2;
                boolean bl3 = false;
                if (requireMultiplexed && !connection.isMultiplexed$okhttp()) {
                    bl2 = false;
                } else if (!connection.isEligible$okhttp(address, routes)) {
                    bl2 = false;
                } else {
                    connectionUser.acquireConnectionNoEvents(connection);
                    bl2 = true;
                }
                bl = bl2;
            }
            boolean acquired = bl;
            if (!acquired) continue;
            if (connection.isHealthy(doExtensiveHealthChecks)) {
                return connection;
            }
            boolean noNewExchangesEvent = false;
            Lockable $this$withLock$iv2 = connection;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl4 = false;
                noNewExchangesEvent = !connection.getNoNewExchanges();
                connection.setNoNewExchanges(true);
                socket = connectionUser.releaseConnectionNoEvents();
            }
            Socket toClose = socket;
            if (toClose != null) {
                _UtilJvmKt.closeQuietly(toClose);
                this.connectionListener.connectionClosed(connection);
                continue;
            }
            if (!noNewExchangesEvent) continue;
            this.connectionListener.noNewExchanges(connection);
        }
        return null;
    }

    public final void put(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Lockable $this$assertLockHeld$iv = connection;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        this.connections.add(connection);
        this.scheduleCloser();
    }

    public final boolean connectionBecameIdle(@NotNull RealConnection connection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(connection, "connection");
        Lockable $this$assertLockHeld$iv = connection;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            connection.setNoNewExchanges(true);
            this.connections.remove(connection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            this.scheduleOpener(connection.getRoute().address());
            bl = true;
        } else {
            this.scheduleCloser();
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<RealConnection> i = iterator2;
        while (i.hasNext()) {
            Socket socket;
            RealConnection connection = i.next();
            Intrinsics.checkNotNull(connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                Socket socket2;
                boolean bl = false;
                if (connection.getCalls().isEmpty()) {
                    i.remove();
                    connection.setNoNewExchanges(true);
                    socket2 = connection.socket();
                } else {
                    socket2 = null;
                }
                socket = socket2;
            }
            Socket socketToClose = socket;
            if (socketToClose == null) continue;
            _UtilJvmKt.closeQuietly(socketToClose);
            this.connectionListener.connectionClosed(connection);
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
        for (AddressState policy : this.addressStates.values()) {
            this.scheduleOpener(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long closeConnections(long now) {
        Map<Address, AddressState> addressStates = this.addressStates;
        for (AddressState state : addressStates.values()) {
            state.setConcurrentCallCapacity(0);
        }
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            RealConnection connection = (RealConnection)iterator3.next();
            if (addressStates.get(connection.getRoute().address()) == null) continue;
            Intrinsics.checkNotNull(connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                AddressState addressState;
                boolean bl = false;
                addressState.setConcurrentCallCapacity(addressState.getConcurrentCallCapacity() + connection.getAllocationLimit$okhttp());
                Unit unit = Unit.INSTANCE;
            }
        }
        long earliestOldIdleAtNs = 0L;
        earliestOldIdleAtNs = now - this.keepAliveDurationNs + 1L;
        RealConnection earliestOldConnection = null;
        long earliestEvictableIdleAtNs = 0L;
        earliestEvictableIdleAtNs = Long.MAX_VALUE;
        RealConnection earliestEvictableConnection = null;
        int inUseConnectionCount = 0;
        int evictableConnectionCount = 0;
        Iterator<RealConnection> iterator4 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        Iterator<RealConnection> bl = iterator4;
        while (bl.hasNext()) {
            RealConnection connection = bl.next();
            Intrinsics.checkNotNull(connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl2 = false;
                if (this.pruneAndGetAllocationCount(connection, now) > 0) {
                    ++inUseConnectionCount;
                } else {
                    long idleAtNs = connection.getIdleAtNs();
                    if (idleAtNs < earliestOldIdleAtNs) {
                        earliestOldIdleAtNs = idleAtNs;
                        earliestOldConnection = connection;
                    }
                    if (this.isEvictable(addressStates, connection)) {
                        ++evictableConnectionCount;
                        if (idleAtNs < earliestEvictableIdleAtNs) {
                            earliestEvictableIdleAtNs = idleAtNs;
                            earliestEvictableConnection = connection;
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        RealConnection toEvict = null;
        long toEvictIdleAtNs = 0L;
        if (earliestOldConnection != null) {
            toEvict = earliestOldConnection;
            toEvictIdleAtNs = earliestOldIdleAtNs;
        } else if (evictableConnectionCount > this.maxIdleConnections) {
            toEvict = earliestEvictableConnection;
            toEvictIdleAtNs = earliestEvictableIdleAtNs;
        } else {
            toEvict = null;
            toEvictIdleAtNs = -1L;
        }
        if (toEvict != null) {
            Lockable $this$withLock$iv = toEvict;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                block29: {
                    block28: {
                        boolean bl3 = false;
                        if (!(!((Collection)toEvict.getCalls()).isEmpty())) break block28;
                        long l = 0L;
                        return l;
                    }
                    if (toEvict.getIdleAtNs() == toEvictIdleAtNs) break block29;
                    long l = 0L;
                    return l;
                }
                toEvict.setNoNewExchanges(true);
                boolean bl4 = this.connections.remove(toEvict);
            }
            AddressState addressState = addressStates.get(toEvict.getRoute().address());
            if (addressState != null) {
                this.scheduleOpener(addressState);
            }
            _UtilJvmKt.closeQuietly(toEvict.socket());
            this.connectionListener.connectionClosed(toEvict);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
        if (earliestEvictableConnection != null) {
            return earliestEvictableIdleAtNs + this.keepAliveDurationNs - now;
        }
        if (inUseConnectionCount > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    private final boolean isEvictable(Map<Address, AddressState> addressStates, RealConnection connection) {
        AddressState addressState = addressStates.get(connection.getRoute().address());
        if (addressState == null) {
            return true;
        }
        AddressState addressState2 = addressState;
        int capacityWithoutIt = addressState2.getConcurrentCallCapacity() - connection.getAllocationLimit$okhttp();
        return capacityWithoutIt >= addressState2.getPolicy().minimumConcurrentCalls;
    }

    private final int pruneAndGetAllocationCount(RealConnection connection, long now) {
        Lockable $this$assertLockHeld$iv = connection;
        boolean $i$f$assertLockHeld = false;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertLockHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertLockHeld$iv));
        }
        List<Reference<RealCall>> references = connection.getCalls();
        int i = 0;
        while (i < references.size()) {
            Reference<RealCall> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Intrinsics.checkNotNull(reference, "null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            RealCall.CallReference callReference = (RealCall.CallReference)reference;
            String message = "A connection to " + connection.route().address().url() + " was leaked. Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message, callReference.getCallStackTrace());
            references.remove(i);
            if (!references.isEmpty()) continue;
            connection.setIdleAtNs(now - this.keepAliveDurationNs);
            return 0;
        }
        return references.size();
    }

    public final void setPolicy(@NotNull Address address, @NotNull AddressPolicy policy) {
        Map<Address, AddressState> newMap;
        Map<Address, AddressState> oldMap;
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(policy, "policy");
        AddressState state = new AddressState(address, this.taskRunner.newQueue(), policy);
        int newConnectionsNeeded = 0;
        while (!addressStatesUpdater.compareAndSet(this, oldMap = this.addressStates, newMap = MapsKt.plus(oldMap, TuplesKt.to(address, state)))) {
        }
        Object object = oldMap.get(address);
        int oldPolicyMinimumConcurrentCalls = object != null && (object = ((AddressState)object).getPolicy()) != null ? ((AddressPolicy)object).minimumConcurrentCalls : 0;
        newConnectionsNeeded = policy.minimumConcurrentCalls - oldPolicyMinimumConcurrentCalls;
        if (newConnectionsNeeded > 0) {
            this.scheduleOpener(state);
        } else if (newConnectionsNeeded < 0) {
            this.scheduleCloser();
        }
    }

    public final void scheduleOpener(@NotNull Address address) {
        block0: {
            Intrinsics.checkNotNullParameter(address, "address");
            AddressState addressState = this.addressStates.get(address);
            if (addressState == null) break block0;
            this.scheduleOpener(addressState);
        }
    }

    public final void scheduleCloser() {
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long openConnections(AddressState state) {
        if (state.getPolicy().minimumConcurrentCalls == 0) {
            return -1L;
        }
        int concurrentCallCapacity = 0;
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<RealConnection> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            RealConnection connection = iterator3.next();
            if (!Intrinsics.areEqual(state.getAddress(), connection.getRoute().address())) continue;
            Intrinsics.checkNotNull(connection);
            Lockable $this$withLock$iv = connection;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl = false;
                Unit unit = Unit.INSTANCE;
            }
            if ((concurrentCallCapacity += connection.getAllocationLimit$okhttp()) < state.getPolicy().minimumConcurrentCalls) continue;
            return -1L;
        }
        try {
            RealConnection connection = this.exchangeFinderFactory.invoke(this, state.getAddress(), PoolConnectionUser.INSTANCE).find();
            if (!this.connections.contains(connection)) {
                Lockable $this$withLock$iv = connection;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl = false;
                    this.put(connection);
                    Unit unit = Unit.INSTANCE;
                }
            }
            return 0L;
        }
        catch (IOException e) {
            return this.jitterBy(state.getPolicy().backoffDelayMillis, state.getPolicy().backoffJitterMillis) * (long)1000000;
        }
    }

    private final long jitterBy(long $this$jitterBy, int amount) {
        return $this$jitterBy + (long)ThreadLocalRandom.current().nextInt(amount * -1, amount);
    }

    public static final /* synthetic */ long access$openConnections(RealConnectionPool $this, AddressState state) {
        return $this.openConnections(state);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$AddressState;", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "address", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "queue", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/AddressPolicy;", "policy", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/AddressPolicy;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "getAddress", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "getQueue", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskQueue;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/AddressPolicy;", "getPolicy", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/AddressPolicy;", "setPolicy", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/AddressPolicy;)V", "", "concurrentCallCapacity", "I", "getConcurrentCallCapacity", "()I", "setConcurrentCallCapacity", "(I)V", "okhttp"})
    public static final class AddressState {
        @NotNull
        private final Address address;
        @NotNull
        private final TaskQueue queue;
        @NotNull
        private AddressPolicy policy;
        private int concurrentCallCapacity;

        public AddressState(@NotNull Address address, @NotNull TaskQueue queue, @NotNull AddressPolicy policy) {
            Intrinsics.checkNotNullParameter(address, "address");
            Intrinsics.checkNotNullParameter(queue, "queue");
            Intrinsics.checkNotNullParameter(policy, "policy");
            this.address = address;
            this.queue = queue;
            this.policy = policy;
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        @NotNull
        public final TaskQueue getQueue() {
            return this.queue;
        }

        @NotNull
        public final AddressPolicy getPolicy() {
            return this.policy;
        }

        public final void setPolicy(@NotNull AddressPolicy addressPolicy) {
            Intrinsics.checkNotNullParameter(addressPolicy, "<set-?>");
            this.policy = addressPolicy;
        }

        public final int getConcurrentCallCapacity() {
            return this.concurrentCallCapacity;
        }

        public final void setConcurrentCallCapacity(int n) {
            this.concurrentCallCapacity = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bRv\u0010\f\u001ab\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \n*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000b0\u000b \n*0\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \n*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000b0\u000b\u0018\u00010\t0\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool$Companion;", "", "<init>", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/ConnectionPool;", "connectionPool", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "get", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/ConnectionPool;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "kotlin.jvm.PlatformType", "", "addressStatesUpdater", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RealConnectionPool get(@NotNull ConnectionPool connectionPool) {
            Intrinsics.checkNotNullParameter(connectionPool, "connectionPool");
            return connectionPool.getDelegate$okhttp();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

