/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection;

import com.smushytaco.nickname_detector.shaded.okhttp3.Address;
import com.smushytaco.nickname_detector.shaded.okhttp3.ConnectionSpec;
import com.smushytaco.nickname_detector.shaded.okhttp3.HttpUrl;
import com.smushytaco.nickname_detector.shaded.okhttp3.Protocol;
import com.smushytaco.nickname_detector.shaded.okhttp3.Request;
import com.smushytaco.nickname_detector.shaded.okhttp3.Response;
import com.smushytaco.nickname_detector.shaded.okhttp3.Route;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.TaskRunner;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ConnectPlan;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ConnectionUser;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnectionPool;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ReusePlan;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RouteDatabase;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RoutePlanner;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RouteSelector;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\"\u001a\u00020\u001fH\u0000\u00a2\u0006\u0004\b \u0010!J/\u0010)\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001f2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$H\u0000\u00a2\u0006\u0004\b'\u0010(J)\u0010-\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020%2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$H\u0000\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010/\u001a\u00020.2\u0006\u0010*\u001a\u00020%H\u0002\u00a2\u0006\u0004\b/\u00100J\u0019\u00103\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u000101H\u0016\u00a2\u0006\u0004\b3\u00104J\u0019\u00106\u001a\u0004\u0018\u00010%2\u0006\u00105\u001a\u000201H\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u0010:\u001a\u00020\f2\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b:\u0010;R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010<R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010=R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010>R\u0014\u0010\b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010>R\u0014\u0010\t\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010>R\u0014\u0010\n\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010>R\u0014\u0010\u000b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010>R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010?R\u0014\u0010\u000e\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010?R\u001a\u0010\u0010\u001a\u00020\u000f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010@\u001a\u0004\bA\u0010BR\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010CR\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010DR\u0018\u0010F\u001a\u0004\u0018\u00010E8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0018\u0010I\u001a\u0004\u0018\u00010H8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u0018\u0010K\u001a\u0004\u0018\u00010%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR \u0010N\u001a\b\u0012\u0004\u0012\u00020\u00190M8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\u00a8\u0006R"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealRoutePlanner;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "taskRunner", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "connectionPool", "", "readTimeoutMillis", "writeTimeoutMillis", "socketConnectTimeoutMillis", "socketReadTimeoutMillis", "pingIntervalMillis", "", "retryOnConnectionFailure", "fastFallback", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "address", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RouteDatabase;", "routeDatabase", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionUser;", "connectionUser", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;IIIIIZZLcom/smushytaco/nickname_detector/shaded/okhttp3/Address;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RouteDatabase;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionUser;)V", "isCanceled", "()Z", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner$Plan;", "plan", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner$Plan;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ReusePlan;", "planReuseCallConnection", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ReusePlan;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectPlan;", "planConnect$okhttp", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectPlan;", "planConnect", "planToReplace", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;", "routes", "planReusePooledConnection$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectPlan;Ljava/util/List;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ReusePlan;", "planReusePooledConnection", "route", "planConnectToRoute$okhttp", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;Ljava/util/List;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectPlan;", "planConnectToRoute", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "createTunnelRequest", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "failedConnection", "hasNext", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;)Z", "connection", "retryRoute", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "sameHostAndPort", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;)Z", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/TaskRunner;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnectionPool;", "I", "Z", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "getAddress", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Address;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RouteDatabase;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ConnectionUser;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RouteSelector$Selection;", "routeSelection", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RouteSelector$Selection;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RouteSelector;", "routeSelector", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RouteSelector;", "nextRouteToTry", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Route;", "Lkotlin/collections/ArrayDeque;", "deferredPlans", "Lkotlin/collections/ArrayDeque;", "getDeferredPlans", "()Lkotlin/collections/ArrayDeque;", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealRoutePlanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealRoutePlanner.kt\nokhttp3/internal/connection/RealRoutePlanner\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n*L\n1#1,346:1\n63#2:347\n63#2:348\n*S KotlinDebug\n*F\n+ 1 RealRoutePlanner.kt\nokhttp3/internal/connection/RealRoutePlanner\n*L\n98#1:347\n325#1:348\n*E\n"})
public final class RealRoutePlanner
implements RoutePlanner {
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final RealConnectionPool connectionPool;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int socketConnectTimeoutMillis;
    private final int socketReadTimeoutMillis;
    private final int pingIntervalMillis;
    private final boolean retryOnConnectionFailure;
    private final boolean fastFallback;
    @NotNull
    private final Address address;
    @NotNull
    private final RouteDatabase routeDatabase;
    @NotNull
    private final ConnectionUser connectionUser;
    @Nullable
    private RouteSelector.Selection routeSelection;
    @Nullable
    private RouteSelector routeSelector;
    @Nullable
    private Route nextRouteToTry;
    @NotNull
    private final ArrayDeque<RoutePlanner.Plan> deferredPlans;

    public RealRoutePlanner(@NotNull TaskRunner taskRunner, @NotNull RealConnectionPool connectionPool, int readTimeoutMillis, int writeTimeoutMillis, int socketConnectTimeoutMillis, int socketReadTimeoutMillis, int pingIntervalMillis, boolean retryOnConnectionFailure, boolean fastFallback, @NotNull Address address, @NotNull RouteDatabase routeDatabase, @NotNull ConnectionUser connectionUser) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(connectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(routeDatabase, "routeDatabase");
        Intrinsics.checkNotNullParameter(connectionUser, "connectionUser");
        this.taskRunner = taskRunner;
        this.connectionPool = connectionPool;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.socketConnectTimeoutMillis = socketConnectTimeoutMillis;
        this.socketReadTimeoutMillis = socketReadTimeoutMillis;
        this.pingIntervalMillis = pingIntervalMillis;
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        this.fastFallback = fastFallback;
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.connectionUser = connectionUser;
        this.deferredPlans = new ArrayDeque();
    }

    @Override
    @NotNull
    public Address getAddress() {
        return this.address;
    }

    @Override
    @NotNull
    public ArrayDeque<RoutePlanner.Plan> getDeferredPlans() {
        return this.deferredPlans;
    }

    @Override
    public boolean isCanceled() {
        return this.connectionUser.isCanceled();
    }

    @Override
    @NotNull
    public RoutePlanner.Plan plan() throws IOException {
        ReusePlan pooled2;
        ReusePlan pooled1;
        ReusePlan reuseCallConnection;
        ReusePlan reusePlan = reuseCallConnection = this.planReuseCallConnection();
        if (reusePlan != null) {
            return reusePlan;
        }
        ReusePlan reusePlan2 = pooled1 = RealRoutePlanner.planReusePooledConnection$okhttp$default(this, null, null, 3, null);
        if (reusePlan2 != null) {
            return reusePlan2;
        }
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return this.getDeferredPlans().removeFirst();
        }
        ConnectPlan connect2 = this.planConnect$okhttp();
        ReusePlan reusePlan3 = pooled2 = this.planReusePooledConnection$okhttp(connect2, connect2.getRoutes$okhttp());
        if (reusePlan3 != null) {
            return reusePlan3;
        }
        return connect2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ReusePlan planReuseCallConnection() {
        Socket socket;
        RealConnection realConnection = this.connectionUser.candidateConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection candidate = realConnection;
        boolean healthy = candidate.isHealthy(this.connectionUser.doExtensiveHealthChecks());
        boolean noNewExchangesEvent = false;
        Lockable $this$withLock$iv = candidate;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            Socket socket2;
            boolean bl = false;
            if (!healthy) {
                noNewExchangesEvent = !candidate.getNoNewExchanges();
                candidate.setNoNewExchanges(true);
                socket2 = this.connectionUser.releaseConnectionNoEvents();
            } else {
                socket2 = candidate.getNoNewExchanges() || !this.sameHostAndPort(candidate.route().address().url()) ? this.connectionUser.releaseConnectionNoEvents() : null;
            }
            socket = socket2;
        }
        Socket toClose = socket;
        if (this.connectionUser.candidateConnection() != null) {
            if (!(toClose == null)) {
                throw new IllegalStateException("Check failed.");
            }
            return new ReusePlan(candidate);
        }
        Socket socket3 = toClose;
        if (socket3 != null) {
            _UtilJvmKt.closeQuietly(socket3);
        }
        this.connectionUser.connectionReleased(candidate);
        this.connectionUser.connectionConnectionReleased(candidate);
        if (toClose != null) {
            this.connectionUser.connectionConnectionClosed(candidate);
        } else if (noNewExchangesEvent) {
            this.connectionUser.noNewExchanges(candidate);
        }
        return null;
    }

    @NotNull
    public final ConnectPlan planConnect$okhttp() throws IOException {
        RouteSelector.Selection newRouteSelection;
        Route localNextRouteToTry = this.nextRouteToTry;
        if (localNextRouteToTry != null) {
            this.nextRouteToTry = null;
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, localNextRouteToTry, null, 2, null);
        }
        RouteSelector.Selection existingRouteSelection = this.routeSelection;
        if (existingRouteSelection != null && existingRouteSelection.hasNext()) {
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, existingRouteSelection.next(), null, 2, null);
        }
        RouteSelector newRouteSelector = this.routeSelector;
        if (newRouteSelector == null) {
            this.routeSelector = newRouteSelector = new RouteSelector(this.getAddress(), this.routeDatabase, this.connectionUser, this.fastFallback);
        }
        if (!newRouteSelector.hasNext()) {
            throw new IOException("exhausted all routes");
        }
        this.routeSelection = newRouteSelection = newRouteSelector.next();
        if (this.isCanceled()) {
            throw new IOException("Canceled");
        }
        return this.planConnectToRoute$okhttp(newRouteSelection.next(), newRouteSelection.getRoutes());
    }

    @Nullable
    public final ReusePlan planReusePooledConnection$okhttp(@Nullable ConnectPlan planToReplace, @Nullable List<Route> routes) {
        RealConnection realConnection = this.connectionPool.callAcquirePooledConnection(this.connectionUser.doExtensiveHealthChecks(), this.getAddress(), this.connectionUser, routes, planToReplace != null && planToReplace.isReady());
        if (realConnection == null) {
            return null;
        }
        RealConnection result = realConnection;
        if (planToReplace != null) {
            this.nextRouteToTry = planToReplace.getRoute();
            planToReplace.closeQuietly();
        }
        this.connectionUser.connectionAcquired(result);
        this.connectionUser.connectionConnectionAcquired(result);
        return new ReusePlan(result);
    }

    public static /* synthetic */ ReusePlan planReusePooledConnection$okhttp$default(RealRoutePlanner realRoutePlanner, ConnectPlan connectPlan, List list, int n, Object object) {
        if ((n & 1) != 0) {
            connectPlan = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planReusePooledConnection$okhttp(connectPlan, list);
    }

    @NotNull
    public final ConnectPlan planConnectToRoute$okhttp(@NotNull Route route, @Nullable List<Route> routes) throws IOException {
        Intrinsics.checkNotNullParameter(route, "route");
        if (route.address().sslSocketFactory() == null) {
            if (!route.address().connectionSpecs().contains(ConnectionSpec.CLEARTEXT)) {
                throw new UnknownServiceException("CLEARTEXT communication not enabled for client");
            }
            String host = route.address().url().host();
            if (!Platform.Companion.get().isCleartextTrafficPermitted(host)) {
                throw new UnknownServiceException("CLEARTEXT communication to " + host + " not permitted by network security policy");
            }
        } else if (route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS");
        }
        Request tunnelRequest = route.requiresTunnel() ? this.createTunnelRequest(route) : null;
        return new ConnectPlan(this.taskRunner, this.connectionPool, this.readTimeoutMillis, this.writeTimeoutMillis, this.socketConnectTimeoutMillis, this.socketReadTimeoutMillis, this.pingIntervalMillis, this.retryOnConnectionFailure, this.connectionUser, this, route, routes, 0, tunnelRequest, -1, false);
    }

    public static /* synthetic */ ConnectPlan planConnectToRoute$okhttp$default(RealRoutePlanner realRoutePlanner, Route route, List list, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planConnectToRoute$okhttp(route, list);
    }

    private final Request createTunnelRequest(Route route) throws IOException {
        Request proxyConnectRequest = new Request.Builder().url(route.address().url()).method("CONNECT", null).header("Host", _UtilJvmKt.toHostHeader(route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/5.2.0").build();
        Response fakeAuthChallengeResponse = new Response.Builder().request(proxyConnectRequest).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Request authenticatedRequest = route.address().proxyAuthenticator().authenticate(route, fakeAuthChallengeResponse);
        Request request = authenticatedRequest;
        if (request == null) {
            request = proxyConnectRequest;
        }
        return request;
    }

    @Override
    public boolean hasNext(@Nullable RealConnection failedConnection) {
        Route retryRoute;
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return true;
        }
        if (this.nextRouteToTry != null) {
            return true;
        }
        if (failedConnection != null && (retryRoute = this.retryRoute(failedConnection)) != null) {
            this.nextRouteToTry = retryRoute;
            return true;
        }
        RouteSelector.Selection selection = this.routeSelection;
        boolean bl = selection != null ? selection.hasNext() : false;
        if (bl) {
            return true;
        }
        RouteSelector routeSelector = this.routeSelector;
        if (routeSelector == null) {
            return true;
        }
        RouteSelector localRouteSelector = routeSelector;
        return localRouteSelector.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Route retryRoute(RealConnection connection) {
        Route route;
        Lockable $this$withLock$iv = connection;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            route = connection.getRouteFailureCount$okhttp() != 0 ? null : (!connection.getNoNewExchanges() ? null : (!_UtilJvmKt.canReuseConnectionFor(connection.route().address().url(), this.getAddress().url()) ? null : connection.route()));
        }
        return route;
    }

    @Override
    public boolean sameHostAndPort(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter(url, "url");
        HttpUrl routeUrl = this.getAddress().url();
        return url.port() == routeUrl.port() && Intrinsics.areEqual(url.host(), routeUrl.host());
    }
}

