/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.ExchangeFinder;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RoutePlanner;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/SequentialExchangeFinder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/ExchangeFinder;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;", "routePlanner", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "find", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealConnection;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;", "getRoutePlanner", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RoutePlanner;", "okhttp"})
public final class SequentialExchangeFinder
implements ExchangeFinder {
    @NotNull
    private final RoutePlanner routePlanner;

    public SequentialExchangeFinder(@NotNull RoutePlanner routePlanner) {
        Intrinsics.checkNotNullParameter(routePlanner, "routePlanner");
        this.routePlanner = routePlanner;
    }

    @Override
    @NotNull
    public RoutePlanner getRoutePlanner() {
        return this.routePlanner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public RealConnection find() {
        IOException firstException = null;
        while (true) {
            if (this.getRoutePlanner().isCanceled()) {
                throw new IOException("Canceled");
            }
            try {
                Throwable failure;
                RoutePlanner.Plan plan = this.getRoutePlanner().plan();
                if (plan.isReady()) return plan.handleSuccess();
                RoutePlanner.ConnectResult tcpConnectResult = plan.connectTcp();
                RoutePlanner.ConnectResult connectResult = tcpConnectResult.isSuccess() ? plan.connectTlsEtc() : tcpConnectResult;
                RoutePlanner.Plan nextPlan = connectResult.component2();
                Throwable throwable = failure = connectResult.component3();
                if (throwable != null) {
                    throw throwable;
                }
                if (nextPlan == null) return plan.handleSuccess();
                this.getRoutePlanner().getDeferredPlans().addFirst(nextPlan);
                continue;
            }
            catch (IOException e) {
                if (firstException == null) {
                    firstException = e;
                } else {
                    ExceptionsKt.addSuppressed(firstException, e);
                }
                if (!RoutePlanner.hasNext$default(this.getRoutePlanner(), null, 1, null)) throw firstException;
                continue;
            }
            break;
        }
    }
}

