/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http;

import com.smushytaco.nickname_detector.shaded.okhttp3.HttpUrl;
import com.smushytaco.nickname_detector.shaded.okhttp3.Interceptor;
import com.smushytaco.nickname_detector.shaded.okhttp3.OkHttpClient;
import com.smushytaco.nickname_detector.shaded.okhttp3.Request;
import com.smushytaco.nickname_detector.shaded.okhttp3.RequestBody;
import com.smushytaco.nickname_detector.shaded.okhttp3.Response;
import com.smushytaco.nickname_detector.shaded.okhttp3.Route;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.UnreadableResponseBodyKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilCommonKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.Exchange;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealCall;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.RealConnection;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.HttpMethod;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.RealInterceptorChain;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.ConnectionShutdownException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J#\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010$\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010&\u00a8\u0006("}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/RetryAndFollowUpInterceptor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;", "client", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor$Chain;", "chain", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "intercept", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Interceptor$Chain;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "Ljava/io/IOException;", "e", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealCall;", "call", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "userRequest", "", "recover", "(Ljava/io/IOException;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/RealCall;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)Z", "requestIsOneShot", "(Ljava/io/IOException;Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)Z", "requestSendStarted", "isRecoverable", "(Ljava/io/IOException;Z)Z", "userResponse", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/Exchange;", "exchange", "followUpRequest", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/Exchange;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "", "method", "buildRedirectRequest", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;Ljava/lang/String;)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "", "defaultDelay", "retryAfter", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;I)I", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;", "Companion", "okhttp"})
public final class RetryAndFollowUpInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    private static final int MAX_FOLLOW_UPS = 20;

    public RetryAndFollowUpInterceptor(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter(chain, "chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Request request = ((RealInterceptorChain)chain).getRequest$okhttp();
        RealCall call = realChain.getCall$okhttp();
        int followUpCount = 0;
        Response priorResponse = null;
        boolean newRoutePlanner = true;
        List<Object> recoveredFailures = CollectionsKt.emptyList();
        while (true) {
            call.enterNetworkInterceptorExchange(request, newRoutePlanner, (RealInterceptorChain)chain);
            Response response = null;
            boolean closeActiveExchange = true;
            if (call.isCanceled()) {
                throw new IOException("Canceled");
            }
            try {
                response = realChain.proceed(request);
                newRoutePlanner = true;
            }
            catch (IOException e) {
                boolean isRecoverable = this.recover(e, call, request);
                call.getEventListener$okhttp().retryDecision(call, e, isRecoverable);
                if (!isRecoverable) {
                    throw _UtilCommonKt.withSuppressed(e, recoveredFailures);
                }
                recoveredFailures = CollectionsKt.plus((Collection)recoveredFailures, e);
                newRoutePlanner = false;
                call.exitNetworkInterceptorExchange$okhttp(closeActiveExchange);
            }
            try {
                Response response2 = priorResponse;
                response = response.newBuilder().request(request).priorResponse(response2 != null ? UnreadableResponseBodyKt.stripBody(response2) : null).build();
                Exchange exchange = call.getInterceptorScopedExchange$okhttp();
                Request followUp = this.followUpRequest(response, exchange);
                if (followUp == null) {
                    if (exchange != null && exchange.isDuplex$okhttp()) {
                        call.timeoutEarlyExit();
                    }
                    closeActiveExchange = false;
                    call.getEventListener$okhttp().followUpDecision(call, response, null);
                    Response response3 = response;
                    return response3;
                }
                RequestBody followUpBody = followUp.body();
                if (followUpBody != null && followUpBody.isOneShot()) {
                    closeActiveExchange = false;
                    call.getEventListener$okhttp().followUpDecision(call, response, null);
                    Response response4 = response;
                    return response4;
                }
                _UtilCommonKt.closeQuietly(response.body());
                if (++followUpCount > 20) {
                    call.getEventListener$okhttp().followUpDecision(call, response, null);
                    throw new ProtocolException("Too many follow-up requests: " + followUpCount);
                }
                call.getEventListener$okhttp().followUpDecision(call, response, followUp);
                request = followUp;
                priorResponse = response;
                continue;
            }
            finally {
                call.exitNetworkInterceptorExchange$okhttp(closeActiveExchange);
                continue;
            }
            break;
        }
    }

    private final boolean recover(IOException e, RealCall call, Request userRequest) {
        boolean requestSendStarted;
        boolean bl = requestSendStarted = !(e instanceof ConnectionShutdownException);
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (requestSendStarted && this.requestIsOneShot(e, userRequest)) {
            return false;
        }
        if (!this.isRecoverable(e, requestSendStarted)) {
            return false;
        }
        return call.retryAfterFailure();
    }

    private final boolean requestIsOneShot(IOException e, Request userRequest) {
        RequestBody requestBody = userRequest.body();
        return requestBody != null && requestBody.isOneShot() || e instanceof FileNotFoundException;
    }

    private final boolean isRecoverable(IOException e, boolean requestSendStarted) {
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return e instanceof SocketTimeoutException && !requestSendStarted;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e instanceof SSLPeerUnverifiedException);
    }

    private final Request followUpRequest(Response userResponse, Exchange exchange) throws IOException {
        Object object = exchange;
        Route route = object != null && (object = ((Exchange)object).getConnection$okhttp()) != null ? ((RealConnection)object).route() : null;
        int responseCode = userResponse.code();
        String method = userResponse.request().method();
        switch (responseCode) {
            case 407: {
                Route route2 = route;
                Intrinsics.checkNotNull(route2);
                Proxy selectedProxy = route2.proxy();
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, userResponse);
            }
            case 401: {
                return this.client.authenticator().authenticate(route, userResponse);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return this.buildRedirectRequest(userResponse, method);
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 408) {
                    return null;
                }
                if (this.retryAfter(userResponse, 0) > 0) {
                    return null;
                }
                return userResponse.request();
            }
            case 503: {
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 503) {
                    return null;
                }
                if (this.retryAfter(userResponse, Integer.MAX_VALUE) == 0) {
                    return userResponse.request();
                }
                return null;
            }
            case 421: {
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                if (exchange == null || !exchange.isCoalescedConnection$okhttp()) {
                    return null;
                }
                exchange.getConnection$okhttp().noCoalescedConnections$okhttp();
                return userResponse.request();
            }
        }
        return null;
    }

    private final Request buildRedirectRequest(Response userResponse, String method) {
        if (!this.client.followRedirects()) {
            return null;
        }
        String string = Response.header$default(userResponse, "Location", null, 2, null);
        if (string == null) {
            return null;
        }
        String location = string;
        HttpUrl httpUrl = userResponse.request().url().resolve(location);
        if (httpUrl == null) {
            return null;
        }
        HttpUrl url = httpUrl;
        boolean sameScheme = Intrinsics.areEqual(url.scheme(), userResponse.request().url().scheme());
        if (!sameScheme && !this.client.followSslRedirects()) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        if (HttpMethod.permitsRequestBody(method)) {
            Request.Builder builder;
            boolean maintainBody;
            int responseCode = userResponse.code();
            boolean bl = maintainBody = HttpMethod.INSTANCE.redirectsWithBody(method) || responseCode == 308 || responseCode == 307;
            if (HttpMethod.INSTANCE.redirectsToGet(method) && responseCode != 308 && responseCode != 307) {
                builder = requestBuilder.method("GET", null);
            } else {
                RequestBody requestBody = maintainBody ? userResponse.request().body() : null;
                builder = requestBuilder.method(method, requestBody);
            }
            if (!maintainBody) {
                requestBuilder.removeHeader("Transfer-Encoding");
                requestBuilder.removeHeader("Content-Length");
                requestBuilder.removeHeader("Content-Type");
            }
        }
        if (!_UtilJvmKt.canReuseConnectionFor(userResponse.request().url(), url)) {
            requestBuilder.removeHeader("Authorization");
        }
        return requestBuilder.url(url).build();
    }

    private final int retryAfter(Response userResponse, int defaultDelay) {
        String string = Response.header$default(userResponse, "Retry-After", null, 2, null);
        if (string == null) {
            return defaultDelay;
        }
        String header = string;
        CharSequence charSequence = header;
        if (new Regex("\\d+").matches(charSequence)) {
            Integer n = Integer.valueOf(header);
            Intrinsics.checkNotNullExpressionValue(n, "valueOf(...)");
            return ((Number)n).intValue();
        }
        return Integer.MAX_VALUE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/RetryAndFollowUpInterceptor$Companion;", "", "<init>", "()V", "", "MAX_FOLLOW_UPS", "I", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

