/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http1;

import com.smushytaco.nickname_detector.shaded.okhttp3.CookieJar;
import com.smushytaco.nickname_detector.shaded.okhttp3.Headers;
import com.smushytaco.nickname_detector.shaded.okhttp3.HttpUrl;
import com.smushytaco.nickname_detector.shaded.okhttp3.OkHttpClient;
import com.smushytaco.nickname_detector.shaded.okhttp3.Request;
import com.smushytaco.nickname_detector.shaded.okhttp3.RequestBody;
import com.smushytaco.nickname_detector.shaded.okhttp3.Response;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilCommonKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.connection.BufferedSocket;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.ExchangeCodec;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.HttpHeaders;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.RequestLine;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http.StatusLine;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http1.HeadersReader;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 Q2\u00020\u0001:\u0007RSTUVWQB!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b \u0010\u0013J\u000f\u0010!\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b!\u0010\u0013J\u001d\u0010%\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b.\u0010-J\u001f\u00102\u001a\u00020\u001a2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020\u001a2\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020\u001a2\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b6\u00105J\u0017\u00109\u001a\u00020\u00112\u0006\u00108\u001a\u000207H\u0002\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010;\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b;\u0010<R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010=R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010>\u001a\u0004\b?\u0010@R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010A\u001a\u0004\bB\u0010CR\u0016\u0010E\u001a\u00020D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u0014\u0010H\u001a\u00020G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0018\u0010J\u001a\u00020'*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0018\u0010J\u001a\u00020'*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010LR\u0018\u0010M\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0014\u0010O\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006X"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;", "client", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;", "carrier", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "socket", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;", "request", "", "contentLength", "Lokio/Sink;", "createRequestBody", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;J)Lokio/Sink;", "", "cancel", "()V", "writeRequestHeaders", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;", "response", "reportedContentLength", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)J", "Lokio/Source;", "openResponseBodySource", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Lokio/Source;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "peekTrailers", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "flushRequest", "finishRequest", "headers", "", "requestLine", "writeRequest", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;Ljava/lang/String;)V", "", "expectContinue", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response$Builder;", "readResponseHeaders", "(Z)Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response$Builder;", "newChunkedSink", "()Lokio/Sink;", "newKnownLengthSink", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "length", "newFixedLengthSource", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;J)Lokio/Source;", "newChunkedSource", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;)Lokio/Source;", "newUnknownLengthSource", "Lokio/ForwardingTimeout;", "timeout", "detachTimeout", "(Lokio/ForwardingTimeout;)V", "skipConnectBody", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/OkHttpClient;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;", "getCarrier", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http/ExchangeCodec$Carrier;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "getSocket", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/connection/BufferedSocket;", "", "state", "I", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/HeadersReader;", "headersReader", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/HeadersReader;", "isChunked", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Response;)Z", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Request;)Z", "trailers", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "isResponseComplete", "()Z", "Companion", "KnownLengthSink", "ChunkedSink", "AbstractSource", "FixedLengthSource", "ChunkedSource", "UnknownLengthSource", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n1#2:563\n*E\n"})
public final class Http1ExchangeCodec
implements ExchangeCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final OkHttpClient client;
    @NotNull
    private final ExchangeCodec.Carrier carrier;
    @NotNull
    private final BufferedSocket socket;
    private int state;
    @NotNull
    private final HeadersReader headersReader;
    @Nullable
    private Headers trailers;
    private static final long NO_CHUNK_YET = -1L;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    @NotNull
    private static final Headers TRAILERS_RESPONSE_BODY_TRUNCATED;

    public Http1ExchangeCodec(@Nullable OkHttpClient client, @NotNull ExchangeCodec.Carrier carrier, @NotNull BufferedSocket socket) {
        Intrinsics.checkNotNullParameter(carrier, "carrier");
        Intrinsics.checkNotNullParameter(socket, "socket");
        this.client = client;
        this.carrier = carrier;
        this.socket = socket;
        this.headersReader = new HeadersReader(this.getSocket().getSource());
    }

    @Override
    @NotNull
    public ExchangeCodec.Carrier getCarrier() {
        return this.carrier;
    }

    @Override
    @NotNull
    public BufferedSocket getSocket() {
        return this.socket;
    }

    private final boolean isChunked(Response $this$isChunked) {
        return StringsKt.equals("chunked", Response.header$default($this$isChunked, "Transfer-Encoding", null, 2, null), true);
    }

    private final boolean isChunked(Request $this$isChunked) {
        return StringsKt.equals("chunked", $this$isChunked.header("Transfer-Encoding"), true);
    }

    @Override
    public boolean isResponseComplete() {
        return this.state == 6;
    }

    @Override
    @NotNull
    public Sink createRequestBody(@NotNull Request request, long contentLength) {
        Sink sink2;
        Intrinsics.checkNotNullParameter(request, "request");
        RequestBody requestBody = request.body();
        boolean bl = requestBody != null ? requestBody.isDuplex() : false;
        if (bl) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if (this.isChunked(request)) {
            sink2 = this.newChunkedSink();
        } else if (contentLength != -1L) {
            sink2 = this.newKnownLengthSink();
        } else {
            throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
        }
        return sink2;
    }

    @Override
    public void cancel() {
        this.getCarrier().cancel();
    }

    @Override
    public void writeRequestHeaders(@NotNull Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Proxy.Type type = this.getCarrier().getRoute().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)type, "type(...)");
        String requestLine = RequestLine.INSTANCE.get(request, type);
        this.writeRequest(request.headers(), requestLine);
    }

    @Override
    public long reportedContentLength(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return !HttpHeaders.promisesBody(response) ? 0L : (this.isChunked(response) ? -1L : _UtilJvmKt.headersContentLength(response));
    }

    @Override
    @NotNull
    public Source openResponseBodySource(@NotNull Response response) {
        long contentLength;
        Intrinsics.checkNotNullParameter(response, "response");
        return !HttpHeaders.promisesBody(response) ? this.newFixedLengthSource(response.request().url(), 0L) : (this.isChunked(response) ? this.newChunkedSource(response.request().url()) : ((contentLength = _UtilJvmKt.headersContentLength(response)) != -1L ? this.newFixedLengthSource(response.request().url(), contentLength) : this.newUnknownLengthSource(response.request().url())));
    }

    @Override
    @Nullable
    public Headers peekTrailers() {
        if (this.trailers == TRAILERS_RESPONSE_BODY_TRUNCATED) {
            throw new IOException("Trailers cannot be read because the response body was truncated");
        }
        if (!(this.state == 5 || this.state == 6)) {
            boolean bl = false;
            String string = "Trailers cannot be read because the state is " + this.state;
            throw new IllegalStateException(string.toString());
        }
        return this.trailers;
    }

    @Override
    public void flushRequest() {
        this.getSocket().getSink().flush();
    }

    @Override
    public void finishRequest() {
        this.getSocket().getSink().flush();
    }

    public final void writeRequest(@NotNull Headers headers, @NotNull String requestLine) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(requestLine, "requestLine");
        if (!(this.state == 0)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.getSocket().getSink().writeUtf8(requestLine).writeUtf8("\r\n");
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            this.getSocket().getSink().writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.getSocket().getSink().writeUtf8("\r\n");
        this.state = 1;
    }

    @Override
    @Nullable
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        if (!(this.state == 0 || this.state == 1 || this.state == 2 || this.state == 3)) {
            boolean $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = false;
            String $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = "state: " + this.state;
            throw new IllegalStateException($i$a$-check-Http1ExchangeCodec$readResponseHeaders$22.toString());
        }
        try {
            Response.Builder builder;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response.Builder responseBuilder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders());
            if (expectContinue && statusLine.code == 100) {
                builder = null;
            } else if (statusLine.code == 100) {
                this.state = 3;
                builder = responseBuilder;
            } else {
                int n = statusLine.code;
                boolean bl = 102 <= n ? n < 200 : false;
                if (bl) {
                    this.state = 3;
                    builder = responseBuilder;
                } else {
                    this.state = 4;
                    builder = responseBuilder;
                }
            }
            return builder;
        }
        catch (EOFException e) {
            String address = this.getCarrier().getRoute().address().url().redact();
            throw new IOException("unexpected end of stream on " + address, e);
        }
    }

    private final Sink newChunkedSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new ChunkedSink();
    }

    private final Sink newKnownLengthSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new KnownLengthSink();
    }

    private final Source newFixedLengthSource(HttpUrl url, long length) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new FixedLengthSource(url, length);
    }

    private final Source newChunkedSource(HttpUrl url) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new ChunkedSource(url);
    }

    private final Source newUnknownLengthSource(HttpUrl url) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        this.getCarrier().noNewExchanges();
        return new UnknownLengthSource(url);
    }

    private final void detachTimeout(ForwardingTimeout timeout2) {
        Timeout oldDelegate = timeout2.delegate();
        timeout2.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        oldDelegate.clearTimeout();
    }

    public final void skipConnectBody(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        long contentLength = _UtilJvmKt.headersContentLength(response);
        if (contentLength == -1L) {
            return;
        }
        Source body = this.newFixedLengthSource(response.request().url(), contentLength);
        _UtilJvmKt.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        body.close();
    }

    static {
        String[] stringArray = new String[]{"OkHttp-Response-Body", "Truncated"};
        TRAILERS_RESPONSE_BODY_TRUNCATED = Headers.Companion.of(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\u00178\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokio/Source;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;)V", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "trailers", "", "responseBodyComplete", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;)V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "getUrl", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "Lokio/ForwardingTimeout;", "Lokio/ForwardingTimeout;", "getTimeout", "()Lokio/ForwardingTimeout;", "", "closed", "Z", "getClosed", "()Z", "setClosed", "(Z)V", "okhttp"})
    private abstract class AbstractSource
    implements Source {
        @NotNull
        private final HttpUrl url;
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public AbstractSource(HttpUrl url) {
            Intrinsics.checkNotNullParameter(url, "url");
            this.url = url;
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.getSocket().getSource().timeout());
        }

        @NotNull
        public final HttpUrl getUrl() {
            return this.url;
        }

        @NotNull
        protected final ForwardingTimeout getTimeout() {
            return this.timeout;
        }

        protected final boolean getClosed() {
            return this.closed;
        }

        protected final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter(sink2, "sink");
            try {
                l = Http1ExchangeCodec.this.getSocket().getSource().read(sink2, byteCount);
            }
            catch (IOException e) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                this.responseBodyComplete(TRAILERS_RESPONSE_BODY_TRUNCATED);
                throw e;
            }
            return l;
        }

        public final void responseBodyComplete(@NotNull Headers trailers) {
            block2: {
                Object object;
                Intrinsics.checkNotNullParameter(trailers, "trailers");
                if (Http1ExchangeCodec.this.state == 6) {
                    return;
                }
                if (Http1ExchangeCodec.this.state != 5) {
                    throw new IllegalStateException("state: " + Http1ExchangeCodec.this.state);
                }
                Http1ExchangeCodec.this.detachTimeout(this.timeout);
                Http1ExchangeCodec.this.trailers = trailers;
                Http1ExchangeCodec.this.state = 6;
                if (trailers.size() <= 0 || (object = Http1ExchangeCodec.this.client) == null || (object = ((OkHttpClient)object).cookieJar()) == null) break block2;
                HttpHeaders.receiveHeaders((CookieJar)object, this.url, trailers);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink;", "Lokio/Sink;", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;)V", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "Lokio/Buffer;", "source", "", "byteCount", "", "write", "(Lokio/Buffer;J)V", "flush", "()V", "close", "Lokio/ForwardingTimeout;", "Lokio/ForwardingTimeout;", "", "closed", "Z", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n1#2:563\n*E\n"})
    private final class ChunkedSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.getSocket().getSink().timeout());
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter(source2, "source");
            if (!(!this.closed)) {
                boolean $i$a$-check-Http1ExchangeCodec$ChunkedSink$write$22 = false;
                String $i$a$-check-Http1ExchangeCodec$ChunkedSink$write$22 = "closed";
                throw new IllegalStateException($i$a$-check-Http1ExchangeCodec$ChunkedSink$write$22.toString());
            }
            if (byteCount == 0L) {
                return;
            }
            BufferedSink $this$write_u24lambda_u241 = Http1ExchangeCodec.this.getSocket().getSink();
            boolean bl = false;
            $this$write_u24lambda_u241.writeHexadecimalUnsignedLong(byteCount);
            $this$write_u24lambda_u241.writeUtf8("\r\n");
            $this$write_u24lambda_u241.write(source2, byteCount);
            $this$write_u24lambda_u241.writeUtf8("\r\n");
        }

        @Override
        public synchronized void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.getSocket().getSink().flush();
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.getSocket().getSink().writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;)V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "", "readChunkSize", "()V", "close", "bytesRemainingInChunk", "J", "", "hasMoreChunks", "Z", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n1#2:563\n*E\n"})
    private final class ChunkedSource
    extends AbstractSource {
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        public ChunkedSource(HttpUrl url) {
            Intrinsics.checkNotNullParameter(url, "url");
            super(url);
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            long read;
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read = super.read(sink2, Math.min(byteCount, this.bytesRemainingInChunk))) == -1L) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete(TRAILERS_RESPONSE_BODY_TRUNCATED);
                throw e;
            }
            this.bytesRemainingInChunk -= read;
            return read;
        }

        private final void readChunkSize() {
            if (this.bytesRemainingInChunk != -1L) {
                Http1ExchangeCodec.this.getSocket().getSource().readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1ExchangeCodec.this.getSocket().getSource().readHexadecimalUnsignedLong();
                String extensions = ((Object)StringsKt.trim((CharSequence)Http1ExchangeCodec.this.getSocket().getSource().readUtf8LineStrict())).toString();
                if (this.bytesRemainingInChunk < 0L || ((CharSequence)extensions).length() > 0 && !StringsKt.startsWith$default(extensions, ";", false, 2, null)) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + extensions + '\"');
                }
            }
            catch (NumberFormatException e) {
                throw new ProtocolException(e.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Headers trailers = Http1ExchangeCodec.this.headersReader.readHeaders();
                this.responseBodyComplete(trailers);
            }
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.hasMoreChunks && !_UtilJvmKt.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                this.responseBodyComplete(TRAILERS_RESPONSE_BODY_TRUNCATED);
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\tR\u0014\u0010\u000f\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$Companion;", "", "<init>", "()V", "", "NO_CHUNK_YET", "J", "", "STATE_IDLE", "I", "STATE_OPEN_REQUEST_BODY", "STATE_WRITING_REQUEST_BODY", "STATE_READ_RESPONSE_HEADERS", "STATE_OPEN_RESPONSE_BODY", "STATE_READING_RESPONSE_BODY", "STATE_CLOSED", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "TRAILERS_RESPONSE_BODY_TRUNCATED", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/Headers;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "", "bytesRemaining", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;J)V", "Lokio/Buffer;", "sink", "byteCount", "read", "(Lokio/Buffer;J)J", "", "close", "()V", "J", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n1#2:563\n*E\n"})
    private final class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        public FixedLengthSource(HttpUrl url, long bytesRemaining) {
            Intrinsics.checkNotNullParameter(url, "url");
            super(url);
            this.bytesRemaining = bytesRemaining;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete(Headers.EMPTY);
            }
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read = super.read(sink2, Math.min(this.bytesRemaining, byteCount));
            if (read == -1L) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete(TRAILERS_RESPONSE_BODY_TRUNCATED);
                throw e;
            }
            this.bytesRemaining -= read;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete(Headers.EMPTY);
            }
            return read;
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.bytesRemaining != 0L && !_UtilJvmKt.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                this.responseBodyComplete(TRAILERS_RESPONSE_BODY_TRUNCATED);
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink;", "Lokio/Sink;", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;)V", "Lokio/Timeout;", "timeout", "()Lokio/Timeout;", "Lokio/Buffer;", "source", "", "byteCount", "", "write", "(Lokio/Buffer;J)V", "flush", "()V", "close", "Lokio/ForwardingTimeout;", "Lokio/ForwardingTimeout;", "", "closed", "Z", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n1#2:563\n*E\n"})
    private final class KnownLengthSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public KnownLengthSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.getSocket().getSink().timeout());
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter(source2, "source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            _UtilCommonKt.checkOffsetAndCount(source2.size(), 0L, byteCount);
            Http1ExchangeCodec.this.getSocket().getSink().write(source2, byteCount);
        }

        @Override
        public void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.getSocket().getSink().flush();
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;", "url", "<init>", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http1/Http1ExchangeCodec;Lcom/smushytaco/nickname_detector/shaded/okhttp3/HttpUrl;)V", "Lokio/Buffer;", "sink", "", "byteCount", "read", "(Lokio/Buffer;J)J", "", "close", "()V", "", "inputExhausted", "Z", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n1#2:563\n*E\n"})
    private final class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        public UnknownLengthSource(HttpUrl url) {
            Intrinsics.checkNotNullParameter(url, "url");
            super(url);
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read = super.read(sink2, byteCount);
            if (read == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete(Headers.EMPTY);
                return -1L;
            }
            return read;
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete(TRAILERS_RESPONSE_BODY_TRUNCATED);
            }
            this.setClosed(true);
        }
    }
}

