/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilCommonKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal._UtilJvmKt;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.concurrent.Lockable;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.ErrorCode;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Header;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Hpack;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Http2;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.http2.Settings;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u000bJ\u001d\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eJ/\u0010#\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020\u0010\u00a2\u0006\u0004\b#\u0010$J/\u0010'\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020\u0010\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010)\u001a\u00020\t2\u0006\u0010)\u001a\u00020\f\u00a2\u0006\u0004\b)\u0010\u000fJ%\u0010-\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010\u00a2\u0006\u0004\b-\u0010.J%\u00102\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u00101\u001a\u000200\u00a2\u0006\u0004\b2\u00103J\u001d\u00106\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107J-\u0010:\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b<\u0010\u000bJ\u001f\u0010=\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\"\u001a\u000204H\u0002\u00a2\u0006\u0004\b=\u00107J+\u0010?\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b?\u0010@R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010AR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010BR\u0014\u0010C\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0016\u0010E\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u0016\u0010G\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010BR\u0017\u0010I\u001a\u00020H8\u0006\u00a2\u0006\f\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\u00a8\u0006N"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Writer;", "Ljava/io/Closeable;", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/concurrent/Lockable;", "Lokio/BufferedSink;", "sink", "", "client", "<init>", "(Lokio/BufferedSink;Z)V", "", "connectionPreface", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;", "peerSettings", "applyAndAckSettings", "(Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Settings;)V", "", "streamId", "promisedStreamId", "", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Header;", "requestHeaders", "pushPromise", "(IILjava/util/List;)V", "flush", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;", "errorCode", "rstStream", "(ILcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;)V", "maxDataLength", "()I", "outFinished", "Lokio/Buffer;", "source", "byteCount", "data", "(ZILokio/Buffer;I)V", "flags", "buffer", "dataFrame", "(IILokio/Buffer;I)V", "settings", "ack", "payload1", "payload2", "ping", "(ZII)V", "lastGoodStreamId", "", "debugData", "goAway", "(ILcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/ErrorCode;[B)V", "", "windowSizeIncrement", "windowUpdate", "(IJ)V", "length", "type", "frameHeader", "(IIII)V", "close", "writeContinuationFrames", "headerBlock", "headers", "(ZILjava/util/List;)V", "Lokio/BufferedSink;", "Z", "hpackBuffer", "Lokio/Buffer;", "maxFrameSize", "I", "closed", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Hpack$Writer;", "hpackWriter", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Hpack$Writer;", "getHpackWriter", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Hpack$Writer;", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Writer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Writer.kt\nokhttp3/internal/http2/Http2Writer\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,384:1\n63#2:385\n63#2:386\n63#2:387\n63#2:388\n63#2:389\n63#2:390\n63#2:391\n63#2:392\n63#2:393\n63#2:395\n63#2:396\n63#2:397\n1#3:394\n*S KotlinDebug\n*F\n+ 1 Http2Writer.kt\nokhttp3/internal/http2/Http2Writer\n*L\n60#1:385\n74#1:386\n108#1:387\n129#1:388\n140#1:389\n172#1:390\n201#1:391\n228#1:392\n256#1:393\n283#1:395\n329#1:396\n360#1:397\n*E\n"})
public final class Http2Writer
implements Closeable,
Lockable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSink sink;
    private final boolean client;
    @NotNull
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    @NotNull
    private final Hpack.Writer hpackWriter;
    private static final Logger logger = Logger.getLogger(Http2.class.getName());

    public Http2Writer(@NotNull BufferedSink sink2, boolean client) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        this.sink = sink2;
        this.client = client;
        this.hpackBuffer = new Buffer();
        this.maxFrameSize = 16384;
        this.hpackWriter = new Hpack.Writer(0, false, this.hpackBuffer, 3, null);
    }

    @NotNull
    public final Hpack.Writer getHpackWriter() {
        return this.hpackWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connectionPreface() throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            if (!this.client) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(_UtilJvmKt.format(">> CONNECTION " + Http2.CONNECTION_PREFACE.hex(), new Object[0]));
            }
            this.sink.write(Http2.CONNECTION_PREFACE);
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void applyAndAckSettings(@NotNull Settings peerSettings) throws IOException {
        Intrinsics.checkNotNullParameter(peerSettings, "peerSettings");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            this.maxFrameSize = peerSettings.getMaxFrameSize(this.maxFrameSize);
            if (peerSettings.getHeaderTableSize() != -1) {
                this.hpackWriter.resizeHeaderTable(peerSettings.getHeaderTableSize());
            }
            this.frameHeader(0, 0, 4, 1);
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushPromise(int streamId, int promisedStreamId, @NotNull List<Header> requestHeaders) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            this.hpackWriter.writeHeaders(requestHeaders);
            long byteCount = this.hpackBuffer.size();
            int length = (int)Math.min((long)this.maxFrameSize - 4L, byteCount);
            this.frameHeader(streamId, length + 4, 5, byteCount == (long)length ? 4 : 0);
            this.sink.writeInt(promisedStreamId & Integer.MAX_VALUE);
            this.sink.write(this.hpackBuffer, (long)length);
            if (byteCount > (long)length) {
                this.writeContinuationFrames(streamId, byteCount - (long)length);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rstStream(int streamId, @NotNull ErrorCode errorCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            if (!(errorCode.getHttpCode() != -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.frameHeader(streamId, 4, 3, 0);
            this.sink.writeInt(errorCode.getHttpCode());
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final int maxDataLength() {
        return this.maxFrameSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void data(boolean outFinished, int streamId, @Nullable Buffer source2, int byteCount) throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            int flags = 0;
            if (outFinished) {
                flags |= 1;
            }
            this.dataFrame(streamId, flags, source2, byteCount);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void dataFrame(int streamId, int flags, @Nullable Buffer buffer, int byteCount) throws IOException {
        this.frameHeader(streamId, byteCount, 0, flags);
        if (byteCount > 0) {
            Buffer buffer2 = buffer;
            Intrinsics.checkNotNull(buffer2);
            this.sink.write(buffer2, (long)byteCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void settings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            this.frameHeader(0, settings.size() * 6, 4, 0);
            for (int i = 0; i < 10; ++i) {
                if (!settings.isSet(i)) continue;
                this.sink.writeShort(i);
                this.sink.writeInt(settings.get(i));
            }
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ping(boolean ack, int payload1, int payload2) throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            this.frameHeader(0, 8, 6, ack ? 1 : 0);
            this.sink.writeInt(payload1);
            this.sink.writeInt(payload2);
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void goAway(int lastGoodStreamId, @NotNull ErrorCode errorCode, @NotNull byte[] debugData) throws IOException {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        Intrinsics.checkNotNullParameter(debugData, "debugData");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            if (!(errorCode.getHttpCode() != -1)) {
                boolean bl2 = false;
                String string = "errorCode.httpCode == -1";
                throw new IllegalArgumentException(string.toString());
            }
            this.frameHeader(0, 8 + debugData.length, 7, 0);
            this.sink.writeInt(lastGoodStreamId);
            this.sink.writeInt(errorCode.getHttpCode());
            if (!(debugData.length == 0)) {
                this.sink.write(debugData);
            }
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void windowUpdate(int streamId, long windowSizeIncrement) throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            if (!(windowSizeIncrement != 0L && windowSizeIncrement <= Integer.MAX_VALUE)) {
                boolean bl2 = false;
                String string = "windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: " + windowSizeIncrement;
                throw new IllegalArgumentException(string.toString());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.INSTANCE.frameLogWindowUpdate(false, streamId, 4, windowSizeIncrement));
            }
            this.frameHeader(streamId, 4, 8, 0);
            this.sink.writeInt((int)windowSizeIncrement);
            this.sink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void frameHeader(int streamId, int length, int type, int flags) throws IOException {
        if (type != 8 && logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(false, streamId, length, type, flags));
        }
        if (!(length <= this.maxFrameSize)) {
            boolean $i$a$-require-Http2Writer$frameHeader$32 = false;
            String $i$a$-require-Http2Writer$frameHeader$32 = "FRAME_SIZE_ERROR length > " + this.maxFrameSize + ": " + length;
            throw new IllegalArgumentException($i$a$-require-Http2Writer$frameHeader$32.toString());
        }
        if (!((streamId & Integer.MIN_VALUE) == 0)) {
            boolean bl = false;
            String string = "reserved bit set: " + streamId;
            throw new IllegalArgumentException(string.toString());
        }
        _UtilCommonKt.writeMedium(this.sink, length);
        this.sink.writeByte(type & 0xFF);
        this.sink.writeByte(flags & 0xFF);
        this.sink.writeInt(streamId & Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this.closed = true;
            this.sink.close();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void writeContinuationFrames(int streamId, long byteCount) throws IOException {
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            long length = Math.min((long)this.maxFrameSize, byteCount2);
            this.frameHeader(streamId, (int)length, 9, (byteCount2 -= length) == 0L ? 4 : 0);
            this.sink.write(this.hpackBuffer, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void headers(boolean outFinished, int streamId, @NotNull List<Header> headerBlock) throws IOException {
        Intrinsics.checkNotNullParameter(headerBlock, "headerBlock");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            int flags;
            boolean bl = false;
            if (this.closed) {
                throw new IOException("closed");
            }
            this.hpackWriter.writeHeaders(headerBlock);
            long byteCount = this.hpackBuffer.size();
            long length = Math.min((long)this.maxFrameSize, byteCount);
            int n = flags = byteCount == length ? 4 : 0;
            if (outFinished) {
                flags |= 1;
            }
            this.frameHeader(streamId, (int)length, 1, flags);
            this.sink.write(this.hpackBuffer, length);
            if (byteCount > length) {
                this.writeContinuationFrames(streamId, byteCount - length);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/http2/Http2Writer$Companion;", "", "<init>", "()V", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "logger", "Ljava/util/logging/Logger;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

