/*
 * Decompiled with CFR 0.152.
 */
package com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform;

import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.BouncyCastlePlatform;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.ConscryptPlatform;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Jdk9Platform;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.OpenJSSEPlatform;
import com.smushytaco.nickname_detector.shaded.okhttp3.internal.platform.Platform;
import java.security.Security;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/platform/PlatformRegistry;", "", "<init>", "()V", "Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/platform/Platform;", "findPlatform", "()Lcom/smushytaco/nickname_detector/shaded/okhttp3/internal/platform/Platform;", "", "isConscryptPreferred", "()Z", "isOpenJSSEPreferred", "isBouncyCastlePreferred", "isAndroid", "okhttp"})
public final class PlatformRegistry {
    @NotNull
    public static final PlatformRegistry INSTANCE = new PlatformRegistry();

    private PlatformRegistry() {
    }

    private final boolean isConscryptPreferred() {
        String preferredProvider = Security.getProviders()[0].getName();
        return Intrinsics.areEqual("Conscrypt", preferredProvider);
    }

    private final boolean isOpenJSSEPreferred() {
        String preferredProvider = Security.getProviders()[0].getName();
        return Intrinsics.areEqual("OpenJSSE", preferredProvider);
    }

    private final boolean isBouncyCastlePreferred() {
        String preferredProvider = Security.getProviders()[0].getName();
        return Intrinsics.areEqual("BC", preferredProvider);
    }

    @NotNull
    public final Platform findPlatform() {
        OpenJSSEPlatform openJSSE;
        BouncyCastlePlatform bc;
        ConscryptPlatform conscrypt;
        if (this.isConscryptPreferred() && (conscrypt = ConscryptPlatform.Companion.buildIfSupported()) != null) {
            return conscrypt;
        }
        if (this.isBouncyCastlePreferred() && (bc = BouncyCastlePlatform.Companion.buildIfSupported()) != null) {
            return bc;
        }
        if (this.isOpenJSSEPreferred() && (openJSSE = OpenJSSEPlatform.Companion.buildIfSupported()) != null) {
            return openJSSE;
        }
        Jdk9Platform jdk9 = Jdk9Platform.Companion.buildIfSupported();
        if (jdk9 != null) {
            return jdk9;
        }
        Platform jdkWithJettyBoot = Jdk8WithJettyBootPlatform.Companion.buildIfSupported();
        if (jdkWithJettyBoot != null) {
            return jdkWithJettyBoot;
        }
        return new Platform();
    }

    public final boolean isAndroid() {
        return false;
    }
}

