/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileMetadata;
import okio.JvmSystemFileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\tH\u0004\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lokio/NioSystemFileSystem;", "Lokio/JvmSystemFileSystem;", "<init>", "()V", "Lokio/Path;", "path", "Lokio/FileMetadata;", "metadataOrNull", "(Lokio/Path;)Lokio/FileMetadata;", "Ljava/nio/file/Path;", "nioPath", "(Ljava/nio/file/Path;)Lokio/FileMetadata;", "Ljava/nio/file/attribute/FileTime;", "", "zeroToNull", "(Ljava/nio/file/attribute/FileTime;)Ljava/lang/Long;", "source", "target", "", "atomicMove", "(Lokio/Path;Lokio/Path;)V", "createSymlink", "", "toString", "()Ljava/lang/String;", "okio"})
@SourceDebugExtension(value={"SMAP\nNioSystemFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioSystemFileSystem.kt\nokio/NioSystemFileSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public class NioSystemFileSystem
extends JvmSystemFileSystem {
    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.metadataOrNull(path.toNioPath());
    }

    @Nullable
    protected final FileMetadata metadataOrNull(@NotNull java.nio.file.Path nioPath) {
        Object object;
        Intrinsics.checkNotNullParameter(nioPath, "nioPath");
        try {
            object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            object = Files.readAttributes(nioPath, BasicFileAttributes.class, (LinkOption[])object);
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
        catch (FileSystemException fileSystemException) {
            return null;
        }
        Object attributes = object;
        java.nio.file.Path symlinkTarget = attributes.isSymbolicLink() ? Files.readSymbolicLink(nioPath) : null;
        java.nio.file.Path path = symlinkTarget;
        FileTime fileTime = attributes.creationTime();
        FileTime fileTime2 = attributes.lastModifiedTime();
        FileTime fileTime3 = attributes.lastAccessTime();
        return new FileMetadata(attributes.isRegularFile(), attributes.isDirectory(), path != null ? Path.Companion.get$default(Path.Companion, path, false, 1, null) : null, attributes.size(), fileTime != null ? this.zeroToNull(fileTime) : null, fileTime2 != null ? this.zeroToNull(fileTime2) : null, fileTime3 != null ? this.zeroToNull(fileTime3) : null, null, 128, null);
    }

    private final Long zeroToNull(FileTime $this$zeroToNull) {
        Long l = $this$zeroToNull.toMillis();
        long it = ((Number)l).longValue();
        boolean bl = false;
        return it != 0L ? l : null;
    }

    @Override
    public void atomicMove(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(source2.toNioPath(), target.toNioPath(), copyOptionArray);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            throw new IOException("atomic move not supported");
        }
    }

    @Override
    public void createSymlink(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        Files.createSymbolicLink(source2.toNioPath(), target.toNioPath(), new FileAttribute[0]);
    }

    @Override
    @NotNull
    public String toString() {
        return "NioSystemFileSystem";
    }
}

