/*
 * Decompiled with CFR 0.152.
 */
package okio;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.AsyncTimeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001f\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001c\u0010\u0012\u001a\u00020\f*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0082\n\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00168\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lokio/PriorityQueue;", "", "<init>", "()V", "Lokio/AsyncTimeout;", "first", "()Lokio/AsyncTimeout;", "node", "", "add", "(Lokio/AsyncTimeout;)V", "remove", "", "vacantIndex", "heapifyUp", "(ILokio/AsyncTimeout;)V", "heapifyDown", "other", "compareTo", "(Lokio/AsyncTimeout;Lokio/AsyncTimeout;)I", "size", "I", "", "array", "[Lokio/AsyncTimeout;", "okio"})
@SourceDebugExtension(value={"SMAP\nAsyncTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncTimeout.kt\nokio/PriorityQueue\n*L\n1#1,504:1\n499#1,3:505\n499#1,3:508\n499#1,3:511\n499#1,3:514\n*S KotlinDebug\n*F\n+ 1 AsyncTimeout.kt\nokio/PriorityQueue\n*L\n408#1:505,3\n441#1:508,3\n474#1:511,3\n484#1:514,3\n*E\n"})
public final class PriorityQueue {
    @JvmField
    public int size;
    @JvmField
    @NotNull
    public AsyncTimeout[] array = new AsyncTimeout[8];

    @Nullable
    public final AsyncTimeout first() {
        return this.array[1];
    }

    public final void add(@NotNull AsyncTimeout node) {
        int newSize;
        Intrinsics.checkNotNullParameter(node, "node");
        this.size = newSize = this.size + 1;
        if (newSize == this.array.length) {
            Object[] doubledArray = new AsyncTimeout[newSize * 2];
            ArraysKt.copyInto$default(this.array, doubledArray, 0, 0, 0, 14, null);
            this.array = doubledArray;
        }
        this.heapifyUp(newSize, node);
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(@NotNull AsyncTimeout node) {
        void $this$compareTo$iv;
        Intrinsics.checkNotNullParameter(node, "node");
        if (!(node.index != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int oldSize = this.size;
        int removedIndex = node.index;
        AsyncTimeout asyncTimeout = this.array[oldSize];
        Intrinsics.checkNotNull(asyncTimeout);
        AsyncTimeout last = asyncTimeout;
        node.index = -1;
        this.array[oldSize] = null;
        this.size = oldSize - 1;
        if (node == last) {
            return;
        }
        PriorityQueue priorityQueue = this;
        AsyncTimeout asyncTimeout2 = node;
        AsyncTimeout other$iv = last;
        boolean $i$f$compareTo = false;
        long a$iv = $this$compareTo$iv.timeoutNanos();
        long b$iv = other$iv.timeoutNanos();
        int nodeCompareToLast = Intrinsics.compare(0L, b$iv - a$iv);
        if (nodeCompareToLast == 0) {
            this.array[removedIndex] = last;
            last.index = removedIndex;
        } else if (nodeCompareToLast < 0) {
            this.heapifyDown(removedIndex, last);
        } else {
            this.heapifyUp(removedIndex, last);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void heapifyUp(int vacantIndex, AsyncTimeout node) {
        int parentIndex;
        int vacantIndex2 = vacantIndex;
        while ((parentIndex = vacantIndex2 >> 1) != 0) {
            void $this$compareTo$iv;
            AsyncTimeout parentNode;
            Intrinsics.checkNotNull(this.array[parentIndex]);
            PriorityQueue priorityQueue = this;
            AsyncTimeout asyncTimeout = parentNode;
            AsyncTimeout other$iv = node;
            boolean $i$f$compareTo = false;
            long a$iv = $this$compareTo$iv.timeoutNanos();
            long b$iv = other$iv.timeoutNanos();
            if (Intrinsics.compare(0L, b$iv - a$iv) <= 0) break;
            parentNode.index = vacantIndex2;
            this.array[vacantIndex2] = parentNode;
            vacantIndex2 = parentIndex;
        }
        this.array[vacantIndex2] = node;
        node.index = vacantIndex2;
    }

    /*
     * WARNING - void declaration
     */
    private final void heapifyDown(int vacantIndex, AsyncTimeout node) {
        int vacantIndex2 = vacantIndex;
        while (true) {
            void $this$compareTo$iv;
            Object object;
            AsyncTimeout rightNode;
            Object leftNode;
            int leftIndex = vacantIndex2 << 1;
            int rightIndex = leftIndex + 1;
            if (rightIndex <= this.size) {
                void $this$compareTo$iv2;
                AsyncTimeout asyncTimeout = this.array[leftIndex];
                Intrinsics.checkNotNull(asyncTimeout);
                leftNode = asyncTimeout;
                AsyncTimeout asyncTimeout2 = this.array[rightIndex];
                Intrinsics.checkNotNull(asyncTimeout2);
                rightNode = asyncTimeout2;
                PriorityQueue priorityQueue = this;
                Object object2 = leftNode;
                AsyncTimeout other$iv = rightNode;
                boolean $i$f$compareTo = false;
                long a$iv = $this$compareTo$iv2.timeoutNanos();
                long b$iv = other$iv.timeoutNanos();
                object = Intrinsics.compare(0L, b$iv - a$iv) < 0 ? leftNode : rightNode;
            } else {
                if (leftIndex > this.size) break;
                AsyncTimeout asyncTimeout = this.array[leftIndex];
                object = asyncTimeout;
                Intrinsics.checkNotNull(asyncTimeout);
            }
            AsyncTimeout smallestChild = object;
            leftNode = this;
            rightNode = node;
            AsyncTimeout other$iv = smallestChild;
            boolean $i$f$compareTo = false;
            long a$iv = $this$compareTo$iv.timeoutNanos();
            long b$iv = other$iv.timeoutNanos();
            if (Intrinsics.compare(0L, b$iv - a$iv) <= 0) break;
            int newVacantIndex = smallestChild.index;
            smallestChild.index = vacantIndex2;
            this.array[vacantIndex2] = smallestChild;
            vacantIndex2 = newVacantIndex;
        }
        this.array[vacantIndex2] = node;
        node.index = vacantIndex2;
    }

    private final int compareTo(AsyncTimeout $this$compareTo, AsyncTimeout other) {
        Intrinsics.checkNotNullParameter($this$compareTo, "<this>");
        boolean $i$f$compareTo = false;
        long a = $this$compareTo.timeoutNanos();
        long b = other.timeoutNanos();
        return Intrinsics.compare(0L, b - a);
    }
}

