/*
 * Decompiled with CFR 0.152.
 */
package com.acheli;

import com.acheli.registry.block.ACHBlocks;
import com.acheli.registry.config.Config;
import com.acheli.registry.config.CustomDataBus;
import com.acheli.registry.entity.ACHEntities;
import com.acheli.registry.entity.model.OBJModelRegistry;
import com.acheli.registry.entity.render.ACHEntitiesRenderBus;
import com.acheli.registry.event.CustomDynamicEntityPool;
import com.acheli.registry.factories.ACHFactories;
import com.acheli.registry.item.ACHItems;
import com.acheli.registry.keybind.KeyBinding;
import com.acheli.registry.network.ACHMessages;
import com.acheli.registry.network.packet.VehiclePackRloadEventC2SPacket;
import com.acheli.rideable.entites.ComponentEntity;
import com.acheli.rideable.entites.RideableEntity;
import com.acheli.rideable.factory.ACHeliEntitiesFactory;
import com.acheli.rideable.factory.SafetyFactoryProvider;
import com.acheli.rideable.functionLathes.ComponentFL;
import com.acheli.rideable.functionLathes.RideableFL;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="archers_helicopter")
public class ACHeli {
    public static final String MODID = "archers_helicopter";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static int tickCount = 0;
    private static int lastSendTick = 0;
    public static HashMap<String, Class<?>> EntitiesFactoryRegisterMap = new HashMap();

    public ACHeli(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        CustomDataBus.load();
        modEventBus.addListener(this::commonSetup);
        ACHFactories.register();
        ACHBlocks.register(modEventBus);
        ACHItems.register(modEventBus);
        OBJModelRegistry.register(modEventBus);
        ACHEntities.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(ACHItems::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
        ACHMessages.register();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onPreparableReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener(new PreparableReloadListener(){

            public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier pPreparationBarrier, ResourceManager pResourceManager, ProfilerFiller pPreparationsProfiler, ProfilerFiller pReloadProfiler, Executor pBackgroundExecutor, Executor pGameExecutor) {
                CustomDataBus.load();
                List<Entity> list = CustomDynamicEntityPool.entityMap.get(RideableEntity.class);
                for (Entity entity : list) {
                    if (!(entity instanceof RideableEntity)) continue;
                    RideableEntity rideableEntity = (RideableEntity)entity;
                    rideableEntity.reloadData();
                }
                return null;
            }
        });
    }

    @Mod.EventBusSubscriber(modid="archers_helicopter", value={Dist.CLIENT})
    public static class ClientOnKeyEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            Entity entity;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (entity = player.m_20202_()) instanceof ComponentEntity) {
                ComponentEntity componentEntity = (ComponentEntity)entity;
                componentEntity.doFactory(new SafetyFactoryProvider<ACHeliEntitiesFactory<ComponentEntity, ComponentFL>>(){

                    @Override
                    public void getFct(ACHeliEntitiesFactory<ComponentEntity, ComponentFL> factory) {
                        factory.getProductFunction().keyEvent();
                        factory.getProductFunction().getFL().keyEvent();
                    }
                });
                Entity entity2 = componentEntity.m_20202_();
                if (entity2 instanceof RideableEntity) {
                    RideableEntity rideable = (RideableEntity)entity2;
                    rideable.doFactory(new SafetyFactoryProvider<ACHeliEntitiesFactory<RideableEntity, RideableFL>>(){

                        @Override
                        public void getFct(ACHeliEntitiesFactory<RideableEntity, RideableFL> factory) {
                            factory.getProductFunction().keyEvent();
                            factory.getProductFunction().getFL().keyEvent();
                        }
                    });
                }
            }
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
        }

        @SubscribeEvent
        public static void onEntitySpawn(EntityJoinLevelEvent event) {
            if (event.getLevel().m_5776_()) {
                CustomDynamicEntityPool.joinEvent(event);
            }
        }

        @SubscribeEvent
        public static void onEntityLeave(EntityLeaveLevelEvent event) {
            if (event.getLevel().m_5776_()) {
                CustomDynamicEntityPool.leaveEvent(event);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForgeHandler {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                ++tickCount;
            } else if (event.phase == TickEvent.Phase.END) {
                // empty if block
            }
        }
    }

    @Mod.EventBusSubscriber(modid="archers_helicopter", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ACHEntitiesRenderBus.init(event);
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            KeyBinding.register(event);
        }

        @SubscribeEvent
        public static void onTextureStitchEvent(TextureStitchEvent event) {
            LocalPlayer player;
            boolean pass;
            int tick = tickCount;
            boolean bl = pass = lastSendTick == 0;
            if ((pass || tick - lastSendTick > 20) && (player = Minecraft.m_91087_().f_91074_) != null && player.m_9236_().f_46443_) {
                ACHMessages.sendToServer(new VehiclePackRloadEventC2SPacket());
                CustomDataBus.load();
                List<Entity> list = CustomDynamicEntityPool.entityMap.get(RideableEntity.class);
                for (Entity entity : list) {
                    if (!(entity instanceof RideableEntity)) continue;
                    RideableEntity rideableEntity = (RideableEntity)entity;
                    rideableEntity.reloadData();
                }
                lastSendTick = tickCount;
                player.m_213846_((Component)Component.m_237113_((String)"[acheli] You has reloaded the vehicle packs."));
            }
        }
    }
}

