/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="archers_helicopter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final Path MINECRAFT_DIR = Minecraft.m_91087_().f_91069_.toPath();
    public static final Path CUSTOM_CONFIG_PATH = MINECRAFT_DIR.resolve("config").resolve("archers_helicopter");
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue LOG_DIRT_BLOCK = BUILDER.comment("Whether to log the dirt block on common setup").define("logDirtBlock", true);
    private static final ForgeConfigSpec.IntValue MAGIC_NUMBER = BUILDER.comment("A magic number").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION = BUILDER.comment("What you want the introduction message to be for the magic number").define("magicNumberIntroduction", (Object)"The magic number is... ");
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean logDirtBlock;
    public static int magicNumber;
    public static String magicNumberIntroduction;
    public static Set<Item> items;

    public static Object loadConfig(String fileName, Object configData) {
        Path FilePath = CUSTOM_CONFIG_PATH.resolve(fileName);
        Gson gson = new Gson();
        try {
            if (!Files.exists(FilePath, new LinkOption[0])) {
                Config.createDefaultConfig(FilePath, configData);
            }
            String json = Files.readString(FilePath);
            configData = gson.fromJson(json, configData.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return configData;
    }

    private static void createDefaultConfig(Path filePath, Object configData) throws IOException {
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(configData);
        Files.writeString(filePath, (CharSequence)json, new OpenOption[0]);
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
        magicNumber = (Integer)MAGIC_NUMBER.get();
        magicNumberIntroduction = (String)MAGIC_NUMBER_INTRODUCTION.get();
        items = ((List)ITEM_STRINGS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
    }
}

