/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.event;

import com.acheli.registry.network.ACHMessages;
import com.acheli.registry.network.packet.EntityJoinC2SPacket;
import com.acheli.registry.network.packet.EntityLeaveC2SPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;

public class CustomDynamicEntityPool {
    public static HashMap<Class<? extends Entity>, List<Entity>> entityMap = new HashMap();

    public static void join(Entity entity) {
        Class<?> entityClass = entity.getClass();
        entityMap.computeIfAbsent(entityClass, k -> new ArrayList()).add(entity);
    }

    public static void leave(Entity entity) {
        Class<?> entityClass = entity.getClass();
        List<Entity> entities = entityMap.get(entityClass);
        if (entities != null) {
            entities.remove(entity);
            if (entities.isEmpty()) {
                entityMap.remove(entityClass);
            }
        }
    }

    public static void joinEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        CustomDynamicEntityPool.join(entity);
        ACHMessages.sendToServer(new EntityJoinC2SPacket(entity.m_19879_()));
    }

    public static void leaveEvent(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        CustomDynamicEntityPool.leave(entity);
        ACHMessages.sendToServer(new EntityLeaveC2SPacket(entity.m_19879_()));
    }
}

