/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.item;

import com.acheli.ACHeli;
import com.acheli.registry.entity.ACHEntities;
import com.acheli.registry.factories.ACHFactories;
import com.acheli.registry.network.ACHMessages;
import com.acheli.registry.network.packet.RideableSpawnS2CPacket;
import com.acheli.rideable.entites.RideableEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ACHItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"archers_helicopter");
    public static final RegistryObject<Item> EXAMPLE_ITEM = ITEMS.register("example_item", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(1).m_38758_(2.0f).m_38767_())));
    public static RegistryObject<Item> UH_1D_SAR_SPAWN_EGG = ACHItems.rideableSpawnerProvider(ITEMS, ACHFactories.UH_1D_SAR_FACTORY);
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"archers_helicopter");
    public static final RegistryObject<CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> ((Item)EXAMPLE_ITEM.get()).m_7968_()).m_257501_((parameters, output) -> output.m_246326_((ItemLike)UH_1D_SAR_SPAWN_EGG.get())).m_257652_());

    public static RegistryObject<Item> rideableSpawnerProvider(DeferredRegister<Item> ITE, final String factoryName) {
        String tagName = factoryName + "_spawn_egg";
        ACHeli.LOGGER.info("Rideable SpawnEgg:  " + tagName + "  has been register.");
        return ITE.register(tagName, () -> new Item(new Item.Properties()){

            public InteractionResult m_6225_(UseOnContext context) {
                Level level = context.m_43725_();
                if (!level.f_46443_) {
                    RideableEntity entity = new RideableEntity((EntityType)ACHEntities.RIDEABLE_ENTITY_TYPE.get(), level);
                    entity.setUp(factoryName);
                    entity.m_146884_(context.m_43720_());
                    level.m_7967_((Entity)entity);
                    RideableSpawnS2CPacket packet = new RideableSpawnS2CPacket(entity.m_19879_(), factoryName);
                    ACHMessages.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)packet);
                }
                return InteractionResult.SUCCESS;
            }
        });
    }

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.accept(UH_1D_SAR_SPAWN_EGG);
        }
    }

    public static void register(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
    }
}

