/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.network.packet;

import com.acheli.ACHeli;
import com.acheli.registry.network.ACHMessages;
import com.acheli.rideable.entites.ComponentEntity;
import com.acheli.rideable.entites.RideableEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class ComponentSetupC2SPacket {
    private final CompoundTag tag;

    public ComponentSetupC2SPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
    }

    public ComponentSetupC2SPacket(UUID rideableUUID, UUID componentUUID, String ID) {
        this.tag = new CompoundTag();
        this.tag.m_128359_("ID", ID);
        this.tag.m_128362_("rideableUUID", rideableUUID);
        this.tag.m_128362_("componentUUID", componentUUID);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
    }

    private boolean handle(Supplier<NetworkEvent.Context> supplier) {
        String ID = this.tag.m_128461_("ID");
        UUID rideableUUID = this.tag.m_128342_("rideableUUID");
        UUID componentUUID = this.tag.m_128342_("componentUUID");
        ACHeli.LOGGER.info("ComponentSetupC2SPacket => ID: " + ID);
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerLevel level;
            Entity patt1958$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt1958$temp = (level = player.m_284548_()).m_8791_(rideableUUID)) instanceof RideableEntity) {
                RideableEntity rideable = (RideableEntity)patt1958$temp;
                Entity patt2053$temp = level.m_8791_(componentUUID);
                if (patt2053$temp instanceof ComponentEntity) {
                    ComponentEntity component = (ComponentEntity)patt2053$temp;
                    component.setUp(rideable, rideable.factory.getProductFunction().getFL().getcomponentFLByID(ID));
                }
            }
        });
        return true;
    }

    public static void register(SimpleChannel channel) {
        channel.messageBuilder(ComponentSetupC2SPacket.class, ACHMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ComponentSetupC2SPacket::new).encoder(ComponentSetupC2SPacket::toBytes).consumerMainThread(ComponentSetupC2SPacket::handle).add();
    }
}

