/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.network.packet;

import com.acheli.ACHeli;
import com.acheli.registry.entity.ACHEntities;
import com.acheli.registry.network.ACHMessages;
import com.acheli.registry.network.packet.ComponentSpawnS2CPacket;
import com.acheli.rideable.entites.ComponentEntity;
import com.acheli.rideable.entites.RideableEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ComponentSpawnC2SPacket {
    private final CompoundTag tag;

    public ComponentSpawnC2SPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
    }

    public ComponentSpawnC2SPacket(UUID rideableUUID, String id) {
        this.tag = new CompoundTag();
        this.tag.m_128359_("ID", id);
        this.tag.m_128362_("rideableUUID", rideableUUID);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
    }

    private boolean handle(Supplier<NetworkEvent.Context> supplier) {
        String ID = this.tag.m_128461_("ID");
        UUID rideableUUID = this.tag.m_128342_("rideableUUID");
        ACHeli.LOGGER.info("ComponentSpawnC2SPacket => ID: " + ID);
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerLevel level;
            Entity patt1824$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt1824$temp = (level = player.m_284548_()).m_8791_(rideableUUID)) instanceof RideableEntity) {
                RideableEntity rideable = (RideableEntity)patt1824$temp;
                ComponentEntity component = new ComponentEntity((EntityType)ACHEntities.RIDEABLE_COMPONENT_ENTITY_TYPE.get(), (Level)level, rideable, rideable.factory.getProductFunction().getFL().getcomponentFLByID(ID));
                component.setID(ID);
                component.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                level.m_7967_((Entity)component);
                component.m_7998_(rideable, true);
                ComponentSpawnS2CPacket packet = new ComponentSpawnS2CPacket(ID, component.m_19879_(), rideable.m_19879_());
                ACHMessages.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> rideable), (Object)packet);
            }
        });
        return true;
    }

    public static void register(SimpleChannel channel) {
        channel.messageBuilder(ComponentSpawnC2SPacket.class, ACHMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ComponentSpawnC2SPacket::new).encoder(ComponentSpawnC2SPacket::toBytes).consumerMainThread(ComponentSpawnC2SPacket::handle).add();
    }
}

